import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.karborproxy.utils import KarborProxyOperation
from plugins.CSBS.common.upgrade.params import ParamsStore
from plugins.CSBS.common.step_base import UpgradeBaseSubJob


logger.init("KarborProxy")


class PreCheckProxyState(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(PreCheckProxyState, self).__init__(project_id, pod_id, regionid_list)
        self.proxy = KarborProxyOperation(self.project_id)
        self.params_store = ParamsStore(project_id, pod_id, self.region_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        check_results = []
        check_config = self.params_store.get_check_config("PreCheckProxy")
        try:
            check_results = self.proxy.check_proxy_service_result(check_results, check_config)
        except Exception as error:
            logger.error(f"Check KarborProxy service state fail, err_msg:{str(error)}.")
            return Message(500, HCCIException(645053))
        return Message(200, check_results=check_results)
