#  define params models
from collections import namedtuple

ProjectScene = namedtuple('project_scene', ['is_csha_scene',
                                            'is_x86_scene',
                                            'is_primary_region',
                                            'is_global_dr_scene',
                                            'region_id'])

UpgradePath = namedtuple('upgrade_path', ['current_upgrade_path',
                                          'current_version',
                                          'karbor_full_version',
                                          'original_version',
                                          'target_version',
                                          'pkg_path',
                                          'karbor_pkg_name',
                                          'karbor_pkg_version',
                                          'console_pkg_name',
                                          'console_pkg_version'])

DmkParams = namedtuple('dmk_params', ['account',
                                      'tmp_account_pwd',
                                      'account_pwd',
                                      'account_group',
                                      'float_ip',
                                      'ui_username',
                                      'ui_password',
                                      'os_business_username',
                                      'os_business_password'])

KarborParams = namedtuple('karbor_params', ['djmanager_account_name',
                                            'djmanager_account_pwd',
                                            'root_account_name',
                                            'root_account_pwd'])

ProxyParams = namedtuple('proxy_params', ['dpamanager_account_name',
                                          'dpamanager_account_pwd',
                                          'root_account_name',
                                          'root_account_pwd',
                                          'proxy_ip_dict'])

CBSNode = namedtuple('cbs_node', ['node_ip',
                                  'user',
                                  'user_pwd',
                                  'root_pwd',
                                  'extra'])

ARBNode = namedtuple('arb_node', ['ip',
                                  'user',
                                  'user_pwd',
                                  'root_pwd',
                                  'extra'])

NodeUser = namedtuple('node_user', ['user_name',
                                    'user_pwd',
                                    'root_name',
                                    'root_pwd'])

CipherType = namedtuple("cipher_type", ["cur_cipher_type", "tar_cipher_type"])

LoginParam = namedtuple("login_param", ["console_host", "iam_host", "web_site", "username", "pwd"])
