import time

import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.step_base import UpgradeBaseSubJob
from plugins.CSBS.common.karborproxy.utils import KarborProxyOperation

logger.init("KarborProxy")


class ProxySwitchCipherType(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(ProxySwitchCipherType, self).__init__(project_id, pod_id, regionid_list)
        self.karborproxy_operation = KarborProxyOperation(project_id)

    def execute(self, project_id, pod_id, regionid_list=None):

        cipher_type = self.karborproxy_operation.get_proxy_cipher_type()
        # Switch OS cipher type
        result = self.karborproxy_operation.switch_karborproxy_os_cipher(cipher_type.tar_cipher_type)
        time.sleep(60)
        if not result:
            raise Exception("Failed to switch OS cipher type on karborproxy")
        try:
            result = self.karborproxy_operation.switch_karborproxy_cipher(cipher_type.tar_cipher_type)
        except Exception as err:
            logger.error(f"Execute error:{err}.")
            return Message(500, HCCIException(645041, str(err)))
        if not result:
            logger.error("Failed to switch the cipher type on the KarborProxy node. "
                         f"The cipher type to be switched is {cipher_type.tar_cipher_type}.")
            return Message(500, HCCIException(645047, cipher_type.tar_cipher_type))
        proxy_cipher_type = self.karborproxy_operation.get_karborproxy_cur_cipher_type()
        if proxy_cipher_type != cipher_type.tar_cipher_type:
            raise Exception(f"The cipher type of the KarborProxy node "
                            f"is different from that of the target cipher "
                            f"type, KarborProxy cipher type "
                            f"is: {proxy_cipher_type}, target cipher "
                            f"type is: {cipher_type.tar_cipher_type}.")
        logger.info("The cipher type has been switched successfully.")
        return Message(200)
