import utils.common.log as logger
from utils.business.install_csp_agent import CSPAgent
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.common.karbor import KarborUtil

logger.init("CSBS")


class InstallCspAgent(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(InstallCspAgent, self).__init__(project_id, pod_id, regionid_list)
        self.service_name = "CSBS-VBS"
        self.karbor_util = KarborUtil(project_id, pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self._install_csp_agent()
        except HCCIException as err:
            logger.error("Failed to install csp agent, err_msg:{}.".format(str(err)))
            return Message(500, err)
        except Exception as err:
            logger.error("Failed to execute InstallCSPAgent, err_msg:{}.".format(str(err)))
            return Message(500, HCCIException(640086, str(err)))

        return Message(200)

    def _install_csp_agent(self):
        logger.info("Start to install csp agent for {} service.".format(self.service_name))
        karbor_node_list = self._get_karbor_node_list()
        ret_dic = CSPAgent(self.pod_id).install_csp_agent(service_name=self.service_name,
                                                          node_list=karbor_node_list)

        if ret_dic["result_code"] != "0":
            raise Exception("Install csp agent failed, result code:[{}].".format(ret_dic["result_code"]))
        logger.info("Succeed to install csp agent for {} service.".format(self.service_name))

    def _get_karbor_node_list(self):
        karbor_node_list = self.karbor_util.get_karbor_node_list()
        logger.info("Succeed to obtain karbor ips, "
                    "karbor ip list is:{}.".format([node.node_ip for node in karbor_node_list]))
        node_list = []
        for node in karbor_node_list:
            node_info = {
                "node_ip": node.node_ip,
                "process_username": node.user,
                "user_password": node.user_pwd,
                "sudo_cmd": "sudo su",
                "root_password": node.root_pwd
            }
            node_list.append(node_info)
        return node_list
