import time

import utils.common.log as logger
from plugins.CSBS.common.karborproxy.utils import KarborProxyOperation

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.common.karborproxy.agent_proxy_param import AgentProxy
from plugins.CSBS.common.karborproxy.project_set import project_preset
from plugins.CSBS.common.karborproxy.shell_cmd import ShellCmd
from plugins.CSBS.common.karborproxy.ssh_cmd import SShCmd


class AgentProxyConfigHA(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        logger.init("AgentProxyConfigHA")
        super(AgentProxyConfigHA, self).__init__(project_id, pod_id, regionid_list)
        self.ssh = SShCmd(project_id, pod_id)
        self.proxy_util = KarborProxyOperation(project_id)
        self.agent_proxy = AgentProxy(project_id, pod_id)

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        if not self.agent_proxy.is_ha_scene:
            logger.info('This is not a DR HA scenario.')
            return
        self._config_ha_to_karborproxy()
        self._restart_omm_ha_karborproxy()
        self._check_omm_ha_status_karborproxy()

    def _config_ha_to_karborproxy(self):
        logger.info("Deployment kaborproxy ha start.")
        api_info = self.agent_proxy.get_arb_api_info()[0]
        cmd = ShellCmd.config_ha % api_info[0:3]
        self.ssh.ssh_exe_config_ha_cmd(cmd, api_info[-1])
        logger.info("Deployment kaborproxy ha success.")

    def _restart_omm_ha_karborproxy(self):
        logger.info("Deployment kaborproxy omm-ha restart.")
        restart_omm_cmd = 'omm-haControl -A RESTART'
        self.ssh.ssh_cmds_to_all_proxys(restart_omm_cmd)
        time.sleep(60)

    def _check_omm_ha_status_karborproxy(self):
        logger.info("Deployment kaborproxy omm-ha check status start.")
        self.config_ha_retry()

    def config_ha_retry(self):
        retry_count = 0
        while retry_count < 10:
            try:
                self.check_omm_ha_status()
                break
            except Exception as err:
                logger.error("ssh connect failed.%s" % err)
                retry_count = retry_count + 1
                if retry_count == 10:
                    raise Exception('Failed to configure the OMM HA.') from err
                time.sleep(60)

    def check_omm_ha_status(self):
        query_ha_status_cmd = 'omm-haControl -CS CompontState;' \
                              'echo check omm_ha status $?'
        for node in self.proxy_util.get_proxy_node_list():
            ha_success_status = ['0', '2', '3']
            self.ssh.ssh_cmds(node, query_ha_status_cmd, ha_success_status)
