import utils.common.log as logger

from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.step_base import BaseStep

logger.init("CSBS")


class TurnOffPriceSwitch(BaseStep):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(TurnOffPriceSwitch, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_util = KarborUtil(self.project_id, self.pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self.karbor_util.set_price_rate_switch("false")
        except Exception as err:
            logger.error(f'Execute error:{err}')
            return Message(500, HCCIException(640138, err))
        return Message(200)
