from utils.business.project_condition_utils import get_project_condition_boolean
from utils.common.exception import HCCIException
from utils.common.message import Message
from utils.common.message import RESULT_CODE

from plugins.CSBS.common.dmk_tool import DmkTool
from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.step_base import UpgradeBaseSubJob
from plugins.CSBS.common.karborproxy.utils import KarborProxyOperation


class InstallAgent(UpgradeBaseSubJob):
    def execute(self, project_id, pod_id, regionid_list=None):
        dmk_tools = DmkTool(project_id, pod_id)
        karbor_nodes = KarborUtil(project_id, pod_id).get_karbor_node_list()
        node_names = ["CSBS-Karbor-01", "CSBS-Karbor-02", "CSBS-Karbor-03"]
        if not dmk_tools.install_maglev_agent(karbor_nodes, node_names):
            return Message(RESULT_CODE['ERROR'], HCCIException(640137))

        if not get_project_condition_boolean(self.project_id, "InstalledCSBSProxy"):
            return Message(RESULT_CODE['SUCCESS'])

        proxy_nodes = KarborProxyOperation(project_id).get_proxy_node_list()
        node_names = ["CSBS-KarborProxy-01", "CSBS-KarborProxy-02"]
        if not dmk_tools.install_maglev_agent(proxy_nodes, node_names):
            return Message(RESULT_CODE['ERROR'], HCCIException(640137))
        return Message(RESULT_CODE['SUCCESS'])
