#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.constant import RegisterToMOInfo
from plugins.CSBS.common.params_tool import ParamTool
from plugins.CSBS.common.register_silvan import RegisterSilvan
from plugins.CSBS.common.step_base import UpgradeBaseSubJob

logger.init("Register Operation")


class RegisterOperation(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)
        self.csbs_id = "csbs"
        self.vbs_id = "vbs"
        self.param_tool = ParamTool(self.project_id, self.pod_id)
        self.console_domain_name = self.param_tool.get_console_domain_name()
        self.register_silvan = RegisterSilvan(self.project_id, self.pod_id)
        self.register_info = RegisterToMOInfo(self.region_id, self.console_domain_name)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self._upgrade_endpoint()
            self._register_query_expenses_notification()
        except Exception as err:
            logger.error(f"Failed to register operation, error:{str(err)}.")
            return Message(500, HCCIException("645072", err))
        return Message(200)

    def _upgrade_endpoint(self):
        logger.info("Upgrade endpoints.")
        result = self.register_silvan.update_endpoint(self.csbs_id, self.register_info.csbs_endpoint_info_zh,
                                                      self.register_info.csbs_endpoint_info_en) \
                 and self.register_silvan.update_endpoint(self.vbs_id, self.register_info.vbs_endpoint_info_zh,
                                                          self.register_info.vbs_endpoint_info_en)
        if not result:
            logger.error("Upgrade endpoints failed!")
            raise HCCIException('645071')

    def _register_query_expenses_notification(self):
        self.register_silvan.register_notifications(
            self.register_info.get_query_expenses_notification_info(self.csbs_id))
        self.register_silvan.register_notifications(
            self.register_info.get_query_expenses_notification_info(self.vbs_id))
