import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.ssh_client import SshClient
from plugins.CSBS.common.upgrade.dmk_client import DMKClient
from plugins.CSBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS.common.step_base import UpgradeBaseSubJob

logger.init("CSBS-VBS")


class UpgradeKarbor(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(UpgradeKarbor, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_operation = KarborOperation(self.project_id)
        self.dmk_client = DMKClient(self.params_store)
        self.ssh_client = SshClient()

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info("Login dmk and call DMK to upgrade Karbor.")
        action = "[Upgrade] CSBS-VBS Karbor"
        try:
            result = self.dmk_client.dmk_deploy_karbor(action, self.upgrade_path.karbor_pkg_version)
        except Exception as err:
            logger.error(f"Failed to upgrade Karbor, reason:{str(err)}.")
            return Message(500, HCCIException(645011))
        if not result:
            logger.error("Failed to upgrade Karbor.")
            return Message(500, HCCIException(645011))
        logger.info("Upgrade Karbor successfully.")
        # stop karbor operation service
        self.karbor_operation.change_operation_service(tar_status="stop")
        self.karbor_operation.set_max_sync_time_interval_allowed(60)
        return Message(200)
