import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.upgrade.dmk_client import DMKClient
from plugins.CSBS.common.ssh_client import SshClient
from plugins.CSBS.common.step_base import UpgradeBaseSubJob
from plugins.CSBS.common.upgrade.karbor import KarborOperation

logger.init("CSBS-VBS")


class UploadKarborPkg(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(UploadKarborPkg, self).__init__(project_id, pod_id, regionid_list)
        self.dmk_client = DMKClient(self.params_store)
        self.ssh_client = SshClient()
        self.karbor_operation = KarborOperation(self.project_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Upload Karbor upgrade package to karbor nodes
        """
        logger.info("Login dmk and call DMK to upload Karbor upgrade pkg.")
        action = "[Upload] CSBS-VBS Karbor Package"
        try:
            result = self.dmk_client.dmk_deploy_karbor(action, self.upgrade_path.karbor_pkg_version)
        except Exception as err:
            logger.error(f"Upload karbor package to Karbor nodes error, err_msg:{str(err)}.")
            return Message(500, HCCIException(645005))
        if not result:
            logger.error("Failed to upload Karbor upgrade pkg to the service VM.")
            return Message(500, HCCIException(645005))
        self._del_abnormal_data()
        logger.info("Upload Karbor upgrade pkg to VM successfully.")
        return Message(200)

    def _del_abnormal_data(self):
        source_env = 'export PATH=/opt/huawei/dj/bin/gaussdb/app/bin:${PATH};' \
                     'export GAUSSHOME=/opt/huawei/dj/bin/gaussdb/app;' \
                     'export GAUSSDATA=/opt/huawei/dj/bin/gaussdb/data;' \
                     'export PGSSLCERT=/opt/huawei/dj/bin/gaussdb/cert/client.crt;' \
                     'export PGSSLKEY=/opt/huawei/dj/bin/gaussdb/cert/client.key;' \
                     'export PGSSLROOTCERT=/opt/huawei/dj/bin/gaussdb/cert/ca-cert.pem;' \
                     'export PGSSLMODE=require'
        exec_sql = 'gsql cms -U $(get_info gaussdb_admin_user) -W $(decrypt_pwd "$(get_info gaussdb_admin_pwd)") ' \
                   '-h $(get_info gaussdb_float_ip) -c "%s"'
        sql1 = "delete from config_info where key='kmc_crypt_pwd';"
        sql2 = "DROP TABLE IF EXISTS rabbitmq_status;"
        karbor_client = None
        cmd_timeout = 60
        logger.info(f"Start to delete abnormal data.")
        for k_node in self.karbor_operation.karbor_node_list:
            logger.info(f"Start to execute the command on {k_node.node_ip} node.")
            try:
                karbor_client = self.ssh_client.get_ssh_client(k_node)
                self.ssh_client.ssh_exec_command_return(karbor_client, 'source /opt/huawei/dj/inst/utils.sh',
                                                        cmd_timeout)
                result = self.ssh_client.ssh_exec_command_return(karbor_client, 'get_primary_db_node', cmd_timeout)
                if result[0] != k_node.node_ip:
                    continue
                logger.info(f"Current node {k_node.node_ip} is the primary.")
                self.ssh_client.ssh_exec_command_return(karbor_client, source_env, cmd_timeout)
                result = self.ssh_client.ssh_exec_command_return(karbor_client, exec_sql % sql1, cmd_timeout)
                if not self.ssh_client.is_ssh_cmd_executed(result):
                    logger.warning("Failed to delete kmc_crypt_pwd record.")
                result = self.ssh_client.ssh_exec_command_return(karbor_client, exec_sql % sql2, cmd_timeout)
                if not self.ssh_client.is_ssh_cmd_executed(result):
                    logger.warning("Failed to delete rabbitmq_status table.")
                logger.info(f"Delete abnormal data successfully on {k_node.node_ip} node.")
                break
            finally:
                if karbor_client:
                    self.ssh_client.ssh_close(karbor_client)
