# -*- coding:utf-8 -*-
import utils.common.log as logger

from utils.business.manageone_cmdb_util import ManageOneCmdbUtil
from utils.business.project_util import ProjectApi

from plugins.CSBS.common.step_base import UpgradeBaseSubJob
from plugins.CSBS.common.karborproxy.utils import KarborProxyOperation
from plugins.CSBS.common.karborproxy.project_set import project_preset

logger.init("KarborProxy")


class RollbackCMDB(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.region_id = regionid_list[0]
        self.service_name = "CSBS-VBS"
        self.project_api = ProjectApi()
        self.proxy = KarborProxyOperation(self.project_id)
        self.cmdb_util = ManageOneCmdbUtil(self.project_id, self.pod_id)

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        # 将KarborProxy信息注册至CMDB
        logger.info(f"Start extend info to cmdb")
        self._update_karbor_proxy_info_to_cmdb()

    def _update_karbor_proxy_info_to_cmdb(self):
        cmdb_service_name = f"{self.service_name}_{self.region_id}"
        logger.info(f"Start to obtain {self.service_name} service "
                    f"info from CMDB.")
        service_info_list = self.cmdb_util.get_cloud_service_info(
            region_code=self.region_id,
            index_name=self.service_name,
            name=cmdb_service_name)
        if not service_info_list:
            raise Exception(f"Failed to obtain {self.service_name} info.")
        logger.info(f"The cloud service information obtained "
                    f"from the CMDB is: {service_info_list}.")

        karbor_version = self.proxy.get_proxy_version_from_conf()
        cloud_service_info = dict()
        cloud_service_info["version"] = karbor_version.original_version
        cloud_service_info["originalVersion"] = karbor_version.target_version
        cloud_service_info["name"] = cmdb_service_name
        for service_info in service_info_list:
            if not service_info.get("name") == cmdb_service_name:
                continue
            cloud_service_info["indexName"] = service_info.get("indexName")
            cloud_service_info["name"] = service_info.get("name")
            extend_info_list = []
            for extend_info in service_info.get("extendInfos"):
                extend_info_list.append(extend_info)
            cloud_service_info["extendInfos"] = extend_info_list

        # 注册CMDB
        logger.info(f"Start to register cloud service info to CMDB, "
                    f"cloud service info is: {cloud_service_info}.")
        self.cmdb_util.set_cloud_service_info(
            region_code=self.region_id,
            cloud_service_info=cloud_service_info)

        logger.info(f"Update {self.service_name} extend info to cmdb succeed.")
