/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.interceptor;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.exception.RestException;
import com.huawei.ism.drm.web.util.UriUtil;
import com.huawei.lego.core.sdk.log.CodeLog;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class SyncAdminRestInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final CodeLog LOGGER = LogFactory.getInstance(SyncAdminRestInterceptor.class, (long)-1L);
    private static final Set<String> INTERCEPTOR_CHECK_WHITE_URIS = ImmutableSet.of((Object)"/ws/users/action/userModifyPassword");

    public SyncAdminRestInterceptor() {
        super("pre-invoke");
    }

    public void handleMessage(Message message) {
        Map<String, Object> headers = this.getHeaders(message);
        List account = (List)headers.get("x-auth-user");
        if (VerifyUtil.isEmpty((Collection)account)) {
            LOGGER.error((Object)"the X-Auth-User is empty");
        } else {
            String requestUri = String.valueOf(message.get((Object)"org.apache.cxf.request.uri"));
            if (INTERCEPTOR_CHECK_WHITE_URIS.contains(UriUtil.canonicalPath(requestUri))) {
                return;
            }
            String userName = (String)account.get(0);
            if ("SyncAdmin".equals(userName)) {
                RestException exception = new RestException(1073947400L);
                Fault ftVerify = new Fault((Throwable)exception);
                ftVerify.setFaultCode(Fault.FAULT_CODE_CLIENT);
                throw ftVerify;
            }
        }
    }

    private Map<String, Object> getHeaders(Message message) {
        Message mess = message.getExchange().getInMessage();
        return (TreeMap)mess.get((Object)Message.PROTOCOL_HEADERS);
    }
}

