/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.base;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.report.sdk.ReportUtil;
import com.huawei.ism.drm.rest.util.PageParameter;
import com.huawei.ism.drm.rest.util.SysOpLogBuilder;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.util.ReverseObjectSerializableUtils;
import com.huawei.ism.drm.web.service.logging.LoggingParams;
import com.huawei.ism.drm.web.service.logging.LoggingService;
import com.huawei.ism.drm.web.service.session.SessionService;
import com.huawei.ism.drm.web.service.tunnel.BundleService;
import com.huawei.ism.drm.web.util.RequestUtil;
import com.huawei.ism.drm.web.util.ResourceUtil;
import com.huawei.ism.drm.web.util.UriUtil;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgrBaseService;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRestService {
    private static final List<String> CLOUD_URIS = Arrays.asList("/ws/csha", "/ws/csdr", "/ws/bcs", "/ws/om");
    private static final String COMM_SERVICE_TYPE = "";
    private static final String MACHINE_TO_MACHINE_FLAG = "machine_to_machine_flag";
    private static final String IS_EXPORT_PRE_CHECK = "is_export_pre_check";
    protected static final String DEFUALT_BUNDLE_NAME = "DRM_Base";
    private final transient Log LOGGER = LogFactory.getInstance((Object)this);
    private BundleService bundleService;
    private LoggingService loggingService;
    private SessionService sessionService;

    public static boolean isIPValid(String strIP) {
        if (VerifyUtil.isEmpty((String)strIP) || strIP.endsWith(".0") || strIP.startsWith("0")) {
            return false;
        }
        return AddressUtil.isIpAddress((String)strIP);
    }

    public BundleService getBundleService() {
        return this.bundleService;
    }

    @Autowired
    public void setBundleService(BundleService bundleService) {
        this.bundleService = bundleService;
    }

    public LoggingService getLoggingService() {
        return this.loggingService;
    }

    @Autowired
    public void setLoggingService(LoggingService loggingService) {
        this.loggingService = loggingService;
    }

    public SessionService getSessionService() {
        return this.sessionService;
    }

    @Autowired
    public void setSessionService(SessionService sessionService) {
        this.sessionService = sessionService;
    }

    public HttpServletRequest getRequest() {
        return this.sessionService.getHttpServletRequest();
    }

    protected HttpServletResponse getResponse() {
        return this.sessionService.getHttpServletResponse();
    }

    protected HttpSession getSession() {
        return this.getRequest().getSession(false);
    }

    protected boolean isMachineToMachineReq() {
        String machineFlag = this.getRequest().getHeader(MACHINE_TO_MACHINE_FLAG);
        return !VerifyUtil.isEmpty((String)machineFlag);
    }

    public Locale getLocale() {
        return RequestUtil.getLocale(this.getRequest());
    }

    protected String getAppPath() {
        return this.getSession().getServletContext().getRealPath(COMM_SERVICE_TYPE);
    }

    public static String getRemoteAddr(HttpServletRequest req) {
        return RequestUtil.getClientIpAddress(req);
    }

    @Deprecated
    protected Object getBundleService(String bundle, String service) {
        return this.bundleService.getBundleService(bundle, service);
    }

    public <T> T getBundleService(String bundleName, String serviceName, Class<T> serviceClass) {
        return this.bundleService.getBundleService(bundleName, serviceName, serviceClass);
    }

    public <T> T getBundleService(String serviceName, Class<T> serviceClass) {
        return this.bundleService.getBundleService(serviceName, serviceClass);
    }

    public <T> T getBundleService(Class<T> serviceClass) {
        return this.bundleService.getBundleService(serviceClass);
    }

    public Long getCurrentUserId() {
        User user = this.getCurrentUser();
        return user.getUserId();
    }

    public User getCurrentUser() {
        return this.sessionService.getCurrentUser();
    }

    protected Map<String, Object> getExtParamInQueryParam() {
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        Map parameterMap = this.getRequest().getParameterMap();
        if (VerifyUtil.isEmpty((Map)parameterMap)) {
            return queryParam;
        }
        for (Map.Entry values : parameterMap.entrySet()) {
            String[] keys;
            String key = (String)values.getKey();
            Object[] value = (String[])values.getValue();
            if (VerifyUtil.isEmpty((Object[])value) || key.indexOf(".") == -1 || (keys = key.split("\\.")).length != 2) continue;
            String key1 = keys[1];
            Object value1 = value[0];
            if (VerifyUtil.isEmpty((String)key1) || VerifyUtil.isEmpty((String)value1)) continue;
            queryParam.put(key1, value1);
        }
        return queryParam;
    }

    protected void checkSiteIdExisted(String siteId) {
        ISiteBaseService siteService = this.getBundleService(ISiteBaseService.class.getName(), ISiteBaseService.class);
        if (VerifyUtil.isEmpty((String)siteId)) {
            throw new LegoCheckedException(1073947393L);
        }
        Site site = siteService.getSiteById(siteId);
        if (VerifyUtil.isEmpty((Object)site)) {
            throw new LegoCheckedException(1073947394L);
        }
    }

    protected void checkDrResourceExisted(String hostSn) {
        IResourceService resourceService = this.getBundleService(IResourceService.class.getName(), IResourceService.class);
        if (null == resourceService) {
            throw new LegoCheckedException(1073947395L);
        }
        if (VerifyUtil.isEmpty((String)hostSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        DrResource dr = resourceService.getDrResourceBySn(hostSn);
        if (VerifyUtil.isEmpty((Object)dr)) {
            throw new LegoCheckedException(1073947394L);
        }
    }

    protected void checkUserAuthority(String objectId) {
        IBizScopeManager scope = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        scope.checkUserGrantedObject(this.getCurrentUserId(), objectId);
    }

    protected void checkUserAuthorityByMoIds(long ... moIds) {
        IBizScopeManager scope = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        scope.checkUserGrantedMOObject(this.getCurrentUserId(), moIds);
    }

    protected void checkUserAuthorityByMoSN(String objectSn) {
        IBizScopeManager scope = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        scope.checkUserGrantedMOObject(this.getCurrentUserId(), objectSn);
    }

    protected <T extends ManagedObject> List<T> filterMoListByUserAuthority(List<T> moList) {
        if (VerifyUtil.isEmpty(moList)) {
            this.LOGGER.info((Object)"Managed object list is null or empty.");
            return Collections.emptyList();
        }
        IBizScopeManager manager = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        return manager.filterMoList(this.getCurrentUserId(), moList);
    }

    protected void checkUserOperationAuthority(String operationName, int level, String i18nKey) {
        Long userId = this.getCurrentUserId();
        if (userId == null) {
            this.LOGGER.error((Object)"Cannot get current user.");
            throw new LegoCheckedException(1073947400L);
        }
        IUserMgrBaseService mgr = (IUserMgrBaseService)this.getBundleService("user", "usermgr");
        boolean hasRight = mgr.checkUserRight(userId.longValue(), i18nKey);
        if (!hasRight) {
            SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err.1073947400", COMM_SERVICE_TYPE, AbstractRestService.getRemoteAddr(this.getRequest()));
            SysOpLogBuilder.writeOperateLog(sysOptLog);
            throw new LegoCheckedException(1073947400L);
        }
    }

    protected void checkUserMoAuthority(String operationName, int level, long ... moIds) {
        IBizScopeManager scope = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        for (long moId : moIds) {
            try {
                scope.checkUserGrantedMOObject(this.getCurrentUserId(), new long[]{moId});
            }
            catch (LegoCheckedException e) {
                SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err.1073947400", moId + COMM_SERVICE_TYPE, AbstractRestService.getRemoteAddr(this.getRequest()));
                sysOptLog.setDetailPara(e.getParameters());
                SysOpLogBuilder.writeOperateLog(sysOptLog);
                throw e;
            }
        }
    }

    protected void checkUserMoAuthority(String operationName, int level, String ... devSn) {
        IBizScopeManager scope = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        for (String sn : devSn) {
            try {
                scope.checkUserGrantedMOObject(this.getCurrentUserId(), sn);
            }
            catch (LegoCheckedException e) {
                SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err.1073947400", sn, AbstractRestService.getRemoteAddr(this.getRequest()));
                sysOptLog.setDetailPara(e.getParameters());
                SysOpLogBuilder.writeOperateLog(sysOptLog);
                throw e;
            }
        }
    }

    protected void checkUserBizObjAuthority(String operationName, int level, String objectId) {
        IBizScopeManager scope = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        try {
            scope.checkUserGrantedObject(this.getCurrentUserId(), objectId);
        }
        catch (LegoCheckedException e) {
            SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err." + e.getErrorCode(), objectId, AbstractRestService.getRemoteAddr(this.getRequest()));
            sysOptLog.setDetailPara(e.getParameters());
            SysOpLogBuilder.writeOperateLog(sysOptLog);
            throw e;
        }
    }

    protected void writeFailedOperationLog(String operationName, int level, String objectName, Exception ix) {
        this.writeFailedOperationLog(operationName, level, objectName, ix, COMM_SERVICE_TYPE);
    }

    protected void writeFailedOperationLog(String operationName, int level, String objectName, Exception ix, String serviceType) {
        this.loggingService.writeFailedOperationLog(new LoggingParams(operationName, level, objectName, serviceType), ix);
    }

    protected void writeFailedOperationLogNoException(String operationName, int level, String objectName, Exception ix) {
        this.writeFailedOperationLogNoException(operationName, level, objectName, ix, COMM_SERVICE_TYPE);
    }

    protected void writeFailedOperationLogNoException(String operationName, int level, String objectName, Exception ix, String serviceType) {
        this.loggingService.writeFailedOperationLogNoException(new LoggingParams(operationName, level, objectName, serviceType), ix);
    }

    protected void writeSucOperationLog(String operationName, int level, String objectName, String detail, String[] parameters) {
        this.writeSucOperationLog(operationName, level, objectName, detail, parameters, COMM_SERVICE_TYPE);
    }

    protected void writeSucOperationLog(String operationName, int level, String objectName, String detail, String[] parameters, String serviceType) {
        this.loggingService.writeSucOperationLog(new LoggingParams(operationName, level, objectName, serviceType), detail, parameters);
    }

    protected BatchOperationResult getBatchResult(String logKey, String[] logPara, long erroCode, String strMotionKey) {
        if (VerifyUtil.isEmpty((String)logKey) || VerifyUtil.isEmpty((Object[])logPara)) {
            return null;
        }
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> bos = new ArrayList<BatchOperation>();
        BatchOperation bo = new BatchOperation();
        bo.setOptDetail(logKey);
        bo.setDetailParam(logPara);
        bo.setErrorCode(erroCode);
        bo.setTargetName(logKey);
        String[] trgParam = new String[]{strMotionKey};
        bo.setTargetNameParam(trgParam);
        bos.add(bo);
        result.setResult(bos);
        result.setFailCount(1);
        result.setSucceedCount(0);
        result.setTotalCount(1);
        return result;
    }

    public String getText(String key) {
        Locale locale = RequestUtil.getLocale(this.getRequest());
        return ResourceUtil.getInstance().getText(key, locale);
    }

    public String getText(String key, String[] args) {
        return ResourceUtil.getInstance().getText(key, this.getLocale(), args);
    }

    protected boolean checkIsRemoteSite(String siteId) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAuthority(siteId);
        ISiteBaseService siteService = (ISiteBaseService)this.getBundleService(DEFUALT_BUNDLE_NAME, ISiteBaseService.class.getName());
        Site site = siteService.getSiteById(siteId);
        if (VerifyUtil.isEmpty((Object)site)) {
            throw new LegoCheckedException(1073947394L);
        }
        return site.getSiteType() == 1;
    }

    protected PageParameter getPageParameter() {
        PageParameter pageParameter = new PageParameter();
        HttpServletRequest req = this.getRequest();
        String startPage = req.getParameter("startPage");
        String pageSize = req.getParameter("pageSize");
        String orderBy = req.getParameter("orderBy");
        String orderType = req.getParameter("orderType");
        try {
            if (!VerifyUtil.isEmpty((String)startPage)) {
                if (!Validator.isNum(startPage) || Integer.parseInt(startPage) < 0) {
                    this.LOGGER.error((Object)"Invalid startPage!");
                    throw new LegoCheckedException(1073947393L);
                }
                pageParameter.setStartPage(Integer.parseInt(startPage));
            }
            if (!VerifyUtil.isEmpty((String)pageSize)) {
                if (!Validator.isNum(pageSize) || Integer.parseInt(pageSize) <= 0) {
                    this.LOGGER.error((Object)"Invalid pageSize!");
                    throw new LegoCheckedException(1073947393L);
                }
                pageParameter.setPageSize(Integer.parseInt(pageSize));
            }
            if (!VerifyUtil.isEmpty((String)orderBy)) {
                pageParameter.setOrderBy(orderBy);
            }
            if (!VerifyUtil.isEmpty((String)orderType)) {
                pageParameter.setOrderType(orderType);
            }
        }
        catch (NumberFormatException e) {
            this.LOGGER.error((Object)"NumberFormatException", (Throwable)e, 1073947393L);
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        return pageParameter;
    }

    public Boolean isExportChecked() {
        String paramKey;
        HttpServletRequest request = this.getRequest();
        String isChecked = request.getParameter(paramKey = "isChecked");
        if (VerifyUtil.isEmpty((String)isChecked)) {
            isChecked = this.getParamFromRequest(request, paramKey);
        }
        request.setAttribute(IS_EXPORT_PRE_CHECK, (Object)"false".equalsIgnoreCase(isChecked));
        return !"false".equalsIgnoreCase(isChecked);
    }

    private String getParamFromRequest(HttpServletRequest request, String paramKey) {
        String param = null;
        try (BufferedReader reader = request.getReader();){
            String[] params;
            for (String paramAndValue : params = reader.readLine().split("&")) {
                if (!paramAndValue.contains(paramKey)) continue;
                param = paramAndValue.split("=")[1];
                break;
            }
        }
        catch (Exception e) {
            this.LOGGER.error((Object)"Get param from request error!");
        }
        return param;
    }

    protected void batchOptLog(BatchOperationResult batchOperationResult, String operateName, int level) {
        this.batchOptLog(batchOperationResult, operateName, level, COMM_SERVICE_TYPE);
    }

    protected void batchOptLog(BatchOperationResult batchOperationResult, String operateName, int level, String serviceType) {
        this.loggingService.batchOptLog(batchOperationResult, operateName, level, serviceType);
    }

    public String calcExecuteTime(String startTimeStr, String endTimeStr) {
        return ReportUtil.calcExecuteTime((String)startTimeStr, (String)endTimeStr, (Locale)this.getLocale());
    }

    private boolean isCloudRestService(String uri) {
        for (String s : CLOUD_URIS) {
            if (!uri.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private void setSysOptLogType(SysOptLog.Builder sysOptLogBuilder) {
        if (this.isCloudRestService(this.getRequestURL())) {
            sysOptLogBuilder.logType("tenantlog");
        } else {
            sysOptLogBuilder.logType("administratorlog");
        }
    }

    private String getRequestURL() {
        String uri = this.getRequest().getRequestURI();
        return UriUtil.canonicalPath(uri);
    }

    private void setSysOptLogContainOneTerminalIpForHCS(SysOptLog.Builder sysOptLogBuilder) {
        if (this.isCloudRestService(this.getRequestURL())) {
            sysOptLogBuilder.terminalIp(RequestUtil.getFirstIPFromIPStr(sysOptLogBuilder.getTerminalIp()));
        }
    }

    protected Response exportCheckOk() {
        HttpServletRequest request = this.getRequest();
        request.setAttribute(IS_EXPORT_PRE_CHECK, (Object)Boolean.TRUE);
        return Response.ok().build();
    }

    protected String constructResponseData(Object resultObj) {
        if (null == resultObj) {
            this.LOGGER.error((Object)"ConstructResponseData failed.", 653110170615808L);
            throw new LegoCheckedException(-1L);
        }
        String messageObj = ReverseObjectSerializableUtils.serializableObj((Object)resultObj);
        JSONObject res = new JSONObject();
        res.put((Object)"type", (Object)resultObj.getClass().getName());
        res.put((Object)"message", (Object)messageObj);
        return res.toString();
    }

    protected String getUserProjectId() {
        if (VerifyUtil.isEmpty((Object)this.getRequest())) {
            return null;
        }
        return (String)this.getRequest().getAttribute("iam-x-auth-user-project");
    }

    protected String getUserJson() {
        return this.getCurrentUser().getUserName();
    }
}

