/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.alarm.util;

import com.huawei.ism.drm.rest.service.framework.alarm.util.FileUtil;
import com.huawei.lego.cbb.resource.sdk.model.DeviceConfigData;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CsvFileUtil
extends FileUtil {
    private static final String SIGN_COMMA = ",";
    private static final Log LOGGER = FELogFactory.getInstance((String)"ui");
    private CSVPrinter csvPrinter;

    public CsvFileUtil() {
        this.setStrExtend("csv");
    }

    public CSVPrinter getCsvPrinter() {
        return this.csvPrinter;
    }

    public void setCsvPrinter(CSVPrinter csvPrinter) {
        this.csvPrinter = csvPrinter;
    }

    @Override
    public void closeFile() throws IOException {
        this.csvPrinter.close();
    }

    @Override
    public void writeFile(List<List<String>> dataList) {
        this.writeCsv(dataList, false);
    }

    private void closeWriter(PrintWriter pw) {
        if (null != this.csvPrinter) {
            try {
                this.csvPrinter.close();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Close failed.", 90160758784001L);
            }
        }
        if (null != pw) {
            try {
                pw.close();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Close failed.", 90160758784001L);
            }
        }
    }

    @Override
    public void writeFile(List<List<String>> dataLst, String detailLink) {
        this.writeCsv(dataLst, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCsv(List<List<String>> dataList, boolean hasDetail) {
        if (dataList == null) {
            return;
        }
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        PrintWriter pw = null;
        CSVFormat format = CSVFormat.DEFAULT.withHeader(new String[]{SIGN_COMMA}).withSkipHeaderRecord();
        try {
            fos = new FileOutputStream(this.getWriteFileName());
            osw = new OutputStreamWriter((OutputStream)fos, Charset.forName(this.getStrChar()));
            pw = new PrintWriter(osw);
            this.csvPrinter = new CSVPrinter((Appendable)pw, format);
            int iIndex = 0;
            Object[] arrTemp = new String[this.getColTitle().size()];
            this.csvPrinter.printRecord((Object[])new String[]{this.getStrUsrName(), CsvFileUtil.getNowTime()});
            for (String string : this.getColTitle()) {
                arrTemp[iIndex++] = CommonUtil.formatAvoidCsvInjection((String)string);
            }
            this.csvPrinter.printRecord(arrTemp);
            for (List list : dataList) {
                iIndex = 0;
                Object[] arrTemps = new String[list.size()];
                int maxLength = hasDetail ? list.size() - 1 : list.size();
                for (int i = 0; i < maxLength; ++i) {
                    arrTemps[iIndex++] = CommonUtil.formatAvoidCsvInjection((String)((String)list.get(i)));
                }
                this.csvPrinter.printRecord(arrTemps);
            }
            this.csvPrinter.flush();
            this.closeWriter(pw);
            this.closeStream(fos, osw);
        }
        catch (IOException e) {
            try {
                LOGGER.error((Object)"WriteFile failed, errorMsg:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                this.closeWriter(pw);
                this.closeStream(fos, osw);
            }
            catch (Throwable throwable) {
                this.closeWriter(pw);
                this.closeStream(fos, osw);
                throw throwable;
            }
        }
    }

    private void closeStream(FileOutputStream fos, OutputStreamWriter osw) {
        if (null != osw) {
            try {
                osw.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Close file failed.", 90160758784001L);
            }
        }
        if (null != fos) {
            try {
                fos.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Close file failed.", 90160758784001L);
            }
        }
    }

    @Override
    public void writeConfigData(List<List<DeviceConfigData>> configList) {
    }
}

