/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.alarm.util;

import com.huawei.lego.cbb.resource.sdk.model.DeviceConfigData;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;

public abstract class FileUtil {
    private static final Log LOGGER = FELogFactory.getInstance((String)"ui");
    private static final int NUM_1024 = 1024;
    private String title;
    private List<String> colTitle;
    private String writeFileName;
    private String strExtend;
    private String strUsrName;
    private String strChar = "UTF-8";
    private String downFileName = "ExportResult";

    public void fileSet(String strTitle, List<String> lstColTitle, String strWriteFileName) {
        this.setTitle(strTitle);
        this.setColTitle(lstColTitle);
        this.setWriteFileName(strWriteFileName + "." + this.strExtend);
    }

    public void downloadNameFile(HttpServletResponse response, String fileName) {
        this.setDownFileName(fileName);
        this.downloadFile(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(HttpServletResponse response) {
        String displayName = this.downFileName + "." + this.strExtend;
        String downloadFileName = this.getWriteFileName();
        response.setContentType("application/x-download");
        response.setCharacterEncoding("windows-1251");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-store, must-revalidate");
        response.addHeader("Content-Disposition", "attachment;filename=" + displayName);
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        File delFile = new File(downloadFileName);
        FileInputStream fileInput = null;
        try {
            int bytesRead;
            fileInput = new FileInputStream(downloadFileName);
            bis = new BufferedInputStream(fileInput);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[bis.available()];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
        }
        catch (IOException e) {
            try {
                LOGGER.error((Object)"downloadFile", 653110170615808L);
            }
            catch (Throwable throwable) {
                FileUtil.close(bis, bos, fileInput);
                Boolean result = delFile.delete();
                if (!result.booleanValue()) {
                    LOGGER.error((Object)"delete file error", 653110170615808L);
                }
                throw throwable;
            }
            FileUtil.close(bis, bos, fileInput);
            Boolean result = delFile.delete();
            if (!result.booleanValue()) {
                LOGGER.error((Object)"delete file error", 653110170615808L);
            }
        }
        FileUtil.close(bis, bos, fileInput);
        Boolean result = delFile.delete();
        if (!result.booleanValue()) {
            LOGGER.error((Object)"delete file error", 653110170615808L);
        }
    }

    private static void close(BufferedInputStream bis, BufferedOutputStream bos, FileInputStream fileInput) {
        if (null != fileInput) {
            try {
                fileInput.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"downloadFile", 653110170615808L);
            }
        }
        if (bis != null) {
            try {
                bis.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"downloadFile", 653110170615808L);
            }
        }
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"downloadFile", 653110170615808L);
            }
        }
    }

    public static String getNowTime() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDetailFile(String fileName, byte[] logDetail) {
        FilterOutputStream dos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileName);
            dos = new DataOutputStream(fos);
            dos.write(logDetail);
            ((DataOutputStream)dos).flush();
        }
        catch (IOException e) {
            LOGGER.error((Object)"writeDetailFile", 653110170615808L);
        }
        finally {
            try {
                if (null != dos) {
                    dos.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"writeDetailFile", 653110170615808L);
            }
            try {
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"writeDetailFile", 653110170615808L);
            }
        }
    }

    public void deleteFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                Boolean result = file.delete();
                if (!result.booleanValue()) {
                    LOGGER.error((Object)"delete file error", 653110170615808L);
                }
            } else if (file.isDirectory()) {
                Boolean result;
                File[] files = file.listFiles();
                if (null != files) {
                    for (int i = 0; i < files.length; ++i) {
                        this.deleteFile(files[i]);
                    }
                }
                if (!(result = Boolean.valueOf(file.delete())).booleanValue()) {
                    LOGGER.error((Object)"delete file error", 653110170615808L);
                }
            }
        } else {
            LOGGER.error((Object)"file is not exist", 653110170615808L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipFile(String filePath, String zipFileName) {
        File inputFile = new File(filePath);
        ZipOutputStream out = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(zipFileName);
            out = new ZipOutputStream(fos);
            this.zip(out, inputFile, "");
        }
        catch (Exception e) {
            try {
                ExceptionUtil.rethrowException((Exception)e, (String)"zipFile", (long)-1L, null);
            }
            catch (Throwable throwable) {
                CommonUtil.close(out);
                CommonUtil.close((Closeable)fos);
                throw throwable;
            }
            CommonUtil.close((Closeable)out);
            CommonUtil.close((Closeable)fos);
        }
        CommonUtil.close((Closeable)out);
        CommonUtil.close((Closeable)fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zip(ZipOutputStream out, File file, String base) {
        FileInputStream in = null;
        try {
            if (file.isDirectory()) {
                File[] fl = file.listFiles();
                out.putNextEntry(new ZipEntry(base + "/"));
                String string = base = base.length() == 0 ? "" : base + "/";
                if (null == fl) {
                    CommonUtil.close((Closeable)in);
                    return;
                }
                for (int i = 0; i < fl.length; ++i) {
                    this.zip(out, fl[i], base + fl[i].getName());
                }
            } else {
                int b;
                out.putNextEntry(new ZipEntry(base));
                in = new FileInputStream(file);
                while ((b = in.read()) != -1) {
                    out.write(b);
                }
            }
            CommonUtil.close((Closeable)in);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Exception)e, (String)"zipFile", (long)-1L, null);
        }
        finally {
            CommonUtil.close(in);
        }
    }

    public abstract void writeFile(List<List<String>> var1);

    public abstract void writeFile(List<List<String>> var1, String var2);

    public abstract void writeConfigData(List<List<DeviceConfigData>> var1);

    public abstract void closeFile() throws IOException;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getColTitle() {
        return this.colTitle;
    }

    public void setColTitle(List<String> colTitle) {
        this.colTitle = colTitle;
    }

    public String getWriteFileName() {
        return this.writeFileName;
    }

    public void setWriteFileName(String writeFileName) {
        this.writeFileName = writeFileName;
    }

    public String getStrExtend() {
        return this.strExtend;
    }

    public void setStrExtend(String strExtend) {
        this.strExtend = strExtend;
    }

    public String getStrUsrName() {
        return this.strUsrName;
    }

    public void setStrUsrName(String strUsrName) {
        this.strUsrName = strUsrName;
    }

    public String getStrChar() {
        return this.strChar;
    }

    public void setStrChar(String strChar) {
        this.strChar = strChar;
    }

    public String getDownFileName() {
        return this.downFileName;
    }

    public void setDownFileName(String downFileName) {
        this.downFileName = downFileName;
    }
}

