/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.resource.service;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.resource.model.DeviceVo;
import com.huawei.ism.drm.rest.service.framework.resource.model.NeMgrProtocolExtendVo;
import com.huawei.ism.drm.rest.service.framework.resource.model.ResourceVO;
import com.huawei.ism.drm.rest.service.framework.resource.model.TreeNodeVo;
import com.huawei.ism.drm.rest.service.framework.resource.service.IResourceRestService;
import com.huawei.ism.drm.rest.service.framework.resource.util.TreeNodeUtil;
import com.huawei.ism.drm.rest.util.OperationLog;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.rest.util.PageParameter;
import com.huawei.ism.drm.rest.util.ParamValidator;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.resource.sdk.model.MainDeviceTypeState;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObjectQueryCondition;
import com.huawei.lego.cbb.resource.sdk.service.IDataExplore;
import com.huawei.lego.cbb.resource.sdk.service.IDeviceTypeMgr;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.tree.DataElement;
import com.huawei.lego.core.sdk.util.tree.RootDataElement;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.service.IDiscoveryBaseService;
import com.huawei.lego.nem.fault.sdk.service.IAlarmDevTypeService;
import com.huawei.lego.nem.topo.sdk.model.UIElement;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;

public abstract class BaseResourceRestServiceImpl
extends AbstractRestService
implements IResourceRestService {
    private static final Log LOGGER = FELogFactory.getInstance((String)"ui");
    private static final long CONERR = 51L;
    private static final Long TYPE_NODE = 0L;
    private static final Long TYPE_GROUP = 3L;
    private static final String TASK_ID = "taskId";
    private static final int MAX_BATCH_SIZE = 128;

    @Override
    @ParamValidator
    @OperationLog(operationName="site_sendAddResourceCmd_operateName", operationModule="resource", level=1)
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"})
    public String autoDis(List<ResourceVO> autoDisVOList) {
        LOGGER.info((Object)"enter autoDis.");
        CommUtils.checkParamEmpty(autoDisVOList);
        IDiscoveryBaseService service = this.getDiscoveryService();
        service.checkOverLimitResourceQuantity(autoDisVOList.size());
        Map typeMap = service.getDeviceTypeAndUrl().getMainSubTypeMap();
        JSONObject response = new JSONObject();
        JSONArray records = new JSONArray();
        int succeedCount = 0;
        for (ResourceVO autoDisVO : autoDisVOList) {
            String ip = autoDisVO.getIp();
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)ip);
            JSONObject record = new JSONObject();
            record.put((Object)"target", (Object)ip);
            try {
                this.checkParams(typeMap, autoDisVO, ip);
                this.checkUserBizObjAuthority("site_sendAddResourceCmd_operateName", 1, autoDisVO.getSiteId());
                ISiteBaseService siteSvc = (ISiteBaseService)this.getBundleService("DRM_Base", ISiteBaseService.class.getName());
                Site site = siteSvc.getSiteById(autoDisVO.getSiteId());
                if (null == site) {
                    throw new LegoCheckedException(2117645L);
                }
                DiscoveryPolicy policy = this.addDiscoveryTask(autoDisVO);
                String[] params = new String[]{ip, site.getName()};
                this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)params);
                record.put((Object)"errorCode", (Object)0);
                record.put((Object)TASK_ID, policy.getParamMap().get(TASK_ID));
                ++succeedCount;
            }
            catch (LegoCheckedException ex) {
                record.put((Object)"errorCode", (Object)ex.getErrorCode());
                record.put((Object)"detailParam", (Object)ex.getParameters());
                throw ex;
            }
            catch (Exception ex) {
                record.put((Object)"errorCode", (Object)-1L);
                throw new LegoCheckedException(-1L);
            }
            records.add((Object)record);
        }
        response.put((Object)"totalCount", (Object)autoDisVOList.size());
        response.put((Object)"succeedCount", (Object)succeedCount);
        response.put((Object)"failCount", (Object)(autoDisVOList.size() - succeedCount));
        response.put((Object)"result", (Object)records);
        return response.toString();
    }

    private void checkParams(Map<String, Set<String>> typeMap, ResourceVO autoDisVO, String ip) {
        String deviceType = autoDisVO.getDeviceType();
        String deviceSubType = autoDisVO.getDeviceSubType();
        Map<String, String> paramMap = autoDisVO.getParamMap();
        String devicetype = paramMap.get("devicetype");
        if ("ism.drm.deviceType.fusionsphere.mainType".equals(deviceType) && "ism.drm.deviceType.fusionsphereopenstack.subType".contains(deviceSubType) && "FusionSphereOpenstack".equals(devicetype) ? !CommUtil.checkDrmIpParam((String)ip) && !CommUtil.checkDrmDomainParam((String)ip) : !CommUtil.checkDrmIpParam((String)ip)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkTypeAndManufacture(autoDisVO, typeMap);
        if (VerifyUtil.isEmpty((String)autoDisVO.getSiteId()) || !ParamChecker.checkGeneralId((String)autoDisVO.getSiteId())) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private DiscoveryPolicy addDiscoveryTask(ResourceVO autoDisVO) {
        LOGGER.debug((Object)"enter addDiscoveryTask");
        DiscoveryPolicy policy = new DiscoveryPolicy();
        policy.setLocation(autoDisVO.getSiteId());
        policy.setStartIP(autoDisVO.getIp());
        policy.setEndIP(autoDisVO.getIp());
        policy.setDeviceType(autoDisVO.getDeviceType());
        policy.setDeviceSubType(null == autoDisVO.getDeviceSubType() ? "" : autoDisVO.getDeviceSubType());
        policy.setParamMap(autoDisVO.getParamMap());
        policy.setOperatorId(this.getCurrentUserId());
        long taskId = this.getBundleService(IResourceService.class).discoveryResource(policy);
        policy.getParamMap().put(TASK_ID, taskId + "");
        return policy;
    }

    private void checkTypeAndManufacture(ResourceVO autoDisVO, Map<String, Set<String>> typeMap) {
        LOGGER.debug((Object)"enter checkTypeAndManufacture");
        if (VerifyUtil.isEmpty(typeMap)) {
            throw new LegoCheckedException(1073947393L);
        }
        String deviceType = autoDisVO.getDeviceType();
        String deviceSubType = autoDisVO.getDeviceSubType();
        if (!typeMap.containsKey(deviceType)) {
            throw new LegoCheckedException(1073947393L);
        }
        Set<String> subTypes = typeMap.get(deviceType);
        if (!VerifyUtil.isEmpty(subTypes) ? !subTypes.contains(deviceSubType) : !VerifyUtil.isEmpty((String)deviceSubType)) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private Set<String> getFields(Map<String, Set<String>> typeMap, String deviceType) {
        LOGGER.debug((Object)"enter getFields");
        if (typeMap != null && !typeMap.isEmpty()) {
            return typeMap.get(deviceType);
        }
        return null;
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="site_removeResource_operateName", operationModule="alarm", level=4)
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"})
    public BatchOperationResult deleteResources(String sns) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)sns);
        HashMap<Long, String> idNameMap = new HashMap<Long, String>();
        HashMap<Long, DeviceVo> idVoMap = new HashMap<Long, DeviceVo>();
        List<DeviceVo> deviceVoList = null;
        try {
            CommUtils.checkParamEmpty(sns);
            if (!ParamChecker.checkList((Object[])sns.split(";"), ParamChecker::checkResourcesSn, (int)128)) {
                LOGGER.error((Object)"sns is incorrect");
                throw new LegoCheckedException(1073947393L);
            }
            deviceVoList = this.getIdAndNameMaps(sns, idNameMap, idVoMap);
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)"batch delete device is error.", (Throwable)ex, 90160758784001L);
            throw ex;
        }
        catch (Exception e) {
            LOGGER.error((Object)("batch delete device is error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        long[] moIds = new long[deviceVoList.size()];
        for (int i = 0; i < moIds.length; ++i) {
            moIds[i] = deviceVoList.get(i).getMoId();
        }
        this.checkUserMoAuthority("site_removeResource_operateName", 2, moIds);
        BatchOperationResult batchOperationResult = null;
        batchOperationResult = this.doDeleteResources(deviceVoList, idNameMap);
        this.batchOptLog(batchOperationResult, "site_removeResource_operateName", 2, idVoMap);
        return batchOperationResult;
    }

    protected void batchOptLog(BatchOperationResult batchOperationResult, String operateName, int level, Map<Long, DeviceVo> idVoMap) {
        LOGGER.debug((Object)"enter batchOptLog");
        if (batchOperationResult == null) {
            return;
        }
        for (BatchOperation result : batchOperationResult.getResult()) {
            String name = (String)(result.getTargetName() != null ? result.getTargetName() : result.getExtTargetId());
            if (result.getErrorCode() == 0L) {
                DeviceVo vo = idVoMap.get(result.getTargetId());
                String ip = "--";
                if (vo != null) {
                    ip = vo.getIpAddress();
                }
                this.writeSucOperationLog(operateName, level, name, "site_removeResource_operateDetail", new String[]{name, ip});
                continue;
            }
            this.writeFailedOperationLogNoException(operateName, level, name, (Exception)((Object)new LegoCheckedException(result.getErrorCode(), result.getDetailParam())));
        }
    }

    private BatchOperationResult doDeleteResources(List<DeviceVo> deviceVoList, Map<Long, String> idNameMap) {
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        ArrayList<BatchOperation> result = new ArrayList<BatchOperation>();
        BatchOperationResult apmBathOprLst = this.checkResource(idNameMap, result, bathOprLst);
        LOGGER.info((Object)("start delete devices, the device's ids:" + this.getDeviceIds(deviceVoList)), 653110170615808L);
        this.deleteDeviceCommand(bathOprLst);
        LOGGER.info((Object)"Delete devices:", 653110170615808L);
        return apmBathOprLst;
    }

    private String getDeviceIds(List<DeviceVo> deviceVoList) {
        LOGGER.debug((Object)"enter getDeviceIds");
        StringBuilder sb = new StringBuilder();
        for (DeviceVo vo : deviceVoList) {
            sb.append(vo.getMoId()).append("\u3001");
        }
        return sb.toString();
    }

    private List<DeviceVo> getIdAndNameMaps(String sns, Map<Long, String> idNameMap, Map<Long, DeviceVo> idVoMap) {
        String[] snArray;
        ArrayList<DeviceVo> results = new ArrayList<DeviceVo>();
        for (String sn : snArray = sns.split(";")) {
            NetworkEntity mo = this.getNetworkEntity(sn);
            if (null == mo) {
                LOGGER.error((Object)("NetworkEntity not exsits, sn=" + sn), 90160758784000L);
                throw new LegoCheckedException(1073947394L);
            }
            String moName = mo.getName();
            Long moId = mo.getMoId();
            DeviceVo device = new DeviceVo();
            device.setMoId(moId);
            device.setName(moName);
            device.setIpAddress(mo.getIpAddress());
            device.setMainType(mo.getMainType());
            device.setSubType(mo.getSubType());
            idNameMap.put(moId, mo.getName());
            idVoMap.put(moId, device);
            results.add(device);
        }
        return results;
    }

    private BatchOperationResult checkResource(Map<Long, String> idNameMap, List<BatchOperation> result, List<BatchOperation> bathOprLst) {
        LOGGER.debug((Object)"enter checkResource");
        BatchOperationResult apmBathOprLst = new BatchOperationResult();
        if (VerifyUtil.isEmpty(idNameMap) || result == null || bathOprLst == null) {
            return apmBathOprLst;
        }
        ISiteBaseService siteService = this.getBundleService(ISiteBaseService.class.getName(), ISiteBaseService.class);
        ArrayList<Long> modIds = new ArrayList<Long>(idNameMap.keySet());
        apmBathOprLst = siteService.checkResourceUsed(this.getCurrentUserId(), modIds);
        for (BatchOperation bo : apmBathOprLst.getResult()) {
            bo.setTargetName(idNameMap.get(bo.getTargetId()));
            if (0L == bo.getErrorCode()) {
                bathOprLst.add(bo);
                continue;
            }
            result.add(bo);
        }
        return apmBathOprLst;
    }

    private long deleteDeviceCommand(List<BatchOperation> bathOprLst) {
        LOGGER.debug((Object)"enter deleteDeviceCommand");
        IResourceService service = this.getBundleService(IResourceService.class.getName(), IResourceService.class);
        return service.deleteResources(bathOprLst);
    }

    private IDiscoveryBaseService getDiscoveryService() {
        return (IDiscoveryBaseService)this.getBundleService("discover", "DiscoveryServiceImpl");
    }

    @Override
    @ParamValidator
    @Permission(name={"ism.drm.site.auth.scan"})
    public String getInsDeviceList(String mainType, String id, String name, String ip) {
        this.checkParams(mainType, id, name, ip);
        PageParameter parameter = this.getPageParameter();
        int startPage = parameter.getStartPage();
        int pageSize = parameter.getPageSize();
        if (startPage < 0 || pageSize < 0) {
            throw new LegoCheckedException(250L);
        }
        String subType = id;
        if (!VerifyUtil.isEmpty((String)subType)) {
            subType = subType.replaceAll("'", "''");
        }
        IDataExplore deviceSrv = (IDataExplore)this.getBundleService("ResourceApplication", "DeviceDataExplore");
        TopoObjectQueryCondition condtion = this.constructQueryCondition(mainType, name, ip, subType);
        JSONObject resultObject = new JSONObject();
        try {
            List topoObjectList = deviceSrv.getDataList(startPage * pageSize, pageSize, condtion);
            long total = (int)deviceSrv.getTotalDataCount(condtion);
            resultObject.put((Object)"totalCount", (Object)total);
            JSONArray array = new JSONArray();
            for (TopoObject object : topoObjectList) {
                array.add((Object)this.topoObjectToJSonObject(object));
            }
            resultObject.put((Object)"records", (Object)array);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while getInsDeviceList: " + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
        }
        return resultObject.toString();
    }

    private void checkParams(String mainType, String id, String name, String ip) {
        if (!ParamChecker.checkGeneralId((String)mainType)) {
            LOGGER.error((Object)"mainType is incorrect!");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)id)) {
            LOGGER.error((Object)"id is incorrect!");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkNameQuery((String)name)) {
            LOGGER.error((Object)"name is incorrect!");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkIpQuery((String)ip)) {
            LOGGER.error((Object)"ip is incorrect!");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private JSONObject topoObjectToJSonObject(TopoObject to) {
        LOGGER.debug((Object)"enter topoObjectToJSonObject");
        JSONObject json = new JSONObject();
        json.put((Object)"moId", (Object)to.getMoId());
        json.put((Object)"uuid", (Object)to.getUuid());
        if (to instanceof NetworkEntity) {
            json.put((Object)"sn", (Object)((NetworkEntity)to).getSn());
        } else {
            json.put((Object)"sn", (Object)"");
        }
        json.put((Object)"status", (Object)to.getStatus());
        json.put((Object)"name", (Object)to.getName());
        json.put((Object)"ipAddress", (Object)to.getIpAddress());
        json.put((Object)"mainType", (Object)to.getMainType());
        json.put((Object)"subType", (Object)to.getSubType());
        if (to instanceof Node) {
            json.put((Object)"discoveredTimeStr", (Object)((Node)to).getDiscoveredTimeStr());
        } else {
            json.put((Object)"discoveredTimeStr", (Object)"");
        }
        json.put((Object)"timezoneFormat", (Object)to.getTimezoneFormat());
        return json;
    }

    private TopoObjectQueryCondition constructQueryCondition(String mainType, String name, String ip, String subType) {
        LOGGER.debug((Object)"enter constructQueryCondition");
        TopoObjectQueryCondition condtion = new TopoObjectQueryCondition();
        if (!VerifyUtil.isEmpty((String)StringUtil.trim((String)mainType))) {
            condtion.setMainDevTypeName(mainType);
            if (!mainType.equals(subType)) {
                condtion.setSubDevTypeName(subType);
            }
        } else {
            condtion.setSubDevTypeName(subType);
        }
        condtion.setDeviceNameLikeQuery(VerifyUtil.isEmpty((String)StringUtil.trim((String)name)) ? null : name);
        condtion.setDevIpAddressLikeQuery(VerifyUtil.isEmpty((String)StringUtil.trim((String)ip)) ? null : ip);
        User user = this.getCurrentUser();
        if (!"true".equalsIgnoreCase(user.getIsAdmin())) {
            condtion.setUserId(String.valueOf(user.getUserId()));
        }
        return condtion;
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"})
    public List<TreeNodeVo> getResourceTree() {
        LOGGER.debug((Object)"enter getResourceTree");
        ServiceContext context = ServiceContext.getInstance();
        User currentUser = this.getCurrentUser();
        Locale locale = (Locale)this.getSession().getAttribute("WW_TRANS_I18N_LOCALE");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key.context.user", currentUser);
        map.put("key.context.localize", locale);
        Object obj = context.lookup("ResourceApplication/deviceTypeMgr", map);
        if (obj == null) {
            String[] parStrArr = new String[]{"lego.dic.module.ResourceApplication"};
            LegoCheckedException le = new LegoCheckedException(51L, parStrArr);
            throw le;
        }
        IDeviceTypeMgr topoMgr = (IDeviceTypeMgr)obj;
        RootDataElement treeRoot = null;
        treeRoot = currentUser.getIsAdmin().equals("true") ? topoMgr.getDeviceTypeTree(null, Boolean.valueOf(true)) : topoMgr.getDeviceTypeTree(currentUser.getUserId(), Boolean.valueOf(true));
        treeRoot.setDisName("lego.lab.res.devlists");
        ArrayList<TreeNodeVo> nodeList = new ArrayList<TreeNodeVo>();
        TreeNodeUtil.constructNodeList(treeRoot, nodeList);
        Collections.sort(nodeList, new CommonComparator("name", true));
        return nodeList;
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="resource_modifyResProtocol_operateName", operationModule="resource", level=3)
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"})
    public Response modifyMoBaseInfo(String sn, ResourceVO resourceVo) {
        LOGGER.debug((Object)"enter modifyMoBaseInfo");
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)sn);
        if (VerifyUtil.isEmpty((String)sn)) {
            LOGGER.error((Object)"sn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkBase64((String)sn)) {
            LOGGER.error((Object)"sn is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)(sn = this.decode(sn))) || null == resourceVo) {
            throw new LegoCheckedException(1073947393L);
        }
        NetworkEntity networkEntity = this.getNetworkEntity(sn);
        if (null == networkEntity) {
            throw new LegoCheckedException(2117645L);
        }
        String newName = resourceVo.getMoName();
        if (!ParamChecker.checkMoName((String)newName)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserMoAuthority("resource_modifyResProtocol_operateName", 3, networkEntity.getMoId());
        if (networkEntity.getName().equals(resourceVo.getMoName())) {
            return Response.ok().build();
        }
        String oldName = networkEntity.getName();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)oldName);
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)new String[]{oldName, newName});
        try {
            networkEntity.setName(newName);
            this.getBundleService(IResourceService.class).updateMo((ManagedObject)networkEntity);
        }
        catch (LegoCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    private NetworkEntity getNetworkEntity(String sn) {
        LOGGER.debug((Object)"enter getNetworkEntity");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sn", sn);
        List nes = this.getResourceService().query(NetworkEntity.class, params);
        if (VerifyUtil.isEmpty((Collection)nes)) {
            return null;
        }
        return (NetworkEntity)nes.get(0);
    }

    private IResourceService getResourceService() {
        return (IResourceService)this.getBundleService("DRM_Base", IResourceService.class.getName());
    }

    @Override
    @ParamValidator
    @Permission(name={"ism.drm.site.auth.scan"})
    public String getMoBaseInfo(String sn) {
        LOGGER.debug((Object)"enter getMoBaseInfo");
        if (VerifyUtil.isEmpty((String)sn)) {
            LOGGER.error((Object)"sn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkBase64((String)sn)) {
            LOGGER.error((Object)"sn is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
        NetworkEntity networkEntity = this.getNetworkEntity(sn = this.decode(sn));
        if (null == networkEntity) {
            throw new LegoCheckedException(1073947394L);
        }
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, networkEntity.getMoId());
        JSONObject returnObject = new JSONObject();
        returnObject.put((Object)"sn", (Object)networkEntity.getSn());
        returnObject.put((Object)"moName", (Object)networkEntity.getName());
        return returnObject.toString();
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="resource_modifyResProtocol_operateName", operationModule="resource", level=3)
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"})
    public Response modifyMangementProtocol(String sn, NeMgrProtocolExtendVo neMgrProtocolExtendVo) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)sn);
        LOGGER.debug((Object)"enter modifyMangementProtocol");
        if (VerifyUtil.isEmpty((String)sn) || !ParamChecker.checkBase64((String)sn) || null == neMgrProtocolExtendVo) {
            throw new LegoCheckedException(1073947393L);
        }
        NetworkEntity networkEntity = this.getNetworkEntity(sn = this.decode(sn));
        if (null == networkEntity) {
            throw new LegoCheckedException(2117645L);
        }
        this.checkUserMoAuthority("resource_modifyResProtocol_operateName", 3, networkEntity.getMoId());
        this.checkNeMgrProtocolExtendVo(neMgrProtocolExtendVo);
        String name = networkEntity.getName();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)name);
        this.doModifyMangementProtocol(networkEntity.getMoId(), neMgrProtocolExtendVo);
        return Response.ok().build();
    }

    private void checkNeMgrProtocolExtendVo(NeMgrProtocolExtendVo neMgrProtocolExtendVo) {
        if (VerifyUtil.isEmpty((Object)neMgrProtocolExtendVo)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!Validator.checkStringLength(neMgrProtocolExtendVo.getNetworkUserName(), 255)) {
            LOGGER.error((Object)"Invalid network user name.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!Validator.checkStringLength(neMgrProtocolExtendVo.getIsModifyPwd(), 10)) {
            LOGGER.error((Object)"Invalid param isModifyPwd.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!Validator.checkStringLength(neMgrProtocolExtendVo.getNetworkPassword(), 64)) {
            LOGGER.error((Object)"Invalid network password.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!VerifyUtil.isEmpty((String)neMgrProtocolExtendVo.getOtherParam()) && !Validator.checkStringLength(neMgrProtocolExtendVo.getOtherParam(), 1024)) {
            LOGGER.error((Object)"Invalid other param.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!(VerifyUtil.isEmpty((String)neMgrProtocolExtendVo.getSslValue()) || "0".equals(neMgrProtocolExtendVo.getSslValue()) || "1".equals(neMgrProtocolExtendVo.getSslValue()))) {
            LOGGER.error((Object)"Invalid ssl value.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!VerifyUtil.isEmpty(neMgrProtocolExtendVo.getExtendParams()) && !VerifyUtil.generalCheckLength(neMgrProtocolExtendVo.getExtendParams().entrySet())) {
            LOGGER.error((Object)"Invalid extend params.");
            throw new LegoCheckedException(1073947393L);
        }
        if ("true".equals(neMgrProtocolExtendVo.getIsModifyPwd()) && VerifyUtil.isEmpty((String)neMgrProtocolExtendVo.getNetworkPassword())) {
            LOGGER.error((Object)"Invalid pwd value.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void doModifyMangementProtocol(Long moId, NeMgrProtocolExtendVo neMgrProtocolExtendVo) {
        Map<String, String> extendParams;
        LOGGER.debug((Object)"enter doModifyMangementProtocol");
        NeMgrProtocolExtend neMgrProtocolExtend = new NeMgrProtocolExtend();
        neMgrProtocolExtend.setMoId(moId);
        neMgrProtocolExtendVo.setMoId(moId);
        if ("true".equals(neMgrProtocolExtendVo.getIsModifyPwd())) {
            neMgrProtocolExtend.setNetworkIpAddress(neMgrProtocolExtendVo.getNetworkIpAddress());
            neMgrProtocolExtend.setNetworkUserName(neMgrProtocolExtendVo.getNetworkUserName());
            neMgrProtocolExtend.setModifyAuthInfo(true);
            String networkPassword = neMgrProtocolExtendVo.getNetworkPassword();
            neMgrProtocolExtend.setNetworkPassword(HtmlStringConverter.decode(networkPassword));
        }
        if (!VerifyUtil.isEmpty(extendParams = neMgrProtocolExtendVo.getExtendParams())) {
            HashMap<String, String> decodeExtendParams = new HashMap<String, String>();
            for (Map.Entry<String, String> next : extendParams.entrySet()) {
                String key = next.getKey();
                String value = next.getValue();
                decodeExtendParams.put(key, HtmlStringConverter.decode(value));
            }
            neMgrProtocolExtend.setExtendParams(decodeExtendParams);
        }
        this.getBundleService(IResourceService.class).updateMgrProtocol(neMgrProtocolExtend);
    }

    protected Map<String, String> getBaseSupportResource() {
        LOGGER.debug((Object)"enter getSupportResource");
        IResourceService resourceService = this.getBundleService(IResourceService.class);
        Map baseSupportResoureces = resourceService.getSupportResource();
        if (VerifyUtil.isEmpty((Map)baseSupportResoureces)) {
            throw new LegoCheckedException(-1L);
        }
        return baseSupportResoureces;
    }

    @Override
    @ParamValidator
    @Permission(name={"ism.drm.site.auth.scan"})
    public NeMgrProtocolExtend queryProtocol(String sn) {
        LOGGER.debug((Object)"enter queryProtocol");
        if (VerifyUtil.isEmpty((String)sn) || !ParamChecker.checkBase64((String)sn)) {
            throw new LegoCheckedException(1073947393L);
        }
        NetworkEntity networkEntity = this.getNetworkEntity(sn = this.decode(sn));
        if (null == networkEntity) {
            throw new LegoCheckedException(2117645L);
        }
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, networkEntity.getMoId());
        NeMgrProtocolExtend neMgrProtocolExtend = this.getBundleService(IResourceService.class).getMgrProtocol(networkEntity.getMoId());
        neMgrProtocolExtend.setNetworkPassword("");
        neMgrProtocolExtend.getExtendParams().computeIfPresent("hostKey", (key, value) -> WccEncryptor.decrypt((String)value));
        return neMgrProtocolExtend;
    }

    @Override
    @ParamValidator
    @Permission(name={"ism.drm.site.auth.scan"})
    public List<TreeNodeVo> getResourceTypeTree(Boolean systemMoShow) {
        Long userId = null;
        if (!"true".equalsIgnoreCase(this.getCurrentUser().getIsAdmin())) {
            userId = this.getCurrentUserId();
        }
        IDeviceTypeMgr service = (IDeviceTypeMgr)this.getBundleService("ResourceApplication", "deviceTypeMgr");
        RootDataElement treeRoot = service.getDeviceTypeTreeWithoutDev(userId, Boolean.valueOf(true), Boolean.valueOf(true));
        if (systemMoShow.booleanValue()) {
            IDataExplore deviceSrv = (IDataExplore)this.getBundleService("ResourceApplication", "DeviceDataExplore");
            TopoObject rootMo = deviceSrv.getRootMO();
            MainDeviceTypeState mainType = new MainDeviceTypeState();
            mainType.setDeviceCount(Long.valueOf(1L));
            mainType.setGroupId(0L);
            mainType.setMainDeviceTypeName(rootMo.getMainType());
            DataElement typeGroup = this.createMainTypeNode(mainType, 0);
            typeGroup.addChildEle((UIElement)this.createSubTypeNode(rootMo.getSubType(), 0));
            treeRoot.addChildEle((UIElement)typeGroup);
        }
        try {
            Locale locale = (Locale)this.getSession().getAttribute("WW_TRANS_I18N_LOCALE");
            IAlarmDevTypeService alarmDevTypeService = (IAlarmDevTypeService)this.getBundleService("fault", "alarmDevTypeService");
            treeRoot = alarmDevTypeService.getDeviceTypeTree(treeRoot, userId, locale);
        }
        catch (Exception t) {
            LOGGER.error((Object)("call product create device type tree exception." + ExceptionUtil.getErrorMessage((Throwable)t)), 90160758784000L);
        }
        ArrayList<TreeNodeVo> nodeList = new ArrayList<TreeNodeVo>();
        TreeNodeUtil.constructNodeList(treeRoot, nodeList);
        Collections.sort(nodeList, new CommonComparator("name", true));
        return nodeList;
    }

    private DataElement createMainTypeNode(MainDeviceTypeState mainType, int i) {
        LOGGER.debug((Object)"enter createMainTypeNode");
        DataElement typeGroup = new DataElement();
        typeGroup.setId(Long.valueOf(i));
        typeGroup.setEleType(TYPE_GROUP);
        typeGroup.setEntityId(mainType.getmainDeviceTypeName());
        typeGroup.setDisName(mainType.getmainDeviceTypeName());
        typeGroup.setToolTip(mainType.getmainDeviceTypeName());
        return typeGroup;
    }

    private DataElement createSubTypeNode(String subType, int i) {
        LOGGER.debug((Object)"enter createSubTypeNode");
        DataElement subTypeNode = new DataElement();
        subTypeNode.setId(Long.valueOf(i));
        subTypeNode.setEleType(TYPE_NODE);
        subTypeNode.setEntityId(subType);
        subTypeNode.setDisName(subType);
        subTypeNode.setToolTip(subType);
        return subTypeNode;
    }

    private String decode(String encryptedStr) {
        LOGGER.debug((Object)"enter decode");
        byte[] byteArray = Base64.decodeBase64((String)encryptedStr);
        if (null == byteArray) {
            LOGGER.error((Object)"bytes array is null.", 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        return new String(byteArray, Charset.defaultCharset());
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="topology_host_resetSite_operateName", operationModule="resource", level=1)
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"})
    public Response modifyResourceSite(String resourceId, Map<String, String> siteId) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)resourceId);
        LOGGER.debug((Object)"enter modifyResourceSite");
        String siteIdInfo = this.checkParams(resourceId, siteId);
        ISiteBaseService siteService = (ISiteBaseService)this.getBundleService("DRM_Base", ISiteBaseService.class.getName());
        Site trgSite = siteService.getSiteById(siteIdInfo);
        if (VerifyUtil.isEmpty((Object)trgSite)) {
            throw new LegoCheckedException(2117645L);
        }
        DrResource res = this.getResourceService().getDrResourceBySn(resourceId);
        if (VerifyUtil.isEmpty((Object)res)) {
            throw new LegoCheckedException(2117645L);
        }
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)res.getName());
        Site srcSite = siteService.getSiteById(res.getSiteId());
        if (VerifyUtil.isEmpty((Object)srcSite)) {
            throw new LegoCheckedException(2117645L);
        }
        String srcSiteId = srcSite.getSiteId();
        if (siteIdInfo.equals(srcSiteId)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("topology_host_resetSite_operateName", 1, siteIdInfo);
        this.checkUserBizObjAuthority("topology_host_resetSite_operateName", 1, srcSiteId);
        this.checkResourceAuthority(resourceId);
        try {
            this.getResourceService().modifyResourceSite(resourceId, siteIdInfo);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)new String[]{res.getName(), srcSite.getName(), trgSite.getName()});
        }
        catch (LegoCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    private String checkSrcSite(String siteIdInfo, Site srcSite) {
        if (VerifyUtil.isEmpty((Object)srcSite)) {
            throw new LegoCheckedException(2117645L);
        }
        if (0 != srcSite.getSiteType()) {
            throw new LegoCheckedException(1073947393L);
        }
        String srcSiteId = srcSite.getSiteId();
        if (siteIdInfo.equals(srcSiteId)) {
            throw new LegoCheckedException(1073947393L);
        }
        return srcSiteId;
    }

    private String checkParams(String resourceId, Map<String, String> siteId) {
        if (VerifyUtil.isEmpty((String)resourceId) || !ParamChecker.checkGeneralId((String)resourceId) || VerifyUtil.isEmpty(siteId)) {
            throw new LegoCheckedException(1073947393L);
        }
        String siteIdInfo = siteId.get("siteId");
        if (VerifyUtil.isEmpty((String)siteIdInfo) || !ParamChecker.checkGeneralId((String)siteIdInfo)) {
            throw new LegoCheckedException(1073947393L);
        }
        return siteIdInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkResourceAuthority(String resourceId) {
        LOGGER.debug((Object)"enter checkResourceAuthority");
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("uuid", resourceId);
        List moLists = this.getBundleService(IResourceService.class).queryMoList(ManagedObject.class, query);
        if (!VerifyUtil.isEmpty((Collection)moLists)) {
            ManagedObject mo = (ManagedObject)moLists.get(0);
            while (mo.getParentMo() != null) {
                mo = mo.getParentMo();
            }
            if (!(mo instanceof NetworkEntity)) throw new LegoCheckedException(2117645L);
            this.checkUserMoAuthority("topology_host_resetSite_operateName", 1, mo.getMoId());
            return;
        } else {
            NetworkEntity mo = this.getNetworkEntity(resourceId);
            if (null == mo) throw new LegoCheckedException(2117645L);
            this.checkUserMoAuthority("topology_host_resetSite_operateName", 1, mo.getMoId());
        }
    }
}

