/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.rollbacktask.service;

import com.huawei.ism.drm.common.sdk.model.RollBackTaskInfo;
import com.huawei.ism.drm.common.sdk.service.IRollBackTaskService;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.rollbacktask.service.IRollBackTaskRestService;
import com.huawei.ism.drm.rest.util.OperationLog;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.rest.util.ParamValidator;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import javax.ws.rs.core.Response;

public class RollBackTaskRestServiceImpl
extends AbstractRestService
implements IRollBackTaskRestService {
    private static final Log LOGGER = LogFactory.getInstance(RollBackTaskRestServiceImpl.class);

    @Override
    @ParamValidator
    @OperationLog(operationName="backendTask_clear_VM_drconfig_operateName", operationModule="roll_back", level=2)
    @Permission(name={"ism.drm.protectgroup.auth.delete"})
    public Response runTask(String taskInfo) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)taskInfo);
        if (VerifyUtil.isEmpty((String)taskInfo)) {
            LOGGER.error((Object)"the taskInfo is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkLongText((String)taskInfo)) {
            LOGGER.error((Object)"the taskInfo is incorrect");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject taskInfoJson = JSONObject.fromObject((Object)taskInfo);
        String taskId = taskInfoJson.getString("taskId");
        if (VerifyUtil.isEmpty((String)taskId)) {
            LOGGER.error((Object)"the taskId is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)taskId)) {
            LOGGER.error((Object)"the taskId is incorrect");
            throw new LegoCheckedException(1073947393L);
        }
        String targetName = "";
        try {
            IRollBackTaskService taskService = this.getBundleService(IRollBackTaskService.class);
            RollBackTaskInfo task = taskService.queryTask(taskId);
            if (VerifyUtil.isEmpty((Object)task)) {
                LOGGER.error((Object)("task is not exist:taskId=" + taskId));
                throw new LegoCheckedException(2117645L);
            }
            targetName = task.getTargetName();
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)targetName);
            taskService.runTask(taskId);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("run rollback task failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("run rollback task failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }
}

