/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.system.service;

import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.system.model.DomainInfoVo;
import com.huawei.ism.drm.rest.service.framework.system.model.ManageOneInfoVo;
import com.huawei.ism.drm.rest.service.framework.system.model.OcAccessInfoVo;
import com.huawei.ism.drm.rest.service.framework.system.service.IThirdServiceRestService;
import com.huawei.ism.drm.rest.util.OperationLog;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.rest.util.ParamValidator;
import com.huawei.ism.drm.system.thirdservice.sdk.model.CloudConfig;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ICloudConfigService;
import com.huawei.ism.drm.system.thirdservice.sdk.service.IDomainInfoService;
import com.huawei.ism.drm.system.thirdservice.sdk.service.IOcAccessService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import javax.ws.rs.core.Response;

public class ThirdServiceRestServiceImpl
extends AbstractRestService
implements IThirdServiceRestService {
    private static final Log LOGGER = LogFactory.getInstance(ThirdServiceRestServiceImpl.class);
    private static final int MAX_PORT = 65535;

    @Override
    @ParamValidator
    @OperationLog(operationName="thirdservie_modifyOcParams_operateName", operationModule="third_part", level=3)
    @Permission(name={"ism.drm.thirdservice.oc.modify"})
    public Response saveOcAccessInfo(OcAccessInfoVo vo) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)"ocParam_objectName");
        this.checkParam(vo);
        CloudConfig newInfo = new CloudConfig();
        newInfo.setConfigType("oc");
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("oc_password", vo.getPassword());
        prop.put("oc_port", String.valueOf(vo.getPort()));
        prop.put("oc_username", vo.getUsername());
        prop.put("oc_domain", vo.getDomain());
        newInfo.setProps(prop);
        String[] params = new String[]{vo.getDomain(), String.valueOf(vo.getPort()), vo.getUsername()};
        try {
            String token = this.getOcAccessService().getOcToken(newInfo, "", Boolean.FALSE.booleanValue());
            if (VerifyUtil.isEmpty((String)token)) {
                LOGGER.error((Object)"token error");
                throw new LegoCheckedException(1073947407L);
            }
            this.getOcAccessService().saveOrUpdateOcAccessInfo(newInfo);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)params);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"saveOcAccessInfo failed.");
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"saveOcAccessInfo failed.");
            throw new LegoCheckedException(101L, (Throwable)e);
        }
        return Response.ok().build();
    }

    private void checkParam(OcAccessInfoVo vo) {
        if (null == vo) {
            LOGGER.error((Object)"OcAccessInfoVo is null");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)vo.getDomain()) || VerifyUtil.isEmpty((String)vo.getUsername()) || VerifyUtil.isEmpty((String)vo.getPassword())) {
            LOGGER.error((Object)"Param domain, username, password is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!(Ipv4AddressUtil.isIPv4Address((String)vo.getDomain()) || Ipv6AddressUtil.isIPv6Address((String)vo.getDomain()) || CommUtil.checkDrmDomainParam((String)vo.getDomain()))) {
            LOGGER.error((Object)"Domain is invalid, domain=%s", new Object[]{vo.getDomain()});
            throw new LegoCheckedException(1073947393L);
        }
        if (!CommUtil.checkParam((String)vo.getUsername().trim(), (int)1024)) {
            LOGGER.error((Object)"Username is invalid.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!CommUtil.checkParam((String)vo.getPassword().trim(), (int)1024)) {
            LOGGER.error((Object)"Password is invalid.");
            throw new LegoCheckedException(1073947393L);
        }
        if (vo.getPort() <= 0 || vo.getPort() > 65535) {
            LOGGER.error((Object)"Port is error.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    @Override
    @Permission(name={"ism.drm.thirdservice.oc.scan"})
    public OcAccessInfoVo getOcAccessInfo() {
        CloudConfig ocAccessInfo = this.getCloudConfigService().getCloudConfigBy("oc");
        OcAccessInfoVo vo = new OcAccessInfoVo();
        if (null != ocAccessInfo) {
            vo.setDomain((String)ocAccessInfo.getProps().get("oc_domain"));
            vo.setPort(NumberUtil.parseInteger(ocAccessInfo.getProps().get("oc_port")));
            vo.setUsername((String)ocAccessInfo.getProps().get("oc_username"));
        }
        return vo;
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="thirdservie_modifyManageOneParams_operateName", operationModule="third_part", level=3)
    @Permission(name={"ism.drm.thirdservice.oc.modify"})
    public Response saveManageOneInfo(ManageOneInfoVo vo) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)"manageOneParam_objectName");
        if (null == vo) {
            LOGGER.error((Object)"param is null");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkParam(vo);
        if (!CommUtil.checkDrmIpParam((String)vo.getDomain()) && !CommUtil.checkDrmDomainParam((String)vo.getDomain())) {
            LOGGER.error((Object)"The parameter[%s] is not a domain name or IP address.", new Object[]{vo.getDomain()});
            throw new LegoCheckedException(1073947393L);
        }
        CloudConfig newInfo = new CloudConfig();
        newInfo.setConfigType("manageOne");
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("manageOne_port", String.valueOf(vo.getPort()));
        prop.put("manageOne_domain", vo.getDomain());
        newInfo.setProps(prop);
        String[] params = new String[]{vo.getDomain(), String.valueOf(vo.getPort())};
        try {
            this.getCloudConfigService().saveOrUpdateCloudConfig(newInfo);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)params);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"saveManageOneInfo failed.");
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"saveManageOneInfo failed.");
            throw new LegoCheckedException(101L, (Throwable)e);
        }
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.thirdservice.oc.scan"})
    public ManageOneInfoVo getManageOneInfo() {
        CloudConfig accessInfo = this.getCloudConfigService().getCloudConfigBy("manageOne");
        ManageOneInfoVo vo = new ManageOneInfoVo();
        if (!VerifyUtil.isEmpty((Object)accessInfo)) {
            vo.setDomain((String)accessInfo.getProps().get("manageOne_domain"));
            vo.setPort(CommUtil.convertToInteger(accessInfo.getProps().get("manageOne_port")));
        }
        return vo;
    }

    private void checkParam(ManageOneInfoVo vo) {
        if (VerifyUtil.isEmpty((String)vo.getDomain())) {
            LOGGER.error((Object)"param is error");
            throw new LegoCheckedException(1073947393L);
        }
        int port = vo.getPort();
        if (port <= 0 || port > 65535) {
            LOGGER.error((Object)"param is error");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private IOcAccessService getOcAccessService() {
        return this.getBundleService(IOcAccessService.class);
    }

    private ICloudConfigService getCloudConfigService() {
        return this.getBundleService(ICloudConfigService.class);
    }

    private IDomainInfoService getDomainInfoService() {
        return this.getBundleService(IDomainInfoService.class);
    }

    private void checkParam(DomainInfoVo vo) {
        String businessDomain = vo.getBusinessDomain();
        if (VerifyUtil.isEmpty((String)businessDomain)) {
            LOGGER.error((Object)"param is error");
            throw new LegoCheckedException(1073947393L);
        }
        if (!CommUtil.checkDrmIpParam((String)businessDomain) && !CommUtil.checkDrmDomainParam((String)businessDomain)) {
            LOGGER.error((Object)("domainForOS is not valid:" + businessDomain));
            throw new LegoCheckedException(1073947393L);
        }
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="thirdservie_modifySysNetworkParams_operateName", operationModule="third_part", level=3)
    @Permission(name={"ism.drm.thirdservice.sysnetwork.modify"})
    public Response saveDomainInfo(DomainInfoVo vo) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)"bcmNetworkParam_objectName");
        if (null == vo) {
            LOGGER.error((Object)"param is null");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkParam(vo);
        String[] params = new String[]{vo.getBusinessDomain()};
        CloudConfig config = new CloudConfig();
        config.setConfigType("domain");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("domain_bussiness", vo.getBusinessDomain());
        config.setProps(props);
        try {
            this.getDomainInfoService().saveOrUpdateDomainInfo(config);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)params);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"saveDomainInfo failed.");
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"saveDomainInfo failed.");
            throw new LegoCheckedException(101L, (Throwable)e);
        }
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.thirdservice.sysnetwork.scan"})
    public DomainInfoVo getDomainInfo() {
        CloudConfig domainInfo = this.getDomainInfoService().getDomainInfo();
        DomainInfoVo vo = new DomainInfoVo();
        if (!VerifyUtil.isEmpty((Object)domainInfo)) {
            vo.setBusinessDomain((String)domainInfo.getProps().get("domain_bussiness"));
        }
        return vo;
    }
}

