/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.userauth.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.license.sdk.ILicenseInter;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.license.model.LicenseTimeout;
import com.huawei.ism.drm.rest.service.framework.user.service.model.RuleNameEnum;
import com.huawei.ism.drm.rest.service.framework.userauth.model.LoginRequest;
import com.huawei.ism.drm.rest.service.framework.userauth.model.LogoutVo;
import com.huawei.ism.drm.rest.service.framework.userauth.service.IBaseUserAuthRestService;
import com.huawei.ism.drm.rest.util.OperationLog;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.rest.util.ParamValidator;
import com.huawei.ism.drm.rest.util.RandCodeCheck;
import com.huawei.ism.drm.rest.util.SysOpLogBuilder;
import com.huawei.ism.drm.system.info.sdk.model.SoftwareInfo;
import com.huawei.ism.drm.system.info.sdk.service.ISoftwareInfoService;
import com.huawei.ism.drm.web.util.CheckCodeUtil;
import com.huawei.ism.drm.web.util.CookieUtil;
import com.huawei.ism.drm.web.util.TokenGenerator;
import com.huawei.ism.drm.web.util.UriUtil;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.license.sdk.model.LicenseInfoBo;
import com.huawei.lego.cbb.user.sdk.model.Role;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.model.UserSecPolicy;
import com.huawei.lego.cbb.user.sdk.service.IUserMgrBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class BaseUserAuthRestServiceImpl
extends AbstractRestService
implements IBaseUserAuthRestService {
    public static final String COOKIE_PATH = "/src/";
    private static final Log LOGGER = LogFactory.getInstance(BaseUserAuthRestServiceImpl.class);
    private static final int NUM_4 = 4;
    private static final int PWD_EXPIRED = -1;
    protected static final int DAY_MS = 86400000;
    private static final long MAX_FREE_USE_TIME = 7776000000L;
    private static String random1 = null;
    private static final int MAX_USER_NAME_LENGTH = 255;
    private static final int TOKEN_LENGTH = 64;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String login(LoginRequest loginRequest) throws ClassNotFoundException {
        String result = null;
        if (VerifyUtil.isEmpty((Object)loginRequest)) {
            LOGGER.error((Object)"LoginRequest value is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String userName = loginRequest.getUserName();
        String formatName = userName.length() > 255 ? userName.substring(0, 255) : userName;
        try {
            LOGGER.info((Object)"Login start,userName: %s", new Object[]{userName});
            result = this.doLogin(loginRequest);
            RandCodeCheck.removeUserName(userName);
            this.writeSucOperationLog("user_login_operateName", 1, loginRequest.getUserName(), null, null);
        }
        catch (LegoCheckedException le) {
            long errorCode = le.getErrorCode();
            if (errorCode != 1073947429L) {
                SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog("user_login_operateName", formatName, 2, "lego.err." + le.getErrorCode(), formatName, BaseUserAuthRestServiceImpl.getRemoteAddr(this.getRequest()));
                sysOptLog.setDetailPara(le.getParameters());
                SysOpLogBuilder.writeOperateLog(sysOptLog);
            }
            throw le;
        }
        catch (Exception e) {
            SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog("user_login_operateName", formatName, 2, "lego.err.-1", formatName, BaseUserAuthRestServiceImpl.getRemoteAddr(this.getRequest()));
            sysOptLog.setDetailPara(null);
            SysOpLogBuilder.writeOperateLog(sysOptLog);
        }
        finally {
            loginRequest.setPwd(null);
            loginRequest.setRandomCode(null);
        }
        LOGGER.info((Object)"Login end,user: %s", new Object[]{userName});
        return result;
    }

    private void checkLanguage(String lang) {
        int langLength = 100;
        if (!Validator.checkStringLength(lang, 100)) {
            LOGGER.error((Object)"Lang param error!");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkIpFormat(HttpServletRequest request) {
        if (!Ipv4AddressUtil.isIPv4Address((String)BaseUserAuthRestServiceImpl.getRemoteAddr(request)) && !Ipv6AddressUtil.isIPv6Address((String)BaseUserAuthRestServiceImpl.getRemoteAddr(request))) {
            LOGGER.info((Object)"IP format error");
        }
    }

    private void checkLoginRequest(IUserMgrBaseService mgr, LoginRequest loginRequest, String randomCode, Cookie captchaCookie) {
        String code = loginRequest.getRandomCode();
        String userName = loginRequest.getUserName();
        String userPwd = loginRequest.getPwd();
        String lang = loginRequest.getLang();
        this.checkRandomCode(userName, randomCode, code, captchaCookie);
        this.checkUserAndPassword(userName, userPwd);
        this.checkLanguage(lang);
        this.checkIpFormat(this.getRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doLogin(LoginRequest loginRequest) {
        User currentUser;
        HttpServletRequest request = this.getRequest();
        HttpSession oldSession = request.getSession();
        oldSession.removeAttribute("rd_randomStr_HW");
        oldSession.removeAttribute("LOGIN_NEED_LIC ");
        IUserMgrBaseService mgr = (IUserMgrBaseService)ServiceLocator.getBundleService((String)"user", (String)"usermgr");
        String randomCode = (String)oldSession.getAttribute("random");
        String userName = loginRequest.getUserName();
        String userPwd = loginRequest.getPwd();
        String lang = loginRequest.getLang();
        Cookie captchaCookie = new Cookie("needCaptcha", String.valueOf(true));
        captchaCookie.setPath(COOKIE_PATH);
        captchaCookie.setSecure(true);
        try {
            this.checkLoginRequest(mgr, loginRequest, randomCode, captchaCookie);
            currentUser = this.getLoginUser(this.getUserObj(userName, userPwd, request), mgr, userName, captchaCookie);
        }
        finally {
            this.getResponse().addCookie(captchaCookie);
        }
        if (currentUser == null) {
            LOGGER.error((Object)"User is null when doLogin!");
            throw new LegoCheckedException("SSO-Error: user is not exists");
        }
        oldSession.invalidate();
        currentUser.setLoginTime(new Date().getTime());
        currentUser.setIpAdr(BaseUserAuthRestServiceImpl.getRemoteAddr(request));
        LOGGER.info((Object)String.format(Locale.ENGLISH, "invalid oldSession,user: %s", userName), 653110169894912L);
        HttpSession currentSession = this.getRequest().getSession();
        currentSession.setAttribute("WW_TRANS_I18N_LOCALE", (Object)this.setLocale(lang));
        currentSession.setAttribute("user.login.mode", (Object)"local");
        CookieUtil.addCookie(this.getResponse(), "rd_language", lang, COOKIE_PATH);
        Date date = new Date();
        currentUser.setLoginTime(date.getTime());
        currentUser.setLoginDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date));
        String randomToken = TokenGenerator.getToken(64).orElseThrow(() -> new LegoCheckedException(1073947393L));
        CookieUtil.addCookie(this.getResponse(), "rd_randomStr_HW", randomToken, COOKIE_PATH);
        this.getSession().setAttribute("rd_randomStr_HW", (Object)randomToken);
        this.getResponse().addHeader("rd_randomStr_HW", randomToken);
        return this.buildLoginRsp(mgr, currentUser, date);
    }

    private String buildLoginRsp(IUserMgrBaseService mgr, User currentUser, Date date) {
        JSONObject jsonObject = new JSONObject();
        this.checkUserPasswordExpire(mgr, currentUser, jsonObject, date);
        this.getSession().setAttribute("currentUser", (Object)currentUser);
        this.getSession().setAttribute("passState", (Object)"ok");
        String username = currentUser.getUserName();
        try {
            username = URLEncoder.encode(username, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"encode username fail", (Throwable)e, 1L);
        }
        CookieUtil.addCookie(this.getResponse(), "userName", username, COOKIE_PATH);
        CookieUtil.addCookie(this.getResponse(), "user.login.mode", "local", COOKIE_PATH);
        CookieUtil.addCookie(this.getResponse(), "isAdministrator", String.valueOf(this.checkIsAdministrator(currentUser.getUserId())), COOKIE_PATH);
        jsonObject.put((Object)"userName", (Object)currentUser.getUserName());
        jsonObject.put((Object)"isAdmin", (Object)currentUser.getIsAdmin());
        jsonObject.put((Object)"isAdministrator", (Object)this.checkIsAdministrator(currentUser.getUserId()));
        JSONArray jsonArray = new JSONArray();
        jsonArray.addAll((Collection)currentUser.getRolesIdsSet());
        jsonObject.put((Object)"rolesIds", (Object)jsonArray);
        LOGGER.info((Object)String.format(Locale.ENGLISH, "login success,user: %s", currentUser.getUserName()), 653110169894912L);
        return jsonObject.toString();
    }

    protected User getUserObj(String userName, String userPwd, HttpServletRequest request) {
        User userObj = new User();
        userObj.setUserName(userName);
        userObj.setUserPassword(userPwd);
        userObj.setIpAdr(BaseUserAuthRestServiceImpl.getRemoteAddr(request));
        return userObj;
    }

    private void checkUserPasswordExpire(IUserMgrBaseService mgr, User currentUser, JSONObject jsonObject, Date date) {
        this.getSession().setAttribute("passState", (Object)"unknow");
        UserSecPolicy usrPolicy = mgr.getUserSecPolicy();
        if (this.checkChangePolicy(currentUser, usrPolicy)) {
            Date passChangeDate = new Date(currentUser.getSetTime());
            long betweenDate = (passChangeDate.getTime() - date.getTime()) / 86400000L + (long)usrPolicy.getUsefulLife().intValue();
            if (betweenDate <= 3L && betweenDate > 0L) {
                jsonObject.put((Object)"expireDay", (Object)(betweenDate - 1L));
            } else if (betweenDate <= 0L) {
                jsonObject.put((Object)"expireDay", (Object)-1);
                LOGGER.info((Object)"passwordExpired", 653110169894912L);
                currentUser.setMustModifyPwd(true);
            }
            if (currentUser.isMustModifyPwd()) {
                jsonObject.put((Object)"mustModifyPwd", (Object)true);
            }
        }
    }

    private User getLoginUser(User userObj, IUserMgrBaseService mgr, String userName, Cookie captchaCookie) {
        LOGGER.debug((Object)"enter getLoginUser");
        try {
            User currentUser = mgr.login(userObj, true);
            captchaCookie.setValue(String.valueOf(false));
            return currentUser;
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            if (errorCode == 256L || errorCode == 284L || errorCode == 282L) {
                RandCodeCheck.addUserName(userName, captchaCookie);
            }
            throw e;
        }
    }

    protected boolean checkIsAdministrator(long currentuserid) {
        LOGGER.debug((Object)"enter checkIsAdministrator");
        IUserMgrBaseService mgr = (IUserMgrBaseService)this.getBundleService("user", "usermgr");
        Set curroleset = mgr.getUserInfo(currentuserid).getRolesSet();
        if (null != curroleset) {
            for (Role temprole : curroleset) {
                if (!"1".equals(String.valueOf(temprole.getRoleId())) && !RuleNameEnum.ADMINISTRATOR.getRuleName().equals(temprole.getRoleName())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkChangePolicy(User currentUser, UserSecPolicy usrPolicy) {
        LOGGER.debug((Object)"enter checkChangePolicy");
        return currentUser.getPasswordModel() == 0 && usrPolicy.getUnseal() == 1 && currentUser.getSetTime() > 0L && currentUser.getSetTime() > 0L;
    }

    protected void checkUserAndPassword(String userName, String userPwd) {
        if (!Validator.regExpCheck(userName, "^[a-zA-Z_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-.]*$")) {
            throw new LegoCheckedException(1073947393L, "formateError");
        }
        if (Validator.stringNullTrim(userPwd)) {
            throw new LegoCheckedException(1073947393L, "formateError");
        }
    }

    private void checkRandomCode(String userName, String randomCode, String code, Cookie captchaCookie) {
        LOGGER.debug((Object)"enter checkRandomCode");
        if (randomCode == null) {
            if (!VerifyUtil.isEmpty((String)code)) {
                throw new LegoCheckedException(1073947438L, "checkCodeExpiring");
            }
            if (RandCodeCheck.isNeedRandCode(userName)) {
                throw new LegoCheckedException(1073947429L, "must give a randomCode for current login user.");
            }
            captchaCookie.setValue(String.valueOf(false));
        } else if (VerifyUtil.isEmpty((String)code) || code.equalsIgnoreCase(random1) || !randomCode.equalsIgnoreCase(code)) {
            throw new LegoCheckedException(1073947429L, "checkCodeError or checkCodeExpiring");
        }
        random1 = code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateVaildCode() throws ClassNotFoundException {
        try {
            HttpSession session = this.getSession();
            if (session != null) {
                session.invalidate();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception:" + ExceptionUtil.getErrorMessage((Throwable)e)), 653110169894912L);
        }
        HttpServletResponse response = this.getResponse();
        HttpServletRequest request = this.getRequest();
        String random = CheckCodeUtil.runVerifyCode(4);
        request.getSession().setAttribute("random", (Object)random);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            response.setHeader("Cache-Control", "no-store, must-revalidate");
            response.setContentType("image/jpeg");
            BufferedImage im = CheckCodeUtil.createImage(random);
            ImageIO.write((RenderedImage)im, "JPEG", (OutputStream)response.getOutputStream());
            out.flush();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            LOGGER.error((Object)"GenerateVaild fail, Exception", (Throwable)e, 653110169894912L);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"IOException", (Throwable)e, 653110169894912L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ParamValidator
    @OperationLog(operationName="user_logout_operateName", operationModule="auth", level=1)
    public void logout(LogoutVo logout) {
        try {
            this.getSession().removeAttribute("rd_randomStr_HW");
            this.getSession().removeAttribute("LOGIN_NEED_LIC ");
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception:" + ExceptionUtil.getErrorMessage((Throwable)e)), 653110169894912L);
        }
        boolean redirect = false;
        if (this.getRequest().getSession().getAttribute("currentUser") != null) {
            User tempUsr = (User)this.getRequest().getSession().getAttribute("currentUser");
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)tempUsr.getUserName());
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_USER_NAME, (Object)tempUsr.getUserName());
            String sessId = tempUsr.getSession();
            try {
                IUserMgrBaseService mgr = (IUserMgrBaseService)this.getBundleService("user", "usermgr");
                mgr.logout(sessId);
            }
            finally {
                if ("sso".equals(this.getSession().getAttribute("user.login.mode"))) {
                    redirect = true;
                }
                this.getSession().invalidate();
                String detailMsg = "";
                String optUser = tempUsr.getUserName();
                if (logout != null && logout.isTimeOut().booleanValue()) {
                    detailMsg = "logout_timeout_description";
                    optUser = "system";
                }
                this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)optUser);
            }
        }
        this.invalidCookie();
        CookieUtil.addCookie(this.getResponse(), "rd_language", this.setLanguage(), null);
        if (redirect) {
            try {
                UriUtil.writeSSORedirect(this.getRequest(), this.getResponse(), false);
            }
            catch (IOException e) {
                LOGGER.error((Object)("write response body error . " + ExceptionUtil.getErrorMessage((Throwable)e)));
                throw new LegoCheckedException(0x300001L, (Throwable)e);
            }
        }
    }

    private void invalidCookie() {
        Cookie[] cookies = this.getRequest().getCookies();
        if (null != cookies && cookies.length > 0) {
            CookieUtil.invalidateCookie(this.getResponse(), cookies);
        }
    }

    private String setLanguage() {
        LOGGER.debug((Object)"enter setLanguage");
        Cookie[] cookies = this.getRequest().getCookies();
        String lang = null;
        if (cookies != null) {
            lang = this.getLangFromCookies(cookies);
        }
        if (lang == null) {
            Locale defaultLocale = this.getRequest().getLocale();
            lang = defaultLocale.getLanguage();
        }
        return lang;
    }

    private String getLangFromCookies(Cookie[] cookies) {
        LOGGER.debug((Object)"enter getLangFromCookies");
        String lang = null;
        for (Cookie c : cookies) {
            String value = c.getValue();
            c.setSecure(true);
            if (!c.getName().equalsIgnoreCase("rd_language")) continue;
            if (!this.isValidLangCookie(value)) break;
            lang = value;
            break;
        }
        return lang;
    }

    private boolean isValidLangCookie(String value) {
        LOGGER.debug((Object)"enter isValidLangCookie");
        return !VerifyUtil.isEmpty((String)value) && ("zh_CN".equals(value) || "en".equals(value));
    }

    protected Locale setLocale(String language) {
        LOGGER.debug((Object)"enter setLocale");
        Locale locale = Locale.ENGLISH;
        if (!"en".equalsIgnoreCase(language)) {
            locale = Locale.SIMPLIFIED_CHINESE;
        }
        return locale;
    }

    @Override
    public LicenseTimeout isLicenseTimeout() {
        LicenseTimeout timeout = new LicenseTimeout();
        try {
            ISoftwareInfoService softwareService = this.getBundleService(ISoftwareInfoService.class.getName(), ISoftwareInfoService.class);
            SoftwareInfo softInfo = softwareService.getSoftwareInfo();
            if ("UltraVR".equals(softInfo.getProductModel())) {
                LOGGER.debug((Object)"PRODUCT_VR, not expire.", 653110170615808L);
                timeout.setExpire(false);
                timeout.setCurTime(0L);
                timeout.setInstallTime(0L);
                return timeout;
            }
            this.setLicenceTimeOut(timeout);
        }
        catch (Exception e) {
            LOGGER.error((Object)("isLicenseTimeout failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
            timeout.setExpire(true);
        }
        return timeout;
    }

    private void setLicenceTimeOut(LicenseTimeout timeout) {
        ILicenseInter mgr = (ILicenseInter)this.getBundleService("DRM_Base", ILicenseInter.class.getSimpleName());
        long sysInstallTime = mgr.getSysInstallTime();
        long curTime = System.currentTimeMillis();
        timeout.setCurTime(curTime);
        timeout.setInstallTime(sysInstallTime);
        boolean expire = curTime - sysInstallTime > 7776000000L;
        LicenseInfoBo bo = mgr.getLicenseNotUpdateUseNum();
        if (null == bo) {
            if (mgr.isDRVMPlatinic()) {
                LOGGER.debug((Object)"license isDRVMPlatinic, not expire.", 653110170615808L);
                timeout.setExpire(false);
                timeout.setCurTime(0L);
                timeout.setInstallTime(0L);
            } else if (mgr.isLicenseProbationTimeout()) {
                timeout.setExpire(false);
                timeout.setCurTime(0L);
                timeout.setInstallTime(0L);
            } else {
                timeout.setExpire(expire);
                timeout.setCurTime(curTime);
                timeout.setInstallTime(sysInstallTime);
            }
        } else {
            LOGGER.debug((Object)"license is import, not expire.", 653110170615808L);
            timeout.setExpire(false);
            timeout.setCurTime(0L);
            timeout.setInstallTime(0L);
        }
    }
}

