/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.protection.group;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.action.model.ProtectActionVo;
import com.huawei.ism.drm.protection.action.model.ProtectPathActionLogs;
import com.huawei.ism.drm.protection.action.model.ProtectPathActions;
import com.huawei.ism.drm.protection.action.service.IProtectActionBaseService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaBaseService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.rest.service.platform.protection.group.BaseProtectGroupBaseRestServiceImpl;
import com.huawei.ism.drm.rest.service.platform.protection.group.ScheduleFormater;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class BaseProtectGroupRestServiceImpl
extends BaseProtectGroupBaseRestServiceImpl {
    private static final Log LOGGER = LogFactory.getInstance(BaseProtectGroupRestServiceImpl.class);

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.scan"})
    public String queryProtectActionsLog(String protectGroupId) {
        this.validateProtectGroupId(protectGroupId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), protectGroupId);
        List detail = null;
        try {
            detail = this.getBundleService(IProtectActionBaseService.class).getActionLogs(protectGroupId);
        }
        catch (LegoCheckedException e) {
            LOGGER.info((Object)"queryProtectActionsLog service error", 90160758787071L);
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (VerifyUtil.isEmpty((Collection)detail)) {
            LOGGER.info((Object)"detail empty", 1073947393L);
            return "";
        }
        return this.toProtectGroupActionLogJson(detail);
    }

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.modify"})
    public String queryProtectActions(String protectGroupId) {
        this.validateProtectGroupId(protectGroupId);
        this.checkUserBizObjAuthority("protectedGroup_modify_operateName", SysoplogLevel.WARNING.getValue(), protectGroupId);
        List detail = null;
        try {
            detail = this.getBundleService(IProtectActionBaseService.class).getActions(protectGroupId);
        }
        catch (LegoCheckedException e) {
            LOGGER.info((Object)"queryProtectActions service error", 90160758787071L);
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (VerifyUtil.isEmpty((Collection)detail)) {
            throw new LegoCheckedException(1073947393L);
        }
        return this.toProtectGroupActionJson(detail);
    }

    private String toProtectGroupActionLogJson(List<ProtectPathActionLogs> detail) {
        if (VerifyUtil.isEmpty(detail)) {
            return "[]";
        }
        JSONArray result = new JSONArray();
        for (ProtectPathActionLogs entry : detail) {
            JSONObject everyDetail = new JSONObject();
            ProtectLocationPath path = entry.getPath();
            everyDetail.put((Object)"protectLocation", (Object)path.getProtectLocation());
            everyDetail.put((Object)"protectedSiteName", (Object)path.getProtectedSiteName());
            everyDetail.put((Object)"recoverySiteName", (Object)path.getRecoverySiteName());
            JSONArray array = new JSONArray();
            List logDetailList = entry.getProtectionLogDetails();
            for (ProtectGroupLogDetail groupLogDetail : logDetailList) {
                JSONObject obj = new JSONObject();
                try {
                    this.addGroupDetailToJson(array, groupLogDetail, obj);
                }
                catch (LegoCheckedException e) {
                    LOGGER.error((Object)"JSON operation failed.", (Throwable)e, 653110170615808L);
                }
            }
            everyDetail.put((Object)"protectGroupLogDetails", (Object)array);
            result.add((Object)everyDetail);
        }
        return result.toString();
    }

    private String toProtectGroupActionJson(List<ProtectPathActions> detail) {
        if (VerifyUtil.isEmpty(detail)) {
            LOGGER.debug((Object)"detail is empty!");
            return "[]";
        }
        JSONArray result = new JSONArray();
        for (ProtectPathActions entry : detail) {
            JSONObject everyAction = new JSONObject();
            ProtectLocationPath path = entry.getPath();
            everyAction.put((Object)"protectLocation", (Object)path.getProtectLocation());
            everyAction.put((Object)"protectedSiteName", (Object)path.getProtectedSiteName());
            everyAction.put((Object)"recoverySiteName", (Object)path.getRecoverySiteName());
            List actionList = entry.getActions();
            JSONArray array = new JSONArray();
            for (ProtectActionVo vo : actionList) {
                JSONObject everyVo = new JSONObject();
                everyVo.put((Object)"uuid", (Object)vo.getActionId());
                everyVo.put((Object)"actionType", (Object)vo.getActionType());
                everyVo.put((Object)"name", (Object)vo.getName());
                everyVo.put((Object)"nameParams", (Object)(VerifyUtil.isEmpty((String)vo.getNameParams()) ? "" : vo.getNameParams()));
                everyVo.put((Object)"isEditable", (Object)vo.isEditable());
                everyVo.put((Object)"enable", (Object)vo.isEnable());
                JSONObject everyParams = new JSONObject();
                for (Map.Entry param : vo.getParams().entrySet()) {
                    everyParams.put(param.getKey(), param.getValue());
                }
                everyVo.put((Object)"params", (Object)everyParams);
                everyVo.put((Object)"protectedType", (Object)vo.getProtectedType());
                array.add((Object)everyVo);
            }
            everyAction.put((Object)"actions", (Object)array);
            result.add((Object)everyAction);
        }
        return result.toString();
    }

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.scan"})
    public String getProtectLocations(String protectGroupId) {
        this.validateProtectGroupId(protectGroupId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), protectGroupId);
        List detail = null;
        try {
            detail = this.getBundleService(IProtectGroupBaseService.class).getProtectLocations(protectGroupId);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"getProtectLocations service error", (Throwable)e, 90160758787071L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"getProtectLocations service error", (long)-1L, null, (Log)LOGGER);
        }
        if (VerifyUtil.isEmpty((Collection)detail)) {
            LOGGER.error((Object)"detail is empty.", 90160758787071L);
            throw new LegoCheckedException(-1L);
        }
        return this.toProtectLocationJson(detail);
    }

    private String toProtectLocationJson(List<ProtectLocationPath> detail) {
        JSONArray array = new JSONArray();
        for (ProtectLocationPath path : detail) {
            JSONObject jo = new JSONObject();
            jo.put((Object)"protectLocation", (Object)String.valueOf(path.getProtectLocation()));
            JSONObject child = new JSONObject();
            child.put((Object)"recoverySiteName", (Object)path.getRecoverySiteName());
            child.put((Object)"recoverySiteId ", (Object)path.getRecoverySiteId());
            jo.put((Object)"detail", (Object)child);
            array.add((Object)jo);
        }
        LOGGER.debug((Object)"array str: %s", new Object[]{array.toString()});
        return array.toString();
    }

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.scan"})
    public String getProtectObjecsByReplica(String replicaId) {
        if (VerifyUtil.isEmpty((String)replicaId)) {
            LOGGER.debug((Object)"replicaId is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)replicaId)) {
            LOGGER.error((Object)"Invalid replicaId!");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject jsonObject = new JSONObject();
        try {
            List poList = this.getBundleService(IReplicaBaseService.class).getProtectObjectListByReplicaId(replicaId);
            jsonObject.put((Object)"records", this.protectObjectListToJsonStr(poList));
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("Querying protect object by pg failed. PgId:" + replicaId), (Throwable)e, 90160758784001L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"getProtectObjecsByReplica error", (long)-1L, null, (Log)LOGGER);
        }
        return jsonObject.toString();
    }

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$1"})
    public String listSchedule(String protectGroupId) {
        this.validateProtectGroupId(protectGroupId);
        List<Schedule> results = this.getBundleService(IProtectGroupBaseService.class).getAllSchedule(protectGroupId);
        if (null == results) {
            results = Collections.emptyList();
        } else {
            ScheduleFormater.format(results);
        }
        JSONArray jsonArray = new JSONArray();
        for (Schedule schedule : results) {
            JSONObject scheduleObject = JSONObject.fromObject((Object)schedule);
            this.setRangeTime(scheduleObject);
            jsonArray.add((Object)scheduleObject);
        }
        return jsonArray.toString();
    }

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.scan"})
    public String getSchedule(String protectGroupId, String scheduleId) {
        this.validateProtectGroupId(protectGroupId);
        if (VerifyUtil.isEmpty((String)scheduleId) || !ParamChecker.checkGeneralId((String)scheduleId)) {
            LOGGER.error((Object)"scheduleId is empty or incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
        List scheduleList = this.getBundleService(IProtectGroupBaseService.class).getAllSchedule(protectGroupId);
        Schedule result = null;
        for (Schedule schedule : scheduleList) {
            if (!schedule.getScheduleId().equals(scheduleId)) continue;
            result = schedule;
            break;
        }
        if (null == result) {
            throw new LegoCheckedException(1073947394L);
        }
        ScheduleFormater.format(result);
        JSONObject scheduleObject = JSONObject.fromObject(result);
        this.setRangeTime(scheduleObject);
        return scheduleObject.toString();
    }

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.scan"})
    public String getReplica(String protectGroupId, String replicaId) {
        this.validateProtectGroupId(protectGroupId);
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", SysoplogLevel.WARNING.getValue(), protectGroupId);
        if (VerifyUtil.isEmpty((String)replicaId)) {
            LOGGER.debug((Object)"replicaId is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)replicaId)) {
            LOGGER.error((Object)"Invalid replicaId!");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroupReplica replica = null;
        try {
            IReplicaBaseService replicaService = this.getBundleService(IReplicaBaseService.class);
            replica = replicaService.queryProtectGroupReplicaById(replicaId);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"query protectgroup replica by protectGroupId[%s] and replicaId[%s] failed:", new Object[]{protectGroupId, replicaId});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (null == replica) {
            LOGGER.error((Object)"Replica[%s] is not exists, protectGroupId[%s]", new Object[]{replicaId, protectGroupId});
            throw new LegoCheckedException(1073947394L);
        }
        JSONArray jsonArray = this.protectGroupReplicaListToJsonStr(Stream.of(replica).collect(Collectors.toList()));
        return jsonArray.getJSONObject(0).toString();
    }

    private void setRangeTime(JSONObject jsonObject) {
        JSONArray jsonArray = (JSONArray)jsonObject.get("scheduleRanges");
        if (null == jsonArray || jsonArray.isEmpty()) {
            return;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object endTime;
            JSONObject rangeObject = jsonArray.getJSONObject(i);
            Object startTime = rangeObject.get("startTime");
            if (null != startTime) {
                Date date = new Date((Long)startTime);
                rangeObject.put((Object)"startTime", (Object)CommUtils.formatDate(date));
            }
            if (null != (endTime = rangeObject.get("endTime"))) {
                Date date = new Date((Long)endTime);
                rangeObject.put((Object)"endTime", (Object)CommUtils.formatDate(date));
            }
            rangeObject.remove((Object)"schedule");
        }
    }
}

