/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.protection.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.rest.service.platform.protection.group.BaseAbstractProtectGroupRestService;
import com.huawei.ism.drm.rest.util.ExcelFileUtil;
import com.huawei.ism.drm.util.ExcelUtil;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ProtectGroupLogExcelOperator {
    private static final Log LOGGER = FELogFactory.getInstance((String)"ui");
    private static final int FIVE_COL_WIDTH = 10000;
    private static final Color BACK_GROUND = new Color(255, 0, 0);
    private BaseAbstractProtectGroupRestService protectGroupService;
    private BatchOperationResult result = null;

    public ProtectGroupLogExcelOperator(BaseAbstractProtectGroupRestService protectGroupService) {
        this.protectGroupService = protectGroupService;
    }

    public SXSSFWorkbook createExportExcel(List<ProtectGroupLog> protectGroupLogs, BatchOperationResult results) {
        LOGGER.debug((Object)"to create Export Excel..");
        this.result = results;
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet();
        this.createHeader(sheet);
        this.createDataArea(sheet, protectGroupLogs);
        sheet.setColumnWidth(0, 10000);
        sheet.setColumnWidth(1, 10000);
        sheet.setColumnWidth(2, 10000);
        sheet.setColumnWidth(3, 10000);
        return ExcelUtil.convertToSXSSFWorkbook((XSSFWorkbook)wb);
    }

    private void createHeader(XSSFSheet sheet) {
        LOGGER.debug((Object)"to create excel header..");
        XSSFCellStyle cs = sheet.getWorkbook().createCellStyle();
        XSSFFont font = sheet.getWorkbook().createFont();
        font.setBold(true);
        this.setStyle(cs, (Font)font);
        XSSFRow row0 = sheet.createRow(0);
        Cell cell = row0.createCell(0);
        cell.setCellValue(this.getText("ism.drm.protect.group.log.result.label"));
        cell.setCellStyle((CellStyle)cs);
        CellRangeAddress cra = new CellRangeAddress(0, 1, 0, 0);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(1);
        cell.setCellValue(this.getText("ism.drm.protect.group.log.time.start"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 1, 1);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(2);
        cell.setCellValue(this.getText("ism.drm.protect.group.log.time.end"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 2, 2);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(3);
        cell.setCellValue(this.getText("ism.drm.protect.group.log.time.executeTime"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 3, 3);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
    }

    private void setStyle(XSSFCellStyle cs, Font font) {
        cs.setAlignment(HorizontalAlignment.CENTER);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
        cs.setFillForegroundColor(new XSSFColor(BACK_GROUND, (IndexedColorMap)new DefaultIndexedColorMap()));
        cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cs.setBorderLeft(BorderStyle.THIN);
        cs.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderTop(BorderStyle.THIN);
        cs.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderBottom(BorderStyle.THIN);
        cs.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderRight(BorderStyle.THIN);
        cs.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cs.setFont(font);
    }

    private String getText(String string) {
        return this.protectGroupService.getText(string);
    }

    private void setRangeBorder(XSSFSheet sheet, CellRangeAddress cra) {
        LOGGER.debug((Object)"to set range border..");
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setTopBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setLeftBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBottomBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setRightBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
    }

    private void createDataArea(XSSFSheet sheet, List<ProtectGroupLog> protectGroupLogs) {
        int rowIndex = 2;
        XSSFCellStyle cs = ExcelFileUtil.formatLogCellStyle(sheet);
        ArrayList<BatchOperation> counterror = new ArrayList<BatchOperation>();
        for (ProtectGroupLog protectgrouplog : protectGroupLogs) {
            BatchOperation batchOperation = new BatchOperation();
            XSSFRow mergeRow = sheet.createRow(rowIndex);
            int rowMergeIndex = rowIndex;
            Cell cell = mergeRow.createCell(0);
            long poResult = protectgrouplog.getResult();
            cell.setCellValue(poResult == 0L ? this.getText("ism.drm.report.run.faild.excel.column") : this.getText("ism.drm.report.run.success.excel.column"));
            cell.setCellStyle((CellStyle)cs);
            CellRangeAddress cra = new CellRangeAddress(rowIndex, rowMergeIndex, 0, 0);
            this.setRangeBorder(sheet, cra);
            cell = mergeRow.createCell(1);
            String startTime = protectgrouplog.getStartTime();
            cell.setCellValue(startTime != null ? CommUtils.formatData(startTime) : "--");
            cell.setCellStyle((CellStyle)cs);
            cra = new CellRangeAddress(rowIndex, rowMergeIndex, 1, 1);
            this.setRangeBorder(sheet, cra);
            cell = mergeRow.createCell(2);
            String endTime = protectgrouplog.getEndTime();
            cell.setCellValue(endTime != null ? CommUtils.formatData(endTime) : "--");
            cell.setCellStyle((CellStyle)cs);
            cra = new CellRangeAddress(rowIndex, rowMergeIndex, 2, 2);
            this.setRangeBorder(sheet, cra);
            cell = mergeRow.createCell(3);
            String executeTime = this.protectGroupService.calcExecuteTime(protectgrouplog.getStartTime(), protectgrouplog.getEndTime());
            cell.setCellValue(executeTime);
            cs.setAlignment(HorizontalAlignment.LEFT);
            cell.setCellStyle((CellStyle)cs);
            cra = new CellRangeAddress(rowIndex, rowMergeIndex, 3, 3);
            this.setRangeBorder(sheet, cra);
            ++rowIndex;
            if (VerifyUtil.isEmpty((String)batchOperation.getTargetName())) continue;
            counterror.add(batchOperation);
        }
        this.result.setResult(counterror);
        this.result.setFailCount(counterror.size());
        this.result.setTotalCount(protectGroupLogs.size());
    }
}

