/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.recovery;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.license.sdk.ILicenseBaseControl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.recovery.IBaseRecoveryPlanRestService;
import com.huawei.ism.drm.rest.service.platform.recovery.RecoveryPlanEntity;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseAbstractRecoveryPlanRestService
extends AbstractRestService
implements IBaseRecoveryPlanRestService {
    private static final Log LOGGER = LogFactory.getInstance(BaseAbstractRecoveryPlanRestService.class);

    protected boolean isLocalSite(String siteId) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            return false;
        }
        Site site = this.getSiteService().getSiteById(siteId);
        return !VerifyUtil.isEmpty((Object)site) && 0 == site.getSiteType();
    }

    protected boolean isExistLocalRecoverySite(Set<String> disasterSiteIds) {
        ISiteBaseService siteService = this.getBundleService(ISiteBaseService.class.getName(), ISiteBaseService.class);
        List localSites = siteService.getAllLocalSites();
        boolean isLoacalDisasterSite = false;
        for (String disasterSiteId : disasterSiteIds) {
            Site disasterSite = siteService.getSiteById(disasterSiteId);
            if (disasterSite == null || !localSites.contains(disasterSite)) continue;
            isLoacalDisasterSite = true;
            break;
        }
        return isLoacalDisasterSite;
    }

    protected void checkOperationPrivilegeBySite(RecoveryPlan rp) {
        boolean isLocalRecoverySite;
        if (rp == null || VerifyUtil.isEmpty((Collection)rp.getProtectGroups())) {
            throw new LegoCheckedException(1073947393L);
        }
        ISiteBaseService siteService = this.getBundleService(ISiteBaseService.class.getName(), ISiteBaseService.class);
        Iterator iterator = rp.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(2117645L);
        }
        String productSiteId = ((ProtectGroup)iterator.next()).getProductSiteId();
        Site productSite = siteService.getSiteById(productSiteId);
        List localSites = siteService.getAllLocalSites();
        if (!localSites.contains(productSite)) {
            return;
        }
        Set<String> disasterSiteIds = this.getDisasterSiteIds(rp);
        if (!VerifyUtil.isEmpty(disasterSiteIds) && 1 == disasterSiteIds.size() && !(isLocalRecoverySite = this.isExistLocalRecoverySite(disasterSiteIds))) {
            throw new LegoCheckedException(1073948711L);
        }
    }

    protected void initTestInfo(String recoveryPlanId, RecoveryPlanEntity selectedRp) {
        IRecoveryPlanBaseService rpService = this.getRecoveryPlanService();
        Map statisticsInfo = new HashMap();
        if (!VerifyUtil.isEmpty((String)recoveryPlanId)) {
            statisticsInfo = rpService.getDrillingStatisticsInfo(recoveryPlanId);
        }
        int successCount = 0;
        int errorCount = 0;
        int totalCount = 0;
        if (!VerifyUtil.isEmpty(statisticsInfo)) {
            successCount = (Integer)statisticsInfo.get("successCount");
            errorCount = (Integer)statisticsInfo.get("failCount");
            totalCount = (Integer)statisticsInfo.get("totalCount");
        }
        selectedRp.setTestCount(totalCount);
        selectedRp.setTestFailureCount(errorCount);
        selectedRp.setTestSuccessCount(successCount);
    }

    protected String constructSiteDisplayById(String siteId) {
        Site site = this.getSiteService().getSiteById(siteId);
        if (site == null) {
            LOGGER.info((Object)"The site is not registered.");
            throw new LegoCheckedException(1073948692L);
        }
        return site.getName();
    }

    protected Set<String> getDisasterSiteIds(RecoveryPlan rp) {
        HashSet<String> disasterSites = new HashSet<String>();
        Set protectGroups = rp.getProtectGroups();
        for (ProtectGroup protectGroup : protectGroups) {
            Set gpReplicas = protectGroup.getReplicaList();
            for (ProtectGroupReplica gpReplica : gpReplicas) {
                disasterSites.add(gpReplica.getRecoverySite());
            }
        }
        return disasterSites;
    }

    protected abstract String getKeyByType(DrmEnumDefine.RecoveryPlanExecuteTypeE var1);

    protected IRecoveryPlanBaseService getRecoveryPlanService() {
        return this.getBundleService(IRecoveryPlanBaseService.class);
    }

    protected ISiteBaseService getSiteService() {
        return this.getBundleService(ISiteBaseService.class);
    }

    protected void checkLicenseControl(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            throw new LegoCheckedException(1073947394L);
        }
        ILicenseBaseControl licenseControl = this.getBundleService(ILicenseBaseControl.class);
        PolicyTemplate policyTemplate = null;
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        ProtectGroup pg = null;
        if (iterator.hasNext()) {
            pg = (ProtectGroup)iterator.next();
            policyTemplate = pg.getTemplate();
        }
        if (VerifyUtil.isEmpty(policyTemplate)) {
            throw new LegoCheckedException(1073947394L);
        }
        licenseControl.isEnableRecoveryPlan(pg);
    }

    protected abstract void checkLicenseControl(RecoveryPlan var1, DrmEnumDefine.RecoveryPlanExecuteTypeE var2);

    protected void checkLicenseCount(ProtectGroup pg) {
        ILicenseBaseControl licenseControl = this.getBundleService(ILicenseBaseControl.class);
        licenseControl.checkEnablePgCount(pg);
    }

    protected String stringToJSONString(String string) {
        JSONArray jsonArray;
        if (VerifyUtil.isEmpty((String)string)) {
            return string;
        }
        String jsonString = null;
        try {
            jsonArray = JSONArray.fromObject((Object)string);
        }
        catch (Exception e) {
            String[] strArray;
            jsonArray = new JSONArray();
            for (String str : strArray = string.split(";")) {
                jsonArray.add((Object)str);
            }
        }
        if (jsonArray != null) {
            jsonString = jsonArray.toString();
        }
        return jsonString;
    }
}

