/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.recovery;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.mo.ProtectObjectBo;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.rest.service.platform.recovery.BaseAbstractRecoveryPlanRestService;
import com.huawei.ism.drm.rest.service.platform.recovery.RecoveryPlanEntity;
import com.huawei.ism.drm.rest.util.ParamValidator;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseRecoveryPlanQueryRestServiceImpl
extends BaseAbstractRecoveryPlanRestService {
    private static final Log LOGGER = LogFactory.getInstance(BaseRecoveryPlanQueryRestServiceImpl.class);
    private static final String IS_CONFIRM_REPROTECTION = "is.confirm.reprotection";

    @Override
    @ParamValidator
    public String recoveryplans(String orderBy, String orderType, int pageSize, int startPage, int planType) {
        if (!Validator.checkPageQueryParams(orderType, pageSize, startPage)) {
            throw new LegoCheckedException(1073947393L);
        }
        Validator.canOrderBy(orderBy);
        this.checkUserQueryAuth();
        boolean orderByAscend = "asc".equalsIgnoreCase(orderType);
        JSONObject result = new JSONObject();
        Map<String, Object> extFilterMap = this.getExtParamInQueryParam();
        if (!this.checkExtFilterMap(extFilterMap)) {
            LOGGER.error((Object)"Invalid extFilterMap!");
            throw new LegoCheckedException(1073947393L);
        }
        Page page = this.getRecoveryPlanService().pageQueryRecoveryPlan(startPage, pageSize, orderBy, orderByAscend, planType, extFilterMap, this.getCurrentUserId());
        if (this.checkPage(page)) {
            result.put((Object)"totalCount", (Object)0);
            result.put((Object)"records", (Object)"[]");
            return result.toString();
        }
        ArrayList<Integer> susccessStatuList = new ArrayList<Integer>();
        susccessStatuList.add(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED.getValue());
        susccessStatuList.add(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED.getValue());
        susccessStatuList.add(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_COMPLETED.getValue());
        susccessStatuList.add(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue());
        susccessStatuList.add(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_COMPLETED.getValue());
        susccessStatuList.add(DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED.getValue());
        HashMap<String, String> planIdToLogId = new HashMap<String, String>();
        List recoveryPlans = page.getResult();
        for (RecoveryPlan plan : recoveryPlans) {
            if (susccessStatuList.contains(plan.getPlanStatus()) && plan.getProcessStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue()) {
                String logId = this.getRecoveryPlanService().getLatestRecoveryLogIdBy(plan.getPlanId());
                planIdToLogId.put(plan.getPlanId(), logId);
            }
            boolean isConfirmReprotection = LegoBaseConfig.getInstance().getBoolean(IS_CONFIRM_REPROTECTION, Boolean.valueOf(true));
            plan.setSupportConfirmReprotection(isConfirmReprotection);
            this.refactorGlobalSettings(plan);
        }
        result.put((Object)"totalCount", (Object)page.getTotalCount());
        result.put((Object)"records", (Object)this.toRecoveryPlanJson(recoveryPlans, planIdToLogId));
        return result.toString();
    }

    private boolean checkExtFilterMap(Map<String, Object> extFilterMap) {
        int maxExtFilterMapEntries = 128;
        if (extFilterMap.entrySet().size() > maxExtFilterMapEntries) {
            return false;
        }
        for (Map.Entry<String, Object> entry : extFilterMap.entrySet()) {
            switch (entry.getKey()) {
                case "appType": 
                case "name": {
                    if (ParamChecker.checkGeneralText((String)((String)entry.getValue()))) break;
                    return false;
                }
                case "productSiteId": 
                case "protectGroupId": 
                case "replicaId": 
                case "mountSiteId": 
                case "mountHostId": {
                    if (ParamChecker.checkGeneralId((String)((String)entry.getValue()))) break;
                    return false;
                }
                case "planStatus": {
                    if (VerifyUtil.isEmpty((String)((String)entry.getValue())) || Integer.parseInt((String)entry.getValue()) >= 0 && Integer.parseInt((String)entry.getValue()) <= 100) break;
                    return false;
                }
                case "createStartTime": 
                case "createEndTime": {
                    if (VerifyUtil.isEmpty((String)((String)entry.getValue())) || Validator.isDateAndTime((String)entry.getValue())) break;
                    return false;
                }
            }
        }
        return true;
    }

    protected abstract void refactorGlobalSettings(RecoveryPlan var1);

    @Override
    @ParamValidator
    public String recoveryplans(String planId) {
        this.checkPlanId(planId);
        this.checkUserQueryAuth();
        this.checkUserBizObjQueryAuth(planId);
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        if (VerifyUtil.isEmpty((Object)recoveryPlan)) {
            throw new LegoCheckedException(1073947394L);
        }
        return this.toRecoveryPlanJson(recoveryPlan, "");
    }

    @Override
    @ParamValidator
    public String queryAvailabelProtectGroup(Integer drpType) {
        if (null == drpType || DrmEnumDefine.RecoveryPlanTypeE.getType((int)drpType) == null && drpType != -1) {
            LOGGER.debug((Object)"The params is null.");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserQueryAuth();
        if (drpType == -1) {
            ArrayList<ProtectGroup> allProtectGroups = new ArrayList<ProtectGroup>();
            List pgsLocal = this.getRecoveryPlanService().getAvailableProtectGroups(this.getCurrentUserId().longValue(), DrmEnumDefine.RecoveryPlanTypeE.LOCAL);
            List pgsRemote = this.getRecoveryPlanService().getAvailableProtectGroups(this.getCurrentUserId().longValue(), DrmEnumDefine.RecoveryPlanTypeE.REMOTE);
            allProtectGroups.addAll(pgsLocal);
            allProtectGroups.addAll(pgsRemote);
            return this.toProtectGroupJson(allProtectGroups);
        }
        DrmEnumDefine.RecoveryPlanTypeE drpTypeEnum = DrmEnumDefine.RecoveryPlanTypeE.getType((int)drpType);
        CommUtil.checkEnumByType(DrmEnumDefine.RecoveryPlanTypeE.class, (int)drpType);
        List protectGrous = this.getRecoveryPlanService().getAvailableProtectGroups(this.getCurrentUserId().longValue(), drpTypeEnum);
        return this.toProtectGroupJson(protectGrous);
    }

    @Override
    @ParamValidator
    public String logs(String planId, String orderBy, String orderType, int pageSize, int startPage) {
        this.checkPlanId(planId);
        if (!Validator.checkPageQueryParams(orderType, pageSize, startPage)) {
            LOGGER.debug((Object)"page params is incorrect");
            throw new LegoCheckedException(1073947393L);
        }
        Validator.canOrderBy(orderBy);
        this.checkUserQueryAuth();
        this.checkUserBizObjQueryAuth(planId);
        JSONObject resultObject = new JSONObject();
        boolean orderByAscend = "asc".equalsIgnoreCase(orderType);
        Page page = this.getRecoveryPlanService().pageQueryRecoveryLog(planId, startPage, pageSize, orderBy, orderByAscend);
        if (VerifyUtil.isEmpty((Object)page) || VerifyUtil.isEmpty((Collection)page.getResult())) {
            return "";
        }
        List recoveryLogs = page.getResult();
        JSONArray result = this.constructResult(recoveryLogs);
        resultObject.put((Object)"totalCount", (Object)page.getTotalCount());
        resultObject.put((Object)"records", (Object)result);
        return resultObject.toString();
    }

    private JSONArray constructResult(List<RecoveryLog> recoveryLogs) {
        JSONArray result = new JSONArray();
        for (RecoveryLog rplog : recoveryLogs) {
            JSONObject logJsonObj = new JSONObject();
            logJsonObj.put((Object)"logId", (Object)rplog.getLogId());
            logJsonObj.put((Object)"logType", (Object)rplog.getLogType());
            logJsonObj.put((Object)"logStatus", (Object)rplog.getLogStatus());
            logJsonObj.put((Object)"operator", (Object)rplog.getOperator());
            logJsonObj.put((Object)"logName", (Object)rplog.getLogName());
            if (VerifyUtil.isEmpty((String)rplog.getStartTime())) {
                logJsonObj.put((Object)"startTime", (Object)"--");
            } else {
                logJsonObj.put((Object)"startTime", (Object)CommUtils.formatDate(new Date(NumberUtil.convertToLong((Object)rplog.getStartTime()))));
            }
            if (VerifyUtil.isEmpty((String)rplog.getEndTime())) {
                logJsonObj.put((Object)"endTime", (Object)"--");
            } else {
                logJsonObj.put((Object)"endTime", (Object)CommUtils.formatDate(new Date(NumberUtil.convertToLong((Object)rplog.getEndTime()))));
            }
            String executeTime = this.calcExecuteTime(rplog.getStartTime(), rplog.getEndTime());
            logJsonObj.put((Object)"executeTime", (Object)executeTime);
            logJsonObj.put((Object)"planId", (Object)rplog.getPlanId());
            logJsonObj.put((Object)"processId", (Object)rplog.getProcessId());
            logJsonObj.put((Object)"excuteDetail", (Object)"");
            result.add((Object)logJsonObj);
        }
        return result;
    }

    @Override
    @ParamValidator
    public String queryProtectObjectInRp(String planId, String orderBy, String orderType, int pageSize, int startPage) {
        this.checkPlanId(planId);
        if (!Validator.checkPageQueryParams(orderType, pageSize, startPage)) {
            LOGGER.debug((Object)"page params is incorrect");
            throw new LegoCheckedException(1073947393L);
        }
        Validator.canOrderBy(orderBy);
        this.checkUserQueryAuth();
        this.checkUserBizObjQueryAuth(planId);
        JSONObject returnObject = new JSONObject();
        Page page = this.getRecoveryPlanService().pageQueryProtectObjectInRP(planId, startPage, pageSize, orderBy, !"desc".equalsIgnoreCase(orderType));
        if (VerifyUtil.isEmpty((Object)page)) {
            LOGGER.debug((Object)"Param page is null");
            return returnObject.toString();
        }
        int total = (int)page.getTotalCount();
        returnObject.put((Object)"totalCount", (Object)total);
        List protectObjectBos = page.getResult();
        if (VerifyUtil.isEmpty((Collection)protectObjectBos)) {
            return returnObject.toString();
        }
        JSONArray jsonArray = new JSONArray();
        for (ProtectObjectBo protectObjectBo : protectObjectBos) {
            this.poToJsonStr(jsonArray, protectObjectBo);
        }
        returnObject.put((Object)"records", (Object)jsonArray);
        return returnObject.toString();
    }

    @Override
    @ParamValidator
    public String queryRecoverySites(String planId) {
        this.checkPlanId(planId);
        this.checkUserQueryAuth();
        this.checkUserBizObjQueryAuth(planId);
        RecoveryPlan rp = this.getRecoveryPlanService().getRecoveryPlan(planId);
        CommUtils.checkObjectExists(rp);
        CommUtils.checkObjectExists(rp.getProtectGroups());
        JSONArray returnArray = new JSONArray();
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)rp.getProtectGroups());
        if (pg == null) {
            throw new LegoCheckedException(2117645L);
        }
        List<Site> siteList = this.getRecoverySiteList(pg);
        Collections.sort(siteList, new CommonComparator("name", true));
        for (Site site : siteList) {
            returnArray.add((Object)this.toJsonStrSite(site));
        }
        return returnArray.toString();
    }

    protected abstract List<Site> getRecoverySiteList(ProtectGroup var1);

    @Override
    @ParamValidator
    public String queryAllStepByType(String planId, int procType) {
        this.checkPlanId(planId);
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType);
        CommUtils.checkParamEmpty(type);
        this.checkUserQueryAuth();
        this.checkUserBizObjQueryAuth(planId);
        JSONArray result = new JSONArray();
        IRecoveryPlanBaseService rpService = this.getRecoveryPlanService();
        List recoverSteps = rpService.getRecoveryProcessors(planId, type);
        if (VerifyUtil.isEmpty((Collection)recoverSteps)) {
            LOGGER.debug((Object)"param is null");
            return result.toString();
        }
        RecoveryPlan recoveryPlan = rpService.getRecoveryPlan(planId);
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        IPolicyTemplateManager policyTemplateManager = this.getBundleService(IPolicyTemplateManager.class);
        String ptId = protectGroup.getTemplate().getPtId();
        PolicyTemplate policyTemplate = policyTemplateManager.getPtByUuid(ptId);
        for (RecoveryProcessor step : recoverSteps) {
            JSONObject jsonObject = this.buildRecoveryStepsJson(planId, type, policyTemplate, step);
            if (VerifyUtil.isEmpty((Map)jsonObject)) continue;
            result.add((Object)jsonObject);
        }
        return result.toString();
    }

    protected abstract JSONObject buildRecoveryStepsJson(String var1, DrmEnumDefine.RecoveryPlanExecuteTypeE var2, PolicyTemplate var3, RecoveryProcessor var4);

    @Override
    @ParamValidator
    public RecoveryPlanEntity queryDRPAbstractInfo(String planId) {
        RecoveryLog recoveryLog;
        RecoveryPlanEntity selectedRP;
        block6: {
            this.checkPlanId(planId);
            this.checkUserQueryAuth();
            this.checkUserBizObjQueryAuth(planId);
            IRecoveryPlanBaseService rpService = this.getRecoveryPlanService();
            RecoveryPlan plan = rpService.getRecoveryPlan(planId, false, false);
            if (null == plan) {
                throw new LegoCheckedException(201L);
            }
            selectedRP = this.constructRecoveryPlanEntity(plan);
            recoveryLog = null;
            try {
                recoveryLog = rpService.getLatestHistoryRecoveryLog(planId);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"LegoCheckedException:", (Throwable)e, 90160758784001L);
                if (1073947394L == e.getErrorCode()) break block6;
                throw e;
            }
        }
        if (!VerifyUtil.isEmpty((Object)recoveryLog)) {
            Date startDate = null;
            String startTimeString = recoveryLog.getStartTime();
            String endTimeString = recoveryLog.getEndTime();
            String date = "";
            if (!VerifyUtil.isEmpty((String)startTimeString)) {
                startDate = new Date(NumberUtil.convertToLong((Object)startTimeString));
                date = CommUtil.formatDate((Date)startDate);
            }
            String excuteTime = null;
            if (!VerifyUtil.isEmpty((String)endTimeString)) {
                Date endDate = new Date(NumberUtil.convertToLong((Object)endTimeString));
                excuteTime = String.valueOf(endDate.getTime() - (null == startDate ? 0L : startDate.getTime()));
            }
            selectedRP.setLastExecuteDate(date);
            selectedRP.setLastExecuteTime(excuteTime);
            selectedRP.setLastExecuteResult(recoveryLog.getLogStatus());
            selectedRP.setLastExecuteUser(recoveryLog.getOperator());
            selectedRP.setLastExecuteType(recoveryLog.getLogType());
            this.initTestInfo(planId, selectedRP);
        }
        return selectedRP;
    }

    @Override
    @ParamValidator
    public String viewRecoveryPlanExecuteSteps(String planId, int procType) {
        this.checkPlanId(planId);
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType) == null) {
            LOGGER.debug((Object)"procType is incorrect");
            throw new LegoCheckedException(-1L);
        }
        this.checkUserQueryAuth();
        this.checkUserBizObjQueryAuth(planId);
        IRecoveryPlanBaseService rpService = this.getRecoveryPlanService();
        List recoverDetails = rpService.getRecoveryProcessorDetailsByPlanId(planId, DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType));
        return this.toRecoveryProcessorDetailJsonStr(recoverDetails);
    }

    @Override
    @ParamValidator
    public String queryRecoveryGlobalSettings(String planId, String key) {
        this.checkPlanId(planId);
        this.checkUserQueryAuth();
        this.checkUserBizObjQueryAuth(planId);
        IRecoveryPlanBaseService recoveryPlanService = this.getRecoveryPlanService();
        RecoveryPlan recoveryPlan = recoveryPlanService.getRecoveryPlan(planId);
        CommUtils.checkObjectExists(recoveryPlan);
        JSONObject jsonObject = new JSONObject();
        if (VerifyUtil.isEmpty((String)key)) {
            Map globalSettings = recoveryPlan.getGlobalSettings();
            for (Map.Entry eachEntry : globalSettings.entrySet()) {
                jsonObject.put(eachEntry.getKey(), eachEntry.getValue());
            }
        } else {
            if (!ParamChecker.checkGeneralText((String)key)) {
                LOGGER.error((Object)"Invalid key");
                throw new LegoCheckedException(1073947393L);
            }
            String value = (String)recoveryPlan.getGlobalSettings().get(key);
            if (VerifyUtil.isEmpty((String)value)) {
                Iterator iterator;
                value = "";
                Set settings = RecoveryUtil.getRecoverySettingsByItemKey((String)planId, (String)key, (Set)recoveryPlan.getRecoverySettings());
                if (!VerifyUtil.isEmpty((Collection)settings) && (iterator = settings.iterator()).hasNext()) {
                    RecoverySetting setting = (RecoverySetting)iterator.next();
                    value = setting.getValue();
                }
            }
            jsonObject.put((Object)key, (Object)value);
        }
        return jsonObject.toString();
    }

    @Override
    @ParamValidator
    public String viewRecoveryPlanExecuteLogDetail(String planId, String logId) {
        this.checkPlanId(planId);
        if (VerifyUtil.isEmpty((String)logId)) {
            LOGGER.debug((Object)"logId is null");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)logId)) {
            LOGGER.error((Object)"logId is incorrect");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserQueryAuth();
        this.checkUserBizObjQueryAuth(planId);
        IRecoveryPlanBaseService rpService = this.getRecoveryPlanService();
        List recoverDetails = rpService.getRecoveryProcessorDetailsByLogId(planId, logId);
        return this.toRecoveryProcessorDetailJsonStr(recoverDetails);
    }

    protected void checkUserQueryAuth() {
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
    }

    protected void checkUserBizObjQueryAuth(String planId) {
        this.checkUserBizObjAuthority("recoveryPlan_query_operateName", 2, planId);
    }

    private RecoveryPlanEntity constructRecoveryPlanEntity(RecoveryPlan plan) {
        RecoveryPlanEntity planEntity = new RecoveryPlanEntity();
        if (VerifyUtil.isEmpty((Object)plan)) {
            LOGGER.debug((Object)"param is null");
            return planEntity;
        }
        planEntity.setPlanId(plan.getPlanId());
        planEntity.setPlanName(plan.getName());
        planEntity.setPlanDesc(plan.getDescription());
        planEntity.setPlanType(plan.getPlanType());
        if (VerifyUtil.isEmpty((Collection)plan.getProtectGroups())) {
            return planEntity;
        }
        Iterator iterator = plan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            return planEntity;
        }
        ProtectGroup pg = (ProtectGroup)iterator.next();
        if (VerifyUtil.isEmpty((Object)pg)) {
            return planEntity;
        }
        planEntity.setAppType(pg.getPoType());
        planEntity.setMasterSiteId(pg.getProductSiteId());
        planEntity.setMasterSiteDisplay(this.constructSiteDisplayById(pg.getProductSiteId()));
        planEntity.setProtectGroupName(pg.getName());
        int planStatus = plan.getPlanStatus();
        planEntity.setPlanStatus(planStatus);
        planEntity.setPlanProgress(plan.getPlanProgress());
        if (DrmEnumDefine.RecoveryPlanStatusE.READY == DrmEnumDefine.RecoveryPlanStatusE.getType((int)planStatus)) {
            planEntity.setPlanProgress(0);
        }
        planEntity.setLastTestStatus(plan.getLastTestStatus());
        return planEntity;
    }

    private List<QueryCondition> rpFilterCondition(String filterName, String filterValue) {
        ArrayList<QueryCondition> qcs = new ArrayList<QueryCondition>();
        if (VerifyUtil.isEmpty((String)filterName) || VerifyUtil.isEmpty((String)filterValue)) {
            LOGGER.debug((Object)"param is null");
            return qcs;
        }
        if (filterName.equalsIgnoreCase("planStatus")) {
            QueryCondition qc = new QueryCondition(filterName, (Object)NumberUtil.convertToInteger((Object)filterValue));
            qcs.add(qc);
        } else {
            QueryCondition qc = new QueryCondition(filterName, (Object)filterValue);
            qcs.add(qc);
        }
        return qcs;
    }

    private String toRecoveryPlanJson(List<RecoveryPlan> recoveryPlans, Map<String, String> planIdToLogId) {
        if (VerifyUtil.isEmpty(recoveryPlans)) {
            LOGGER.debug((Object)"param is null");
            return "[]";
        }
        JSONArray result = new JSONArray();
        for (RecoveryPlan recoveryPlan : recoveryPlans) {
            result.add((Object)this.toRecoveryPlanJson(recoveryPlan, planIdToLogId.get(recoveryPlan.getPlanId())));
        }
        return result.toString();
    }

    protected abstract String toRecoveryPlanJson(RecoveryPlan var1, String var2);

    protected String toProtectGroupJson(List<ProtectGroup> protectGrsours) {
        JSONArray result = new JSONArray();
        if (VerifyUtil.isEmpty(protectGrsours)) {
            LOGGER.debug((Object)"param is null");
            return result.toString();
        }
        for (ProtectGroup protectGroup : protectGrsours) {
            result.add((Object)this.toProtectGroupJson(protectGroup));
        }
        return result.toString();
    }

    private String toProtectGroupJson(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            LOGGER.debug((Object)"Param protectGroup is null");
            return "";
        }
        JSONObject pgJsonObj = new JSONObject();
        pgJsonObj.put((Object)"uuid", (Object)protectGroup.getUuid());
        pgJsonObj.put((Object)"name", (Object)protectGroup.getName());
        pgJsonObj.put((Object)"description", (Object)protectGroup.getDescription());
        pgJsonObj.put((Object)"poType", (Object)protectGroup.getPoType());
        pgJsonObj.put((Object)"status", (Object)protectGroup.getStatus());
        pgJsonObj.put((Object)"productSiteId", (Object)protectGroup.getProductSiteId());
        pgJsonObj.put((Object)"productSiteName", (Object)this.constructSiteDisplayById(protectGroup.getProductSiteId()));
        pgJsonObj.put((Object)"poProviderSN", (Object)protectGroup.getPoProviderSN());
        pgJsonObj.put((Object)"lastExecTime", (Object)protectGroup.getLastExecTime());
        pgJsonObj.put((Object)"lastExecResult", (Object)protectGroup.getLastExecResult());
        PolicyTemplate template = protectGroup.getTemplate();
        JSONObject templateJsonObj = new JSONObject();
        templateJsonObj.put((Object)"uuid", (Object)template.getUuid());
        templateJsonObj.put((Object)"name", (Object)template.getName());
        templateJsonObj.put((Object)"description", (Object)template.getDescription());
        templateJsonObj.put((Object)"ptId", (Object)template.getPtId());
        templateJsonObj.put((Object)"type", (Object)template.getType());
        templateJsonObj.put((Object)"subType", (Object)template.getSubType());
        pgJsonObj.put((Object)"template", (Object)templateJsonObj);
        Map props = protectGroup.getProps();
        if (props != null) {
            pgJsonObj.put((Object)"props", (Object)props);
        }
        return pgJsonObj.toString();
    }

    protected int isAllowExecuteRecoveryPlan(RecoveryPlan recoveryPlan) {
        int isAllowExecute = 1;
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == recoveryPlan.getPlanType()) {
            LOGGER.debug((Object)"is local");
            return isAllowExecute;
        }
        if (VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(2117645L);
        }
        if (this.isLocalSite(((ProtectGroup)iterator.next()).getProductSiteId())) {
            boolean isLocalRecoverySite;
            Set<String> disasterSiteIds = this.getDisasterSiteIds(recoveryPlan);
            isAllowExecute = !VerifyUtil.isEmpty(disasterSiteIds) && 1 == disasterSiteIds.size() ? (!(isLocalRecoverySite = this.isLocalSite(disasterSiteIds.iterator().next())) ? 0 : 1) : this.checkIfAllowExecute(recoveryPlan);
        } else {
            Set<String> disasterSiteIds = this.getDisasterSiteIds(recoveryPlan);
            if (!VerifyUtil.isEmpty(disasterSiteIds) && 1 != disasterSiteIds.size()) {
                isAllowExecute = this.checkIfAllowExecute(recoveryPlan);
            }
        }
        return isAllowExecute;
    }

    private int checkIfAllowExecute(RecoveryPlan recoveryPlan) {
        int isAllowExecute = 1;
        try {
            this.checkRecoveryOperationPrivilegeBySite(recoveryPlan);
        }
        catch (LegoCheckedException e) {
            if (1073948711L == e.getErrorCode() || 1073948730L == e.getErrorCode()) {
                isAllowExecute = 0;
            }
            LOGGER.error((Object)"LegoCheckedException,errorCode:%s,error :%s.", new Object[]{String.valueOf(e.getErrorCode()), ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return isAllowExecute;
    }

    private void checkRecoveryOperationPrivilegeBySite(RecoveryPlan rp) {
        this.checkOperationPrivilegeBySite(rp);
        String curDisasterSiteId = (String)rp.getGlobalSettings().get("DISASTER_SITE_ID");
        if (VerifyUtil.isEmpty((String)curDisasterSiteId)) {
            LOGGER.debug((Object)"param is null");
            return;
        }
        ISiteBaseService siteService = this.getBundleService(ISiteBaseService.class.getName(), ISiteBaseService.class);
        Site curDisasterSite = siteService.getSiteById(curDisasterSiteId);
        if (null == curDisasterSite) {
            return;
        }
        if (DrmEnumDefine.RecoveryPlanStatusE.READY.getValue() == rp.getPlanStatus() || DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED.getValue() == rp.getPlanStatus() || DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue() == rp.getPlanStatus()) {
            return;
        }
        if (0 != curDisasterSite.getSiteType()) {
            throw new LegoCheckedException(1073948730L);
        }
    }

    private String toJsonStrSite(Site site) {
        JSONObject object = new JSONObject();
        if (VerifyUtil.isEmpty((Object)site)) {
            LOGGER.debug((Object)"site is null");
            return object.toString();
        }
        object.put((Object)"siteId", (Object)site.getSiteId());
        object.put((Object)"name", (Object)site.getName());
        object.put((Object)"description", (Object)site.getDescription());
        object.put((Object)"siteType", (Object)site.getSiteType());
        object.put((Object)"siteAlias", (Object)site.getSiteAlias());
        object.put((Object)"createBy", (Object)site.getCreateBy());
        return object.toString();
    }

    private String toRecoveryProcessorDetailJsonStr(Collection<RecoveryProcessorDetail> recoverDetails) {
        JSONArray jsonArray = new JSONArray();
        if (VerifyUtil.isEmpty(recoverDetails)) {
            LOGGER.debug((Object)"recoverDetails is null");
            return jsonArray.toString();
        }
        int i = 0;
        for (RecoveryProcessorDetail rpd : recoverDetails) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"detailId", (Object)rpd.getDetailId());
            if (!VerifyUtil.isEmpty((String)rpd.getStartTime())) {
                jsonObject.put((Object)"startTime", (Object)CommUtil.formatDate((Date)new Date(NumberUtil.convertToLong((Object)rpd.getStartTime()))));
            } else {
                jsonObject.put((Object)"startTime", (Object)"--");
            }
            jsonObject.put((Object)"status", (Object)rpd.getProcessStatus());
            if (!VerifyUtil.isEmpty((String)rpd.getEndTime())) {
                jsonObject.put((Object)"endTime", (Object)CommUtil.formatDate((Date)new Date(NumberUtil.convertToLong((Object)rpd.getEndTime()))));
            } else {
                jsonObject.put((Object)"endTime", (Object)"--");
            }
            String executeTime = this.calcExecuteTime(rpd.getStartTime(), rpd.getEndTime());
            jsonObject.put((Object)"executeTime", (Object)executeTime);
            jsonObject.put((Object)"processName", (Object)rpd.getProcessName());
            jsonObject.put((Object)"processNameParams", (Object)this.stringToJSONString(rpd.getProcessNameParams()));
            jsonObject.put((Object)"processDetail", (Object)rpd.getProcessDetail());
            jsonObject.put((Object)"processDetailParams", (Object)this.stringToJSONString(rpd.getProcessDetailParams()));
            jsonObject.put((Object)"processStatus", (Object)rpd.getProcessStatus());
            jsonObject.put((Object)"logId", (Object)rpd.getLogId());
            jsonObject.put((Object)"procId", (Object)rpd.getProcId());
            jsonObject.put((Object)"procIndex", (Object)i++);
            jsonObject.put((Object)"parentDetailId", (Object)rpd.getParentDetailId());
            jsonObject.put((Object)"children", (Object)this.toRecoveryProcessorDetailJsonStr(rpd.getChildDetails()));
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray.toString();
    }

    private void poToJsonStr(JSONArray jsonArray, ProtectObjectBo protectObjectBo) {
        LOGGER.debug((Object)"begin poToJsonStr");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"uuid", (Object)protectObjectBo.getPoId());
        jsonObject.put((Object)"moUuid", (Object)protectObjectBo.getMoUuid());
        jsonObject.put((Object)"name", (Object)protectObjectBo.getName());
        jsonObject.put((Object)"pgName", (Object)protectObjectBo.getPgName());
        jsonObject.put((Object)"poRecoveryStatus", (Object)protectObjectBo.getPoRecoveryStatus());
        jsonObject.put((Object)"poType", (Object)protectObjectBo.getPoType());
        jsonObject.put((Object)"props", (Object)protectObjectBo.getProps());
        jsonObject.put((Object)"providerSN", (Object)protectObjectBo.getProviderSN());
        jsonObject.put((Object)"providerName", (Object)protectObjectBo.getProviderName());
        jsonArray.add((Object)jsonObject);
    }

    private boolean checkPage(Page page) {
        LOGGER.debug((Object)"begin checkPage");
        return VerifyUtil.isEmpty((Object)page) || VerifyUtil.isEmpty((Collection)page.getResult());
    }

    protected void checkPlanId(String planId) {
        if (VerifyUtil.isEmpty((String)planId)) {
            LOGGER.error((Object)"planId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)planId)) {
            LOGGER.error((Object)"planId is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
    }
}

