/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.site;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.site.IBaseSiteRestService;
import com.huawei.ism.drm.rest.util.OperationLog;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.rest.util.ParamValidator;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Map;

public abstract class BaseSiteRestServiceImpl
extends AbstractRestService
implements IBaseSiteRestService {
    private static final Log LOGGER = LogFactory.getInstance(BaseSiteRestServiceImpl.class);
    private static final int ID_MAX_LENGTH = 64;

    @Override
    @ParamValidator
    @OperationLog(operationName="site_createSite_operateName", operationModule="site", level=1)
    @Permission(name={"ism.drm.site.auth.add"})
    public String createSite(Site site) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)site.getName());
        this.checkParam(site);
        JSONObject json = new JSONObject();
        try {
            String siteId = this.getSiteService().createSite(site, this.getCurrentUserId());
            json.put((Object)"siteId", (Object)siteId);
        }
        catch (LegoCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Create site failed,error =%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L);
        }
        return json.toString();
    }

    private void checkParam(Site site) {
        this.checkCommonParam(site);
        String serverUuid = site.getServerUuid();
        if (this.checkIdParam(serverUuid)) {
            LOGGER.error((Object)"The serverUuid is invalid, serverUuid=%s", new Object[]{serverUuid});
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralText((String)site.getCloudServiceProvider())) {
            LOGGER.error((Object)"The cloudServiceProvider is invalid, cloudServiceProvider=%s", new Object[]{site.getCloudServiceProvider()});
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralText((String)site.getDomainName())) {
            LOGGER.error((Object)"The domainName is invalid, domainName=%s", new Object[]{site.getDomainName()});
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)site.getProjectId())) {
            LOGGER.error((Object)"The projectId is invalid, projectId=%s", new Object[]{site.getProjectId()});
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected void checkCommonParam(Site site) {
        if (VerifyUtil.isEmpty((Object)site)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!CommUtil.checkDrmNameParam((String)site.getName())) {
            LOGGER.error((Object)"The siteName is invalid, siteName=%s", new Object[]{site.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        String siteDesc = HtmlStringConverter.decodeByLength(site.getDescription());
        if (!CommUtil.checkDrmDescParam((String)siteDesc)) {
            LOGGER.error((Object)"The siteDesc is invalid, siteDesc=%s", new Object[]{siteDesc});
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)site.getRegionId())) {
            LOGGER.error((Object)"The regionId is invalid, regionId=%s", new Object[]{site.getRegionId()});
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)site.getProxyId())) {
            LOGGER.error((Object)"The proxyId is invalid, proxyId=%s", new Object[]{site.getProxyId()});
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected void updateLocalSite(Site replica, Site newSite) {
        String oldName = replica.getName();
        String oldDesc = replica.getDescription();
        String newName = newSite.getName();
        String newDesc = newSite.getDescription();
        if (!CommUtil.checkDrmNameParam((String)newName)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!newName.equals(oldName)) {
            replica.setName(newName);
        }
        if (null != newDesc && !newDesc.equals(oldDesc)) {
            replica.setDescription(newDesc);
        }
        try {
            this.getSiteService().updateSite(replica, newName, this.getCurrentUserId());
            this.localSuccessLog(newName);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Modify local site failed.", (Throwable)e, 90160758784000L);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)oldName);
            throw e;
        }
    }

    protected JSONObject siteToJsonStr(Site site) {
        if (site == null) {
            return new JSONObject();
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"siteId", (Object)site.getSiteId());
        jsonObject.put((Object)"name", (Object)site.getName());
        jsonObject.put((Object)"siteAlias", (Object)site.getSiteAlias());
        jsonObject.put((Object)"description", (Object)site.getDescription());
        jsonObject.put((Object)"siteType", (Object)site.getSiteType());
        jsonObject.put((Object)"serverUuid", (Object)site.getServerUuid());
        jsonObject.put((Object)"isCloudSite", (Object)site.getIsCloudSite());
        jsonObject.put((Object)"cloudServiceProvider", (Object)site.getCloudServiceProvider());
        jsonObject.put((Object)"domainName", (Object)site.getDomainName());
        jsonObject.put((Object)"regionId", (Object)site.getRegionId());
        jsonObject.put((Object)"projectId", (Object)site.getProjectId());
        jsonObject.put((Object)"proxyId", (Object)site.getProxyId());
        jsonObject.put((Object)"createBy", (Object)site.getCreateBy());
        return jsonObject;
    }

    @Override
    @ParamValidator
    @Permission(name={"ism.drm.site.auth.scan"})
    public String getSiteById(String siteId) {
        this.checkSiteIdParam(siteId);
        Site site = this.getSiteService().getSiteById(siteId);
        if (site != null) {
            this.checkUserBizObjAuthority("site_querySite_operateName", 2, siteId);
        }
        return this.siteToJsonStr(site).toString();
    }

    private void localSuccessLog(String siteName) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)siteName);
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)new String[]{siteName});
    }

    @Override
    @ParamValidator
    @Permission(name={"ism.drm.site.auth.scan"})
    public String statSiteResource(String siteId) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            LOGGER.error((Object)"enter modifySite.siteId:%s", new Object[]{siteId});
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)siteId)) {
            LOGGER.error((Object)"modifySite.siteId is incorrect");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("site_querySite_operateName", 2, siteId);
        Map resStatistics = this.getSiteService().sum(siteId, this.getCurrentUserId());
        JSONObject resultObj = new JSONObject();
        resultObj.put((Object)"result", (Object)resStatistics);
        return resultObj.toString();
    }

    protected void checkSiteIdParam(String siteId) {
        if (this.checkIdParam(siteId)) {
            LOGGER.error((Object)"The siteId is invalid, siteId=%s", new Object[]{siteId});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private boolean checkIdParam(String id) {
        return VerifyUtil.isEmpty((String)id) || !ParamChecker.checkGeneralId((String)id) || id.length() > 64;
    }

    protected ISiteBaseService getSiteService() {
        return (ISiteBaseService)this.getBundleService("DRM_Base", ISiteBaseService.class.getName());
    }
}

