/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.util;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.Consistent;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindowRange;
import com.huawei.lego.cbb.user.sdk.constant.AccountTypeEnum;
import com.huawei.lego.cbb.user.sdk.model.Role;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgrBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Path;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.core.annotation.AnnotationUtils;

public final class BaseRestUtils {
    private static final Log LOGGER = LogFactory.getInstance(BaseRestUtils.class);

    private BaseRestUtils() {
    }

    public static void checkParamCommon(Object ... params) {
        if (!VerifyUtil.isEmpty((Object[])params)) {
            for (Object paramTmp : params) {
                if (!VerifyUtil.isEmpty((Object)paramTmp)) continue;
                LOGGER.error((Object)"paramter is null.", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
        } else {
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static String getIdFromUuid(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            return "";
        }
        if (uuid.contains(":")) {
            uuid = uuid.split(":")[1];
        }
        return uuid;
    }

    public static boolean isUserOperatorRoleOnly(Long userId) {
        if (VerifyUtil.isEmpty((Object)userId) || userId == -1L) {
            LOGGER.error((Object)"UserId is empty or sso user.");
            return false;
        }
        Object service = ServiceLocator.getBundleService((String)"user", (String)"usermgr");
        if (!(service instanceof IUserMgrBaseService)) {
            return false;
        }
        IUserMgrBaseService mgr = (IUserMgrBaseService)service;
        User user = mgr.getUserInfo(userId.longValue());
        Set roles = user.getRolesSet();
        if (CollectionUtils.isEmpty((Collection)roles)) {
            return false;
        }
        List roleList = roles.stream().map(Role::getRoleId).collect(Collectors.toList());
        return roleList.size() == 1 && (Long)roleList.get(0) == 2L;
    }

    public static String getRangesStr(Set<ResourceTimeWindowRange> ranges) {
        StringBuilder sb = new StringBuilder();
        for (ResourceTimeWindowRange range : ranges) {
            Date startDate = range.getStartTime();
            Date endDate = range.getEndTime();
            String[] strStartArray = new SimpleDateFormat("HH:mm:ss").format(startDate).split(":");
            String startHour = strStartArray[0];
            String startMin = strStartArray[1];
            String startStr = startHour + ":" + startMin;
            String[] strEndArray = new SimpleDateFormat("HH:mm:ss").format(endDate).split(":");
            String endHour = strEndArray[0];
            String endMin = strEndArray[1];
            String endStr = endHour + ":" + endMin;
            sb.append(startStr).append("--").append(endStr).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static List<DrStorage> filterBySn(String sns, List<DrStorage> storages) {
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)sns)) {
            ArrayList<DrStorage> storagesBySn = new ArrayList<DrStorage>();
            ArrayList<String> snList = new ArrayList<String>(Arrays.asList(sns.split(";")));
            for (DrStorage storage : storages) {
                if (!snList.contains(storage.getDeviceSn())) continue;
                storagesBySn.add(storage);
            }
            return storagesBySn;
        }
        return storages;
    }

    public static JSONObject convertLunToJsonObj(Lun lun) {
        JSONObject object = new JSONObject();
        object.put((Object)"resourceId", (Object)lun.getResourceId());
        object.put((Object)"lunId", (Object)lun.getLunId());
        object.put((Object)"devSn", (Object)lun.getDevSn());
        object.put((Object)"name", (Object)lun.getName());
        object.put((Object)"mapped", (Object)lun.getMapped());
        object.put((Object)"usedCapacity", (Object)lun.getUsedCapacity());
        object.put((Object)"totalCapacity", (Object)lun.getTotalCapacity());
        object.put((Object)"totalCapacityUnit", (Object)lun.getTotalCapacityUnit());
        object.put((Object)"wwn", (Object)lun.getWwn());
        object.put((Object)"runningStatus", (Object)lun.getRunningStatus());
        object.put((Object)"healthStatus", (Object)lun.getHealthStatus());
        return object;
    }

    public static boolean isQuerySelfOnly(Long userId) {
        if (VerifyUtil.isEmpty((Object)userId) || userId == -1L) {
            LOGGER.warn((Object)"UserId is empty or sso user.");
            return false;
        }
        IUserMgrBaseService mgr = (IUserMgrBaseService)ServiceLocator.getBundleService((String)"user", (String)"usermgr");
        User user = mgr.getUserInfo(userId.longValue());
        Set roles = user.getRolesSet();
        if (CollectionUtils.isEmpty((Collection)roles)) {
            return false;
        }
        if (user.getUserType() == AccountTypeEnum.MACHINE) {
            return false;
        }
        return roles.stream().map(Role::getRoleId).noneMatch(roleId -> roleId == 1L || roleId == 3L);
    }

    public static boolean isDownloadMethod(Method method) {
        if (method == null) {
            return false;
        }
        Path path = (Path)AnnotationUtils.findAnnotation((Method)method, Path.class);
        if (path == null) {
            return false;
        }
        return Consistent.DOWNLOAD_PATHS.contains(path.value());
    }
}

