/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.util;

import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.PathUtil;
import java.time.LocalTime;

public class MachineAccountAccessLimiter {
    private static final String MACHINE_ACCOUNT_ACCESS_LIMIT = "machine.account.access.limit";
    private static final int DEFAULT_MACHINE_ACCOUNT_ACCESS_LIMIT = 5000;
    private static final MachineAccountAccessLimiter INSTANCE = new MachineAccountAccessLimiter();
    private int accessCount = 0;
    private int countMinute = -1;

    private MachineAccountAccessLimiter() {
    }

    public static MachineAccountAccessLimiter getInstance() {
        return INSTANCE;
    }

    public synchronized boolean checkAndIncrementAccessCount() {
        this.refreshCountParam();
        int limitValue = LegoBaseConfig.getInstance((String)(PathUtil.getInstallPath() + "/LegoRuntime/conf/lego.properties")).getInt(MACHINE_ACCOUNT_ACCESS_LIMIT, 5000);
        if (this.accessCount >= limitValue) {
            return false;
        }
        ++this.accessCount;
        return true;
    }

    private void refreshCountParam() {
        int currMinute = LocalTime.now().getMinute();
        if (this.countMinute == currMinute) {
            return;
        }
        this.countMinute = currMinute;
        this.accessCount = 0;
    }
}

