/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.util;

import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.util.BaseRestUtils;
import com.huawei.ism.drm.rest.util.OperationLog;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.rest.util.SysOpLogBuilder;
import com.huawei.ism.drm.web.util.RequestUtil;
import com.huawei.ism.drm.web.util.UriUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class OperationLogAspect {
    private static final Log LOGGER = LogFactory.getInstance(OperationLogAspect.class);
    private static final int SUCCESS = 1;
    private static final int FAILURE = 0;
    private static final int MAX_TERMINAL_IP_LENGTH = 255;
    private static final String AFTER_PREFIX = "After Method: ";
    private static final String THROW_PREFIX = "Exception in Method: ";
    private static final String DCS_TOKEN = "DCS_TOKEN";
    private List<String> cloudUris = Arrays.asList("/ws/csha", "/ws/csdr", "/ws/bcs", "/ws/om", "/ws/csr", "/ws/dcs");

    public void before(JoinPoint joinPoint) {
        LOGGER.info((Object)"Before execute method %s", new Object[]{joinPoint.getSignature().getName()});
    }

    public void doAfterReturning(JoinPoint joinPoint) {
        try {
            SysOptLog sysOptLog = this.buildBaseLogInfo(joinPoint).orElse(null);
            if (sysOptLog == null) {
                return;
            }
            if (sysOptLog.getLevel() == 0) {
                sysOptLog.setLevel(1);
            }
            sysOptLog.setResult(1);
            SysOpLogBuilder.writeOperateLog(sysOptLog);
            LOGGER.info((Object)"After execute method %s", new Object[]{joinPoint.getSignature().getName()});
        }
        catch (Exception err) {
            LOGGER.error((Object)"After returning pointcut execute failed, err: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)err)});
        }
    }

    public void doThrowing(JoinPoint joinPoint, Exception ex) {
        try {
            SysOptLog sysOptLog = this.buildBaseLogInfo(joinPoint).orElse(null);
            if (sysOptLog == null) {
                return;
            }
            if (sysOptLog.getLevel() == 0) {
                sysOptLog.setLevel(3);
            }
            sysOptLog.setResult(0);
            if (ex instanceof LegoCheckedException) {
                sysOptLog.setDetail("lego.err." + ((LegoCheckedException)((Object)ex)).getErrorCode());
                sysOptLog.setDetailPara(((LegoCheckedException)((Object)ex)).getParameters());
            } else {
                sysOptLog.setDetail("lego.err.-1");
                sysOptLog.setDetailPara(new String[0]);
            }
            SysOpLogBuilder.writeOperateLog(sysOptLog);
            LOGGER.info((Object)(THROW_PREFIX + joinPoint.getSignature().getName()));
        }
        catch (Exception err) {
            LOGGER.error((Object)"Throwing pointcut execute failed, err: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)err)});
        }
    }

    private Optional<SysOptLog> buildBaseLogInfo(JoinPoint joinPoint) {
        if (!(joinPoint.getSignature() instanceof MethodSignature)) {
            LOGGER.error((Object)"Get method signature failed");
            throw new LegoCheckedException(1073947393L);
        }
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        AbstractRestService restService = (AbstractRestService)joinPoint.getTarget();
        if (BaseRestUtils.isDownloadMethod(method) && !restService.isExportChecked().booleanValue()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.buildSysOptlog(restService, method));
    }

    private SysOptLog buildSysOptlog(AbstractRestService restService, Method method) {
        OperationLog opLog = method.getAnnotation(OperationLog.class);
        SysOptLog.Builder builder = SysOptLog.builder();
        if (opLog != null) {
            HttpServletRequest request = restService.getRequest();
            String tokenUser = VerifyUtil.isEmpty((Object)request.getAttribute("iam-x-auth-user-json")) ? "" : String.valueOf(request.getAttribute("iam-x-auth-user-json"));
            String currentUserName = this.buildUserName(restService, tokenUser);
            builder.operation(opLog.operationName()).operator(currentUserName).module(opLog.operationModule()).detail(opLog.operationDetail()).level(opLog.level()).serviceType(this.getServiceType(request, opLog)).tokenUser(VerifyUtil.isEmpty((String)tokenUser) ? currentUserName : tokenUser).projectId(String.valueOf(request.getAttribute("iam-x-auth-user-project"))).target(VerifyUtil.isEmpty((Object)request.getAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET)) ? "" : String.valueOf(request.getAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET))).targetLocal(Boolean.TRUE.booleanValue()).terminalIp(this.getTerminalIp(restService, builder)).logType(this.getLogType(restService));
            Object operationLogParam = request.getAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM);
            if (!VerifyUtil.isEmpty((Object)operationLogParam) && operationLogParam instanceof String[]) {
                builder.detailPara((String[])operationLogParam);
            }
            if (!VerifyUtil.isEmpty((Object)request.getAttribute(OperationLogAttrDefine.OPERATION_LOG_NAME))) {
                builder.operation(String.valueOf(request.getAttribute(OperationLogAttrDefine.OPERATION_LOG_NAME)));
            }
        }
        return builder.build();
    }

    private String buildUserName(AbstractRestService restService, String tokenUser) {
        String currentUserName;
        HttpServletRequest request = restService.getRequest();
        if (!VerifyUtil.isEmpty((Object)request.getAttribute(DCS_TOKEN))) {
            JSONObject dcsToken = JSONObject.fromObject((Object)request.getAttribute(DCS_TOKEN));
            JSONObject userJson = JSONObject.fromObject((Object)dcsToken.get("user"));
            currentUserName = String.valueOf(userJson.get("name"));
        } else {
            JSONObject jsonObject = JSONObject.fromObject((Object)tokenUser);
            if (!VerifyUtil.isEmpty((Map)jsonObject)) {
                currentUserName = jsonObject.getString("name");
            } else if (!VerifyUtil.isEmpty((Object)request.getAttribute(OperationLogAttrDefine.OPERATION_LOG_USER_NAME))) {
                currentUserName = String.valueOf(request.getAttribute(OperationLogAttrDefine.OPERATION_LOG_USER_NAME));
            } else {
                currentUserName = "NoLoginUser";
                try {
                    currentUserName = restService.getCurrentUser().getUserName();
                }
                catch (LegoCheckedException e) {
                    LOGGER.info((Object)"User did not login.");
                }
            }
        }
        return currentUserName;
    }

    private String getServiceType(HttpServletRequest request, OperationLog opLog) {
        return Optional.ofNullable(request).map(req -> Optional.ofNullable(req.getAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE)).map(String::valueOf).orElse(req.getHeader("servicetype"))).orElse(opLog.drType());
    }

    private String getLogType(AbstractRestService restService) {
        String uri = this.getRequestUri(restService);
        if (this.isCloudRestService(uri)) {
            return "tenantlog";
        }
        return "administratorlog";
    }

    private String getTerminalIp(AbstractRestService restService, SysOptLog.Builder builder) {
        String remoteAddr = AbstractRestService.getRemoteAddr(restService.getRequest());
        String terminalIp = this.isCloudRestService(this.getRequestUri(restService)) ? RequestUtil.getFirstIPFromIPStr(remoteAddr) : RequestUtil.getLastIPFromIPStr(remoteAddr);
        if (terminalIp.length() > 255) {
            LOGGER.error((Object)"Failed to getTerminalIp, cause terminalIp exceed the limit,operator:%s,operation:%s,target:%s,date:%s,terminalIp:%s", new Object[]{builder.getOperator(), builder.getOperation(), builder.getTarget(), builder.getDate(), terminalIp});
            return terminalIp.substring(0, 255);
        }
        return terminalIp;
    }

    private String getRequestUri(AbstractRestService restService) {
        String uri = restService.getRequest().getRequestURI();
        return UriUtil.canonicalPath(uri);
    }

    private boolean isCloudRestService(String uri) {
        for (String subUri : this.cloudUris) {
            if (!uri.startsWith(subUri)) continue;
            return true;
        }
        return false;
    }
}

