/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.util;

import com.huawei.ism.drm.wcc.util.utils.SysPropertiesUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.lang.reflect.Method;
import java.text.Normalizer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.compress.utils.Sets;
import org.aspectj.lang.JoinPoint;

public class ParamValidatorAspect {
    private static final Log LOGGER = LogFactory.getInstance(ParamValidatorAspect.class);
    private static final String PARAM_VALIDATOR_IGNORE_FILED_KEY = "param.validator.ignore.field";
    private static final String CHECK_PACKAGE = "com.huawei";
    private static final int MAX_RECURSION_DEPTH = 10;
    private final Pattern stringCheckPattern = Pattern.compile("[|;&$><`!\\\\\\n]");
    private Set<String> ignoreFields = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"des", "description", "roleDes", "pwd", "password", "userPassword", "oldPassword", "newPassword", "confirmPassword", "adminPassword", "userNewPassword", "userConfirmPassword", "networkPassword", "dataPassword", "ftpPassword"}));
    private long configUpdateTime = 0L;

    public void before(JoinPoint point) throws LegoCheckedException {
        Object[] args;
        this.reloadProperties();
        for (Object arg : args = point.getArgs()) {
            this.checkParam(arg, 0);
        }
    }

    private void reloadProperties() {
        if (this.configUpdateTime >= SysPropertiesUtils.getLegoConfigUpdateTime()) {
            return;
        }
        String newIgnoreFields = SysPropertiesUtils.getPropertyValue((String)PARAM_VALIDATOR_IGNORE_FILED_KEY);
        if (!VerifyUtil.isEmpty((String)newIgnoreFields)) {
            LOGGER.info((Object)"Key ignoreFiled of legoConfig read success.");
            this.ignoreFields = Collections.unmodifiableSet(Sets.newHashSet((Object[])newIgnoreFields.split(",")));
        }
        this.configUpdateTime = SysPropertiesUtils.getLegoConfigUpdateTime();
    }

    private void checkParam(Object param, int depth) throws LegoCheckedException {
        if (++depth > 10) {
            LOGGER.error((Object)"Recursion depth exceeded the threshold.");
            throw new LegoCheckedException(1073947393L);
        }
        if (param == null || param instanceof Number) {
            return;
        }
        if (param instanceof String) {
            String paramStr = Normalizer.normalize((String)param, Normalizer.Form.NFKC);
            if (this.stringCheckPattern.matcher(paramStr).find()) {
                LOGGER.error((Object)"Invalid characters exist.");
                throw new LegoCheckedException(1073947393L);
            }
            return;
        }
        if (param instanceof Collection) {
            Collection params = (Collection)param;
            for (Object entity : params) {
                this.checkParam(entity, depth);
            }
            return;
        }
        if (param instanceof Map) {
            Set entries = ((Map)param).entrySet();
            for (Map.Entry entry : entries) {
                if (this.shouldIgnore(entry)) continue;
                this.checkParam(entry.getKey(), depth);
                this.checkParam(entry.getValue(), depth);
            }
            return;
        }
        if (param.getClass().isArray()) {
            Object[] paramArray;
            for (Object entity : paramArray = (Object[])param) {
                this.checkParam(entity, depth);
            }
            return;
        }
        if (!param.getClass().getPackage().getName().startsWith(CHECK_PACKAGE)) {
            return;
        }
        this.checkObject(param, depth);
    }

    private void checkObject(Object param, int depth) throws LegoCheckedException {
        Method[] methods;
        for (Method method : methods = param.getClass().getMethods()) {
            String methodName = method.getName();
            this.checkFiled(param, depth, method, methodName);
        }
    }

    private void checkFiled(Object param, int depth, Method method, String methodName) throws LegoCheckedException {
        if (methodName.startsWith("get") && method.getParameterCount() == 0 && !methodName.equals("getClass")) {
            Object fieldValue;
            try {
                if (this.shouldIgnore(methodName)) {
                    return;
                }
                fieldValue = method.invoke(param, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Failed to parse attributes. Reason: %s", (Throwable)e);
                return;
            }
            this.checkParam(fieldValue, depth);
        }
    }

    private boolean shouldIgnore(String methodName) {
        String filedName = methodName.substring(3);
        return this.ignoreFields.stream().anyMatch(ignoreField -> ignoreField.equalsIgnoreCase(filedName));
    }

    private boolean shouldIgnore(Map.Entry<?, ?> entry) {
        Object key = entry.getKey();
        if (!(key instanceof String)) {
            return false;
        }
        return this.ignoreFields.stream().anyMatch(ignoreField -> ignoreField.equalsIgnoreCase((String)key));
    }
}

