/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.filter;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.web.util.UriUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CSRFRequestFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(CSRFRequestFilter.class);
    private static final int URI_INDEX = 1;
    private static final int METHOD_INDEX = 0;
    private static final Set<String> HAS_SESSION_SKIP_URL = ImmutableSet.of((Object)"/ws/license/action/import", (Object)"/ws/fusionsphere/action/importnetworkadapters");
    private static String contentSecurityPolicy = "connect-src 'self';object-src 'self';frame-src 'self';media-src 'self';font-src 'self'";
    private static final String X_AUTH_TOKEN = "X-Auth-Token";
    private boolean antiCSRF = false;
    private Map<String, String> noFilterMap = new HashMap<String, String>();

    public void destroy() {
        this.noFilterMap.clear();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String currentUri = UriUtil.getNormalizeRequestServletUri(req);
        if (!currentUri.startsWith("/ws/") || currentUri.startsWith("/ws/dcs/")) {
            chain.doFilter(request, response);
        } else {
            this.filterByToken(req, res, chain);
        }
    }

    private void filterByToken(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (VerifyUtil.isEmpty((Map)req.getParameterMap())) {
            LOGGER.debug((Object)"ParameterMap is empty");
        }
        String clientToken = req.getHeader("rd_randomStr_HW");
        res.setHeader("Content-Security-Policy", contentSecurityPolicy);
        res.setHeader("Content-Security-Policy-Report-Only", "''");
        String currentUri = UriUtil.getNormalizeRequestServletUri(req);
        if (this.antiCSRF && !this.isWhiteUri(currentUri, req.getMethod()) && req.getSession(false) != null) {
            String randomStr = (String)req.getSession().getAttribute("rd_randomStr_HW");
            res.setHeader("Pragma", "no-cache");
            res.setHeader("Cache", "no-cache");
            res.setHeader("Expires", "0");
            res.setHeader("Cache-Control", "no-store, must-revalidate");
            if (HAS_SESSION_SKIP_URL.contains(currentUri)) {
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
                return;
            }
            if (StringUtils.isEmpty((CharSequence)randomStr)) {
                LOGGER.error((Object)"the random str is null.");
                res.setStatus(403);
                res.sendError(403);
                return;
            }
            if (randomStr.equals(clientToken)) {
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
            } else {
                LOGGER.error((Object)"The clientToken is not same as randomStr");
                res.setStatus(403);
                res.sendError(403);
            }
        } else {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        if (null == config) {
            LOGGER.error((Object)"Invalid parameter");
            return;
        }
        String antiC = config.getInitParameter("AntiCSRF");
        if (StringUtils.isEmpty((CharSequence)antiC)) {
            this.antiCSRF = false;
        }
        this.antiCSRF = Boolean.valueOf(antiC);
        String whiteUri = config.getInitParameter("whiteUri");
        if (null == whiteUri || whiteUri.isEmpty()) {
            return;
        }
        for (String param : whiteUri.split(",")) {
            String[] methodAndUri = param.split(":");
            if (methodAndUri == null || methodAndUri.length < 2) continue;
            this.noFilterMap.put(methodAndUri[1].trim(), methodAndUri[0].trim());
        }
    }

    private boolean isWhiteUri(String uri, String method) {
        if (StringUtils.isEmpty((CharSequence)uri)) {
            return true;
        }
        if (this.noFilterMap.get(uri) == null) {
            return false;
        }
        return method.equalsIgnoreCase(this.noFilterMap.get(uri));
    }
}

