/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.service.logging;

import com.huawei.ism.drm.rest.util.BaseRestUtils;
import com.huawei.ism.drm.rest.util.SysOpLogBuilder;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.service.logging.LoggingParams;
import com.huawei.ism.drm.web.service.logging.LoggingService;
import com.huawei.ism.drm.web.service.session.SessionService;
import com.huawei.ism.drm.web.util.RequestUtil;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import com.huawei.moment.bedstone.shield.framework.util.Evaluation;
import com.huawei.moment.bedstone.shield.framework.util.ProceedingJoinPointUtil;
import com.huawei.moment.bedstone.shield.service.journal.JournalService;
import com.huawei.moment.bedstone.shield.service.journal.JournalStatus;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class DefaultLoggingService
implements JournalService,
LoggingService {
    private static final transient Log LOGGER = LogFactory.getInstance(DefaultLoggingService.class);
    private static final String NAME = "name";
    private static final String RANK = "rank";
    private static final String OBJECT = "object";
    private static final String DETAIL = "detail";
    private static final String PARAMETERS = "parameters";
    private static final String SERVICE = "service";
    private static final String LOGGING = "logging";
    private static final String RESULT = "result";
    private static final String METHOD = "METHOD";
    private static final String RETURN = "$return";
    private static final int SECTION = 100;
    private static final int SUCCESSFUL = 2;
    private static final String IS_EXPORT_PRE_CHECK = "is_export_pre_check";
    private final ApplicationContext applicationContext;
    private final SessionService sessionService;

    public DefaultLoggingService(ApplicationContext applicationContext, SessionService sessionService) {
        this.applicationContext = applicationContext;
        this.sessionService = sessionService;
    }

    public Map<String, Evaluation> load(ProceedingJoinPoint joinPoint) {
        Optional optional = ProceedingJoinPointUtil.getMergedAnnotation((ProceedingJoinPoint)joinPoint, Logging.class);
        if (!optional.isPresent()) {
            return Collections.emptyMap();
        }
        User user = this.sessionService.getCurrentUser();
        if (user == null) {
            return Collections.emptyMap();
        }
        Logging logging = (Logging)optional.get();
        HashMap<String, Evaluation> map = new HashMap<String, Evaluation>();
        map.put(NAME, new Evaluation(this.applicationContext, logging.name(), true));
        map.put(RANK, new Evaluation((Object)logging.rank()));
        map.put(OBJECT, new Evaluation(this.applicationContext, logging.object()));
        map.put(DETAIL, new Evaluation(this.applicationContext, logging.detail(), true));
        map.put(PARAMETERS, this.buildParametersEvaluation(logging));
        map.put(SERVICE, new Evaluation((Object)logging.service()));
        map.put(LOGGING, new Evaluation((Object)logging));
        map.put(RESULT, this.buildResultEvaluation());
        map.put(METHOD, new Evaluation((Object)joinPoint.getSignature()));
        return map;
    }

    private Evaluation buildParametersEvaluation(Logging logging) {
        return new Evaluation(Stream.of(logging.parameters()).map(this::buildParameterEvaluation).collect(Collectors.toList()));
    }

    private Evaluation buildParameterEvaluation(String expression) {
        return new Evaluation(this.applicationContext, expression, false);
    }

    private Evaluation buildResultEvaluation() {
        return new Evaluation(this.applicationContext, RETURN, false);
    }

    public void process(Map<String, Object> data, JournalStatus status, Throwable throwable) {
        if (status == JournalStatus.INITIAL) {
            return;
        }
        String object = this.getValue(data, OBJECT, String.class).orElse(null);
        String detail = this.getValue(data, DETAIL, String.class).orElse(null);
        String[] parameters = (String[])this.getList(data).stream().map(this::stringify).toArray(String[]::new);
        MethodSignature methodSignature = this.getValue(data, METHOD, MethodSignature.class).orElseThrow(() -> new LegoCheckedException("Get method signature failed.").log(LOGGER));
        Logging logging = Objects.requireNonNull(this.getValue(data, LOGGING, Logging.class).orElse(null));
        if (BaseRestUtils.isDownloadMethod(methodSignature.getMethod()) && this.isPreCheck()) {
            return;
        }
        if (logging.mask()) {
            object = SecurityUtil.tryMask((String)object);
        }
        int rank = this.getValue(data, RANK, Integer.class).orElse(1);
        String name = this.getValue(data, NAME, String.class).orElse(null);
        String service = this.getValue(data, SERVICE, String.class).orElse(null);
        LoggingParams params = new LoggingParams(name, rank, object, service);
        if (status == JournalStatus.FAILURE) {
            this.recordFailedOperationLog(logging, params, throwable);
            return;
        }
        Object result = data.get(RESULT);
        if (result instanceof BatchOperationResult) {
            BatchOperationResult batchOperationResult = (BatchOperationResult)result;
            this.batchOptLog(batchOperationResult, name, rank, service, logging);
        } else if (result instanceof Response) {
            this.recordOperationLogForResponse(detail, parameters, logging, params, (Response)result);
        } else {
            this.writeSucOperationLog(params, detail, parameters, logging);
        }
    }

    private void recordOperationLogForResponse(String detail, String[] parameters, Logging logging, LoggingParams params, Response response) {
        int family = response.getStatus() / 100;
        if (family != 2) {
            this.recordFailedOperationLog(logging, params, null);
        } else {
            this.writeSucOperationLog(params, detail, parameters, logging);
        }
    }

    private boolean isPreCheck() {
        HttpServletRequest request = this.sessionService.getHttpServletRequest();
        return Boolean.TRUE.equals(request.getAttribute(IS_EXPORT_PRE_CHECK));
    }

    private String stringify(Object object) {
        return Optional.ofNullable(object).map(String::valueOf).orElse("--");
    }

    private void recordFailedOperationLog(Logging logging, LoggingParams params, Throwable throwable) {
        if (logging.quiet()) {
            this.writeFailedOperationLogNoException(params, throwable);
        } else {
            this.writeFailedOperationLog(params, throwable);
        }
    }

    private List<?> getList(Map<String, Object> data) {
        return this.getValue(data, PARAMETERS, List.class).orElse(Collections.emptyList());
    }

    private <T> Optional<T> getValue(Map<String, Object> data, String key, Class<T> type) {
        Object value = data.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (type.isInstance(value)) {
            return Optional.of(type.cast(value));
        }
        return Optional.empty();
    }

    @Override
    public void writeSucOperationLog(LoggingParams params, String detail, String[] parameters) {
        this.writeSucOperationLog(params, detail, parameters, null);
    }

    private void writeSucOperationLog(LoggingParams params, String detail, String[] parameters, Logging logging) {
        if (logging != null && logging.ward()) {
            return;
        }
        String operationName = params.getOperationName();
        int level = params.getLevel();
        String objectName = params.getObjectName();
        String serviceType = params.getServiceType();
        User user = this.sessionService.getCurrentUser();
        String address = this.getRemoteAddress();
        SysOptLog sysOptLog = SysOpLogBuilder.buildeSuccussSysOptLog(operationName, user.getUserName(), level, detail, objectName, address);
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] != null && parameters[i].trim().length() != 0) continue;
                parameters[i] = "--";
            }
        }
        this.initLog(sysOptLog, parameters, serviceType);
        SysOpLogBuilder.writeOperateLog(sysOptLog);
    }

    private String getRemoteAddress() {
        HttpServletRequest request = this.sessionService.getHttpServletRequest();
        return RequestUtil.getClientIpAddress(request);
    }

    private void initLog(SysOptLog sysOptLog, String[] params, String serviceType) {
        sysOptLog.setDetailPara(params);
        sysOptLog.setLogType("administratorlog");
        sysOptLog.setTokenUser(this.getUserJson());
        sysOptLog.setServiceType(serviceType);
    }

    protected String getUserJson() {
        return this.getCurrentUserName();
    }

    private String getCurrentUserName() {
        return this.sessionService.getCurrentUser().getUserName();
    }

    @Override
    public void writeFailedOperationLog(LoggingParams params, Throwable ix) {
        this.writeFailedOperationLog(params, ix, exception -> {
            throw exception;
        });
    }

    @Override
    public void writeFailedOperationLogNoException(LoggingParams params, Throwable ix) {
        this.writeFailedOperationLog(params, ix, null);
    }

    private void writeFailedOperationLog(LoggingParams params, Throwable ix, Consumer<RuntimeException> consumer) {
        String operationName = params.getOperationName();
        int level = params.getLevel();
        String objectName = params.getObjectName();
        String serviceType = params.getServiceType();
        String address = this.getRemoteAddress();
        LegoCheckedException ex = ix instanceof IllegalArgumentException ? new LegoCheckedException(1073947393L, ix.getMessage(), ix) : (ix instanceof LegoCheckedException ? (LegoCheckedException)ix : new LegoCheckedException(-1L, ix));
        String message = ExceptionUtil.getErrorMessage((Throwable)ex);
        LOGGER.error((Object)"Operating failed. OptName: %s, errMsg=%s", new Object[]{operationName, message});
        SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUserName(), level, "lego.err." + ex.getErrorCode(), objectName, address);
        this.initLog(sysOptLog, ex.getParameters(), serviceType);
        SysOpLogBuilder.writeOperateLog(sysOptLog);
        if (consumer != null) {
            consumer.accept((RuntimeException)ex);
        }
    }

    @Override
    public void batchOptLog(BatchOperationResult batchOperationResult, String operateName, int level, String serviceType) {
        this.batchOptLog(batchOperationResult, operateName, level, serviceType, null);
    }

    private void batchOptLog(BatchOperationResult batchOperationResult, String operateName, int level, String serviceType, Logging logging) {
        if (batchOperationResult == null) {
            return;
        }
        for (BatchOperation result : batchOperationResult.getResult()) {
            String name = "backendTask_delete_operateName".equals(operateName) ? result.getTaskName() : (result.getTargetName() != null ? result.getTargetName() : (String)Optional.ofNullable(result.getExtTargetId()).map(Object::toString).orElse(null));
            LoggingParams params = new LoggingParams(operateName, level, name, serviceType);
            if (result.getErrorCode() != 0L) {
                LegoCheckedException exception = new LegoCheckedException(result.getErrorCode(), result.getDetailParam());
                this.writeFailedOperationLogNoException(params, (Throwable)exception);
                continue;
            }
            if (logging != null && logging.ward()) continue;
            this.writeSucOperationLog(params, null, null);
        }
    }
}

