/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;

public class ClassLoaderUtil {
    private static final Logger LOGGER = Logger.getLogger((String)ClassLoaderUtil.class.getName());

    public static Iterator<URL> getResources(String resourceName, Class callingClass, boolean aggregate) throws IOException {
        ClassLoader cl;
        ClassLoader classLoader;
        AggregateIterator<URL> iterator = new AggregateIterator<URL>();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            iterator.addEnumeration(contextClassLoader.getResources(resourceName));
        }
        if ((!iterator.hasNext() || aggregate) && (classLoader = ClassLoaderUtil.class.getClassLoader()) != null) {
            iterator.addEnumeration(classLoader.getResources(resourceName));
        }
        if ((!iterator.hasNext() || aggregate) && (cl = callingClass.getClassLoader()) != null) {
            iterator.addEnumeration(cl.getResources(resourceName));
        }
        if (!iterator.hasNext() && ClassLoaderUtil.verifyResourceName(resourceName)) {
            return ClassLoaderUtil.getResources('/' + resourceName, callingClass, aggregate);
        }
        return iterator;
    }

    public static URL getResource(String resourceName, Class callingClass) {
        ClassLoader cl;
        ClassLoader classLoader;
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null && (classLoader = ClassLoaderUtil.class.getClassLoader()) != null) {
            url = classLoader.getResource(resourceName);
        }
        if (url == null && (cl = callingClass.getClassLoader()) != null) {
            url = cl.getResource(resourceName);
        }
        if (url == null && ClassLoaderUtil.verifyResourceName(resourceName)) {
            return ClassLoaderUtil.getResource('/' + resourceName, callingClass);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String resourceName, Class callingClass) {
        URL url = ClassLoaderUtil.getResource(resourceName, callingClass);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            LOGGER.error((Object)"Cannot get stream for resource");
            return null;
        }
    }

    public static Class loadClass(String clName, Class callingClass) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(clName);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(clName);
            }
            catch (ClassNotFoundException ex) {
                ClassLoader cl = ClassLoaderUtil.class.getClassLoader();
                try {
                    if (cl != null) {
                        return cl.loadClass(clName);
                    }
                }
                catch (ClassNotFoundException exc) {
                    LOGGER.error((Object)String.format(Locale.ROOT, "Cannot find class : %s.", clName));
                }
                if (callingClass == null) {
                    return null;
                }
                ClassLoader cl2 = callingClass.getClassLoader();
                if (cl2 != null) {
                    return cl2.loadClass(clName);
                }
                return null;
            }
        }
    }

    private static boolean verifyResourceName(String resourceName) {
        return resourceName != null && (resourceName.length() == 0 || resourceName.charAt(0) != '/');
    }

    static class AggregateIterator<E>
    implements Iterator<E> {
        private List<Enumeration<E>> enums = new LinkedList<Enumeration<E>>();
        private Enumeration<E> cur = null;
        private E nextNode = null;
        private Set<E> loaded = new HashSet();

        AggregateIterator() {
        }

        public AggregateIterator<E> addEnumeration(Enumeration<E> enumeration) {
            if (enumeration.hasMoreElements()) {
                if (this.cur == null) {
                    this.cur = enumeration;
                    this.nextNode = enumeration.nextElement();
                    this.loaded.add(this.nextNode);
                } else {
                    this.enums.add(enumeration);
                }
            }
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public E next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            E prev = this.nextNode;
            this.nextNode = this.loadNext().orElse(null);
            return prev;
        }

        private Optional<E> loadNext() {
            if (this.cur == null || this.cur.hasMoreElements()) {
                return Optional.empty();
            }
            if (this.enums.isEmpty()) {
                this.cur = null;
            } else {
                Object obj = ((LinkedList)this.enums).removeLast();
                if (obj instanceof Enumeration) {
                    this.cur = (Enumeration)obj;
                }
            }
            if (this.cur != null) {
                E tmp = this.cur.nextElement();
                int loadedSize = this.loaded.size();
                while (this.loaded.contains(tmp) && (tmp = this.loadNext().orElse(null)) != null && this.loaded.size() <= loadedSize) {
                }
                if (tmp != null) {
                    this.loaded.add(tmp);
                }
                return Optional.ofNullable(tmp);
            }
            return Optional.empty();
        }
    }
}

