/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.lego.core.sdk.util.CommonUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CustomPathUtil {
    private static final Log LOGGER = LogFactory.getLog(CustomPathUtil.class);
    private static Map<String, Properties> props = new HashMap<String, Properties>();

    private CustomPathUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void readConfig(String filename) {
        try {
            ClassLoader classLoader = CustomPathUtil.class.getClassLoader();
            if (classLoader == null) {
                LOGGER.error((Object)"cannot get the path! because classLoader is null");
                return;
            }
            Enumeration<URL> urls = classLoader.getResources(filename);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStream openStream = null;
                try {
                    Properties prop = new Properties();
                    openStream = url.openStream();
                    prop.load(openStream);
                    props.put("lego-config", prop);
                }
                catch (IOException e) {
                    try {
                        LOGGER.error((Object)"cannot get the path!");
                    }
                    catch (Throwable throwable) {
                        CommonUtil.close(openStream);
                        throw throwable;
                        return;
                    }
                    CommonUtil.close((Closeable)openStream);
                    continue;
                }
                CommonUtil.close((Closeable)openStream);
            }
        }
        catch (IOException e1) {
            LOGGER.error((Object)"cannot get the path!");
        }
    }

    public static String getConfig(String moduleName, String key) {
        Properties prop = props.get(moduleName);
        if (prop == null) {
            return null;
        }
        return prop.getProperty(key);
    }
}

