/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.user.service.model.UserConstant;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class FileUtil {
    public static final String FILETYPE_EXCEL = "xlsx";
    public static final String FILETYPE_ZIP = "zip";
    private static final Log LOGGER = FELogFactory.getInstance((String)"ui");
    private AbstractRestService abstractRestService;
    private List<List<String>> formatDataList;
    private String title;
    private List<String> colTitle;
    private String writeFileName;
    private String strExtend;
    private String strUsrName;
    private String strChar = "UTF-8";
    private String downFileName = "ExportResult";
    private Object dataList;

    public abstract void writeFile(FileOutputStream var1) throws IOException;

    public void fileSet(String strTitle, List<String> lstColTitle, String strWriteFileName, Object datas, List<List<String>> formatDatas, AbstractRestService restService) {
        this.setTitle(strTitle);
        this.setColTitle(lstColTitle);
        this.setWriteFileName(strWriteFileName);
        this.dataList = datas;
        this.formatDataList = formatDatas;
        this.abstractRestService = restService;
    }

    public static String createFilePath(HttpServletRequest request, String filePrefix, String suffix) {
        boolean ret;
        if (request == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String exportExcelName = filePrefix + df.format(new Date()) + "_" + UUIDGenerator.getUUID() + "." + suffix;
        String downloadPath = request.getSession().getServletContext().getRealPath("") + File.separator + UserConstant.FILEPATH_EXPORT_DIR;
        File file = new File(downloadPath);
        if (!file.exists() && !(ret = file.mkdir())) {
            int errorCode = 1077951770;
            throw new LegoCheckedException(1077951770L);
        }
        downloadPath = downloadPath + File.separator + exportExcelName;
        return downloadPath;
    }

    public void downloadNameFile(HttpServletResponse response, String fileName) {
        this.setDownFileName(fileName);
        this.downloadFile(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(HttpServletResponse response) {
        File delFile;
        String downloadFileName;
        FileOutputStream outputStream;
        block10: {
            outputStream = null;
            downloadFileName = this.getWriteFileName();
            delFile = new File(downloadFileName);
            if (this.getWriteFileName() != null) break block10;
            CommonUtil.close(outputStream);
            return;
        }
        try {
            outputStream = new FileOutputStream(this.getWriteFileName());
            this.writeFile(outputStream);
        }
        catch (Exception e) {
            try {
                FileUtil.deleteFile(delFile);
                ExceptionUtil.rethrowException((Exception)e, (String)"downloadFileerror", (long)-1L, null);
            }
            catch (Throwable throwable) {
                CommonUtil.close(outputStream);
                throw throwable;
            }
            CommonUtil.close((Closeable)outputStream);
        }
        CommonUtil.close((Closeable)outputStream);
        String displayName = downloadFileName.substring(downloadFileName.lastIndexOf(File.separator) + 1, downloadFileName.length());
        this.setResponse(response, displayName);
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        FileInputStream fileInput = null;
        try {
            int bytesRead;
            fileInput = new FileInputStream(downloadFileName);
            bis = new BufferedInputStream(fileInput);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[bis.available()];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
        }
        catch (IOException e) {
            try {
                ExceptionUtil.rethrowException((Throwable)e, (String)"downloadFileerror", (long)-1L, null, (Log)LOGGER);
            }
            catch (Throwable throwable) {
                CommonUtil.close(fileInput);
                CommonUtil.close(bis);
                CommonUtil.close(bos);
                FileUtil.deleteFile(delFile);
                throw throwable;
            }
            CommonUtil.close((Closeable)fileInput);
            CommonUtil.close((Closeable)bis);
            CommonUtil.close(bos);
            FileUtil.deleteFile(delFile);
        }
        CommonUtil.close((Closeable)fileInput);
        CommonUtil.close((Closeable)bis);
        CommonUtil.close((Closeable)bos);
        FileUtil.deleteFile(delFile);
    }

    private void setResponse(HttpServletResponse response, String displayName) {
        response.setContentType("application/x-download");
        response.setCharacterEncoding("windows-1251");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-store, must-revalidate");
        response.addHeader("Content-Disposition", "attachment;filename=" + displayName);
    }

    public static void deleteFile(File file) {
        if (file != null && file.exists()) {
            if (file.isFile()) {
                Boolean result = file.delete();
                if (!result.booleanValue()) {
                    LOGGER.error((Object)"delete file error", 653110170615808L);
                }
            } else if (file.isDirectory()) {
                Boolean result;
                File[] files = file.listFiles();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        FileUtil.deleteFile(files[i]);
                    }
                }
                if (!(result = Boolean.valueOf(file.delete())).booleanValue()) {
                    LOGGER.error((Object)"delete file error", 653110170615808L);
                }
            }
        } else {
            LOGGER.error((Object)"file is not exist", 653110170615808L);
        }
    }

    public static String getNowTime() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(date);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getColTitle() {
        if (this.colTitle == null) {
            this.colTitle = this.getColumnTitle();
        }
        return this.colTitle;
    }

    protected List<String> getColumnTitle() {
        return null;
    }

    public void setColTitle(List<String> colTitle) {
        this.colTitle = colTitle;
    }

    public String getWriteFileName() {
        return this.writeFileName;
    }

    public void setWriteFileName(String writeFileName) {
        this.writeFileName = writeFileName;
    }

    public String getStrExtend() {
        return this.strExtend;
    }

    public void setStrExtend(String strExtend) {
        this.strExtend = strExtend;
    }

    public String getStrUsrName() {
        return this.strUsrName;
    }

    public void setStrUsrName(String strUsrName) {
        this.strUsrName = strUsrName;
    }

    public String getStrChar() {
        return this.strChar;
    }

    public void setStrChar(String strChar) {
        this.strChar = strChar;
    }

    public String getDownFileName() {
        return this.downFileName;
    }

    public void setDownFileName(String downFileName) {
        this.downFileName = downFileName;
    }

    public Object getDataList() {
        return this.dataList;
    }

    public void setDataList(Object dataList) {
        this.dataList = dataList;
    }

    protected List<List<String>> getFormatDataList() {
        return this.formatDataList;
    }

    protected void setFormatDataList(List<List<String>> formatDataList) {
        this.formatDataList = formatDataList;
    }

    public AbstractRestService getAbstractRestService() {
        return this.abstractRestService;
    }

    public void setAbstractRestService(AbstractRestService abstractRestService) {
        this.abstractRestService = abstractRestService;
    }
}

