/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service.roleservice;

import com.huawei.lego.cbb.user.dao.IRoleDao;
import com.huawei.lego.cbb.user.sdk.constant.AccountTypeEnum;
import com.huawei.lego.cbb.user.sdk.hibernate.model.OperationInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.RoleInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.huawei.lego.cbb.user.sdk.model.Role;
import com.huawei.lego.cbb.user.service.common.ObjectConvertor;
import com.huawei.lego.cbb.user.service.roleservice.IRoleService;
import com.huawei.lego.core.base.persistance.dao.ICommonDao;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.comm.SortUnit;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.query.Query;

public class RoleService
implements IRoleService {
    private static final Log LOG = LogFactory.getInstance(RoleService.class);
    private IRoleDao roleDao;
    private ICommonDao commDao;

    @Override
    public synchronized int addRoleInfo(Role orole, List<Long> mapOpts) {
        this.roleDao.checkRoleNameSingle(orole.getRoleName());
        RoleInfo tmpRoleInfo = ObjectConvertor.translatePoRole(orole);
        HashSet<OperationInfo> operationSet = new HashSet<OperationInfo>();
        for (Long mapOpt : mapOpts) {
            operationSet.add(new OperationInfo(mapOpt));
        }
        tmpRoleInfo.setOperationSet(operationSet);
        this.roleDao.addRoleInfo(tmpRoleInfo);
        return 0;
    }

    @Override
    public synchronized void deleteRole(long roleId) {
        this.roleDao.deleteRole(roleId);
    }

    @Override
    public synchronized BatchOperationResult batchDelRoles(List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (list != null) {
            operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.roleDao.deleteRole(batchOperation.getTargetId());
                }
                catch (LegoCheckedException e) {
                    ++fail;
                    batchOperation.setDetailParam(e.getParameters());
                    batchOperation.setErrorCode(e.getErrorCode());
                }
                catch (LegoUncheckedException e) {
                    ++fail;
                    batchOperation.setErrorCode(e.getErrorCode());
                }
                catch (Exception e) {
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        }
        return result;
    }

    @Override
    public synchronized Role getRoleInf(long iroleId) {
        RoleInfo roleInfo = new RoleInfo();
        HashSet tmpOptInfo = new HashSet();
        roleInfo.setOperationSet(tmpOptInfo);
        roleInfo = this.roleDao.getRoleById(iroleId, true);
        Role orole = ObjectConvertor.translateBoRoleInfo(roleInfo, true);
        HashSet<Long> optIdsSet = new HashSet<Long>();
        Set optSet = roleInfo.getOperationSet();
        if (optSet != null && !optSet.isEmpty()) {
            for (OperationInfo opt : optSet) {
                optIdsSet.add(opt.getOpId());
            }
        }
        orole.setOptIdsSet(optIdsSet);
        return orole;
    }

    @Override
    public synchronized Role getRoleInf(String roleName) {
        RoleInfo roleInfo = this.roleDao.getRoleByName(roleName, true);
        Role orole = ObjectConvertor.translateBoRoleInfo(roleInfo, true);
        HashSet<Long> optIdsSet = new HashSet<Long>();
        Set optSet = roleInfo.getOperationSet();
        if (optSet != null && !optSet.isEmpty()) {
            for (OperationInfo opt : optSet) {
                optIdsSet.add(opt.getOpId());
            }
        }
        orole.setOptIdsSet(optIdsSet);
        return orole;
    }

    @Override
    public RoleInfo getRole(long iroleId) {
        return this.roleDao.getRoleById(iroleId, true);
    }

    @Override
    public Role getRoleInfRelUser(long iroleId, boolean isFetchUser) {
        Role orole = new Role();
        RoleInfo roleInfo = this.roleDao.getRoleById(iroleId, true);
        try {
            roleInfo = this.roleDao.getRoleInfRelUser(iroleId, isFetchUser);
        }
        catch (Exception e) {
            LOG.info((Object)"the roleInfo  is empty!");
        }
        if (roleInfo.getUserSet() != null && !roleInfo.getUserSet().isEmpty()) {
            for (UserInfo userInfo : roleInfo.getUserSet()) {
                orole.getUserSet().add(ObjectConvertor.getUser(userInfo, false, false));
            }
        }
        return orole;
    }

    @Override
    public int updataRole(Role orole, List<Long> mapOpts) {
        RoleInfo tmpRoleInfo = this.roleDao.getRoleById(orole.getRoleId(), true);
        tmpRoleInfo.setOperationSet(new HashSet());
        RoleInfo tmpRoleInfoFromPo = ObjectConvertor.translatePoRole(orole);
        tmpRoleInfo.setCreatorId(tmpRoleInfoFromPo.getCreatorId());
        tmpRoleInfo.setCreatTime(tmpRoleInfoFromPo.getCreatTime());
        tmpRoleInfo.setRoleDescription(tmpRoleInfoFromPo.getRoleDescription());
        tmpRoleInfo.setRoleName(tmpRoleInfoFromPo.getRoleName());
        HashSet<OperationInfo> operationSet = new HashSet<OperationInfo>();
        for (Long opt : mapOpts) {
            operationSet.add(new OperationInfo(opt));
        }
        tmpRoleInfo.setOperationSet(operationSet);
        this.roleDao.updataRole(tmpRoleInfo);
        return 0;
    }

    @Override
    public List<Role> getAllRoles(boolean isFetchRole) {
        ArrayList<Role> lstRole = new ArrayList<Role>();
        List<RoleInfo> lstSingleRoleInfo = this.roleDao.getAllRoles(false);
        String countHql = "select count(*) from UserIdAndRoleId as ur where ur.id.roleId = ?";
        int icount = 0;
        for (RoleInfo tmpRoleInfo : lstSingleRoleInfo) {
            Role tmpRole = ObjectConvertor.translateBoRoleInfo(tmpRoleInfo, false);
            try {
                icount = Integer.parseInt(String.valueOf(this.commDao.getBaseHibernateTemplate().find(countHql, (Object[])new Long[]{tmpRoleInfo.getRoleIdx()}).listIterator().next()));
                tmpRole.setUserNum(icount);
            }
            catch (Exception e) {
                LOG.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
            }
            lstRole.add(tmpRole);
        }
        return lstRole;
    }

    @Override
    public Paging getAllRoles(int start, int length, SortUnit su, AccountTypeEnum accountTypeEnum) {
        ArrayList<Role> lstRole = new ArrayList<Role>();
        Paging rolepaging = new Paging();
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        String rolepagehql = "FROM RoleInfo as r ";
        if (accountTypeEnum != null) {
            rolepagehql = rolepagehql + " where r.roleType=?";
            param.put(0, String.valueOf(accountTypeEnum.getType()));
        }
        if (su != null) {
            String sortType = "asc";
            if ("desc".equalsIgnoreCase(su.getSortType())) {
                sortType = "desc";
            }
            rolepagehql = rolepagehql + " order by r." + ObjectConvertor.getRoleBoProByRoleVoPro(su.getFieldName()) + " " + sortType;
        }
        String countHql = "select count(*) from UserIdAndRoleId as ur where ur.id.roleId = ?";
        try {
            List<?> lstSingleRoleInfo = this.commDao.findPage(rolepagehql, start, length, param);
            for (RoleInfo tmpRoleInfo : lstSingleRoleInfo) {
                Role tmpRole = ObjectConvertor.translateBoRoleInfo(tmpRoleInfo, false);
                int icount = Integer.parseInt(String.valueOf(this.commDao.getBaseHibernateTemplate().find(countHql, (Object[])new Long[]{tmpRoleInfo.getRoleIdx()}).listIterator().next()));
                tmpRole.setUserNum(icount);
                lstRole.add(tmpRole);
            }
            rolepaging.setData(lstRole);
            rolepaging.setiCount(this.getRoleCount(accountTypeEnum));
        }
        catch (Exception e) {
            LOG.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        return rolepaging;
    }

    private int getRoleCount(AccountTypeEnum accountTypeEnum) {
        String couthql = "select count(*) from RoleInfo";
        if (accountTypeEnum != null) {
            couthql = couthql + " where roleType=:roleType";
        }
        String finalCouthql = couthql;
        return ((Long)this.commDao.getBaseHibernateTemplate().execute(session -> {
            Query query = session.createQuery(finalCouthql, Long.class);
            if (accountTypeEnum != null) {
                query.setParameter("roleType", (Object)accountTypeEnum.getType());
            }
            return (Long)query.uniqueResult();
        })).intValue();
    }

    public void setRoleDao(IRoleDao mroleDao) {
        this.roleDao = mroleDao;
    }

    public ICommonDao getCommDao() {
        return this.commDao;
    }

    public void setCommDao(ICommonDao commDao) {
        this.commDao = commDao;
    }
}

