/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service.usercache;

import com.huawei.lego.cbb.user.service.common.SessionGeneratorUtil;
import com.huawei.lego.cbb.user.service.usercache.IUserLoginLocalCache;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class UserLoginLocalCacheImpl
implements IUserLoginLocalCache<String, Object> {
    private static final Object SYNCOBJECT = new Object();
    private static final int NUM_1000 = 1000;
    private static final String ONLINEUSERSESSIONCOUNT = "userSessionCount_";
    private static final Log LOGGER = LogFactory.getInstance(UserLoginLocalCacheImpl.class);
    private ConcurrentHashMap<String, Object> caches;
    private ConcurrentHashMap<String, Long> expiryCache;
    private ConcurrentHashMap<String, Integer> intervalCache;
    private ConcurrentHashMap<String, Integer> saveToCache;
    private ScheduledExecutorService scheduleService;
    private int expiryInterval = 1;
    private String onlineSessionIdList = "onlineSessionIdList";

    public UserLoginLocalCacheImpl() {
        this.init();
    }

    public UserLoginLocalCacheImpl(int expiryInterval) {
        this.expiryInterval = expiryInterval;
        this.init();
    }

    private void init() {
        this.caches = new ConcurrentHashMap();
        this.expiryCache = new ConcurrentHashMap();
        this.intervalCache = new ConcurrentHashMap();
        this.saveToCache = new ConcurrentHashMap();
        this.scheduleService = Executors.newScheduledThreadPool(1);
        this.scheduleService.scheduleAtFixedRate(new CheckOutOfDateSchedule(this.caches, this.expiryCache), 0L, (long)this.expiryInterval * 60L, TimeUnit.SECONDS);
        LOGGER.info((Object)"User Local Cache is start!");
    }

    public boolean clear() {
        if (this.caches != null) {
            this.caches.clear();
        }
        if (this.expiryCache != null) {
            this.expiryCache.clear();
        }
        if (this.intervalCache != null) {
            this.intervalCache.clear();
        }
        LOGGER.info((Object)"User Local Cache is clear!");
        return true;
    }

    public boolean containsKey(String key) {
        this.checkValidate(key);
        return this.caches.containsKey(key);
    }

    public boolean containsKey(String key, boolean updateTime) {
        this.checkValidateUpdateTime(key);
        return this.caches.containsKey(key);
    }

    public Object get(String key) {
        this.checkValidate(key);
        return this.caches.get(key);
    }

    public Object get(String key, boolean updateTime) {
        this.checkValidateUpdateTime(key);
        return this.caches.get(key);
    }

    public Set<String> keySet() {
        this.checkAll();
        return this.expiryCache.keySet();
    }

    public Set<String> keySet(boolean updateTime) {
        this.checkAll();
        return this.expiryCache.keySet();
    }

    public Object put(String key, Object value) {
        Object result = this.caches.put(key, value);
        this.expiryCache.put(key, -1L);
        return result;
    }

    public Object put(String key, Object value, Date expiry) {
        Date now = new Date();
        int ttl = (int)(expiry.getTime() - now.getTime()) / 1000;
        this.saveToCache.put(key, ttl);
        return this.put(key, value, ttl);
    }

    public Object put(String key, Object value, int ttl) {
        Object result = this.caches.put(key, value);
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, ttl);
        this.expiryCache.put(key, calendar.getTime().getTime());
        this.intervalCache.put(key, ttl);
        return result;
    }

    public Object remove(String key) {
        Object result = this.caches.remove(key);
        this.expiryCache.remove(key);
        this.intervalCache.remove(key);
        return result;
    }

    public int size() {
        this.checkAll();
        return this.expiryCache.size();
    }

    public int size(boolean updateTime) {
        this.checkAlls();
        return this.expiryCache.size();
    }

    public Collection<Object> values() {
        this.checkAll();
        ArrayList<Object> values = new ArrayList<Object>();
        values.addAll(this.caches.values());
        return values;
    }

    public Collection<Object> values(boolean updateTime) {
        this.checkAlls();
        ArrayList<Object> values = new ArrayList<Object>();
        values.addAll(this.caches.values());
        return values;
    }

    public void removeExpiryCacheLego(ConcurrentHashMap<String, Long> cache, String key) {
        cache.remove(key);
        if (key.contains("USER_LOCK")) {
            SysOptLog.Builder builder = SysOptLog.builder().operation("lego.lab.log.func.userautounlock").module("lego.dic.module.user").operator("system");
            String[] username = key.split("USER_LOCK");
            if (username.length > 1) {
                builder.target(username[1]);
            }
            builder.level(SysoplogLevel.INFO.getValue()).success().build().writeOperateLog();
        }
    }

    public void removeExpiryCache(ConcurrentHashMap<String, Long> cache, String key) {
        this.removeExpiryCacheLego(cache, key);
    }

    private void checkValidate(String key) {
        if (key == null) {
            return;
        }
        Long date = this.expiryCache.get(key);
        if (date != null && date != -1L && new Date(date).before(new Date())) {
            this.caches.remove(key);
            this.expiryCache.remove(key);
            this.intervalCache.remove(key);
            if (this.saveToCache != null && this.saveToCache.get(key) != null) {
                this.saveToCache.remove(key);
            }
        } else {
            if (this.saveToCache != null && this.saveToCache.get(key) != null) {
                return;
            }
            Integer ttl = this.intervalCache.get(key);
            if (ttl == null) {
                return;
            }
            Object value = this.caches.get(key);
            this.put(key, value, (int)ttl);
        }
    }

    private void checkValidateUpdateTime(String key) {
        Long date;
        if (key != null && (date = this.expiryCache.get(key)) != null && date != -1L && new Date(date).before(new Date())) {
            this.caches.remove(key);
            this.removeExpiryCache(this.expiryCache, key);
            this.intervalCache.remove(key);
        }
    }

    private void checkAll() {
        for (String key : this.expiryCache.keySet()) {
            this.checkValidate(key);
        }
    }

    private void checkAlls() {
        for (String key : this.expiryCache.keySet()) {
            this.checkValidateUpdateTime(key);
        }
    }

    public void destroy() {
        try {
            this.clear();
            if (this.scheduleService != null) {
                this.scheduleService.shutdown();
            }
            this.scheduleService = null;
        }
        catch (Exception ex) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex), 1L);
        }
        LOGGER.info((Object)"Destory user local cache resources.", 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncMinusSessionCount(String key, int permitValue) {
        Object object = SYNCOBJECT;
        synchronized (object) {
            Object sessionCount = this.get(key);
            int count = 1;
            if (sessionCount == null) {
                LOGGER.error((Object)("the user login Info is null: " + key), 1L);
                return;
            }
            count = NumberUtil.convertToInteger((Object)sessionCount);
            if (--count < permitValue) {
                throw new LegoCheckedException(1073947393L);
            }
            if (0 == count) {
                this.remove(key);
            } else {
                this.put(key, (Object)count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncAddSessionCount(String key, int permitValue) {
        Object object = SYNCOBJECT;
        synchronized (object) {
            Object sessionCount = this.get(key);
            int count = 0;
            if (sessionCount != null) {
                count = NumberUtil.convertToInteger((Object)sessionCount);
            }
            if (++count > permitValue) {
                throw new LegoCheckedException(1073947393L);
            }
            this.put(key, (Object)count);
        }
    }

    class CheckOutOfDateSchedule
    implements Runnable {
        private ConcurrentHashMap<String, Object> caches;
        private ConcurrentHashMap<String, Long> expiryCache;

        public CheckOutOfDateSchedule(ConcurrentHashMap<String, Object> caches, ConcurrentHashMap<String, Long> expiryCache) {
            this.caches = caches;
            this.expiryCache = expiryCache;
        }

        @Override
        public void run() {
            try {
                this.check();
            }
            catch (Exception ex) {
                LOGGER.info((Object)String.format(Locale.ENGLISH, "Local Cache Exception!%s.", ExceptionUtil.getErrorMessage((Throwable)ex)));
            }
        }

        public void check() {
            for (String key : this.caches.keySet()) {
                Long date = this.expiryCache.get(key);
                if (date == null || date <= 0L || !new Date(date).before(new Date())) continue;
                this.doRemoveCache(this.caches, key);
                this.doRemoveOnlineUser(this.caches, key);
                String userId = SessionGeneratorUtil.getUserIdFromSessionId(key);
                UserLoginLocalCacheImpl.this.syncMinusSessionCount(UserLoginLocalCacheImpl.ONLINEUSERSESSIONCOUNT + userId, Integer.MIN_VALUE);
            }
        }

        private void doRemoveCache(ConcurrentHashMap<String, Object> cache, String key) {
            UserLoginLocalCacheImpl.this.saveToCache.remove(key);
            UserLoginLocalCacheImpl.this.intervalCache.remove(key);
            UserLoginLocalCacheImpl.this.removeExpiryCache(this.expiryCache, key);
            cache.remove(key);
        }

        private void doRemoveOnlineUser(ConcurrentHashMap<String, Object> cache, String key) {
            ConcurrentSkipListSet set;
            if (cache.containsKey(UserLoginLocalCacheImpl.this.onlineSessionIdList) && null != (set = (ConcurrentSkipListSet)cache.get(UserLoginLocalCacheImpl.this.onlineSessionIdList))) {
                set.remove(key);
            }
        }
    }
}

