/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.framework.container;

import com.huawei.lego.core.base.bound.BoundAnnotationBeanPostProcessor;
import com.huawei.lego.core.base.framework.container.Monitor;
import com.huawei.lego.core.base.framework.container.PreLaunchProcessor;
import com.huawei.lego.core.base.framework.container.support.ServiceExportPreProcessor;
import com.huawei.lego.core.base.framework.container.support.SpringFrameworkHook;
import com.huawei.lego.core.base.framework.container.support.SystemStartupMonitor;
import com.huawei.lego.core.sdk.base.event.StatusChangedListener;
import com.huawei.lego.core.sdk.base.structure.IApplication;
import com.huawei.lego.core.sdk.base.structure.ICallback;
import com.huawei.lego.core.sdk.base.structure.ILifecycle;
import com.huawei.lego.core.sdk.base.structure.IService;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.springframework.context.ApplicationContext;

public abstract class Launcher {
    private SpringFrameworkHook hook;
    private List<PreLaunchProcessor> preProcessors;
    private List<Monitor> monitors;

    public Launcher(SpringFrameworkHook hook) {
        this.hook = hook;
        this.monitors = new ArrayList<Monitor>();
        this.monitors.add(new SystemStartupMonitor());
        this.preProcessors = new ArrayList<PreLaunchProcessor>();
        this.preProcessors.add(new ServiceExportPreProcessor());
    }

    public abstract void launch(ApplicationContext var1) throws MalformedURLException, URISyntaxException;

    public SpringFrameworkHook getHook() {
        return this.hook;
    }

    public void setHook(SpringFrameworkHook hook) {
        this.hook = hook;
    }

    public List<PreLaunchProcessor> getPreProcessors() {
        return this.preProcessors;
    }

    public void setPreProcessors(List<PreLaunchProcessor> preProcessors) {
        this.preProcessors = preProcessors;
    }

    public List<Monitor> getMonitors() {
        return this.monitors;
    }

    public void setMonitors(List<Monitor> monitors) {
        this.monitors = monitors;
    }

    public static class ListenerInitializeCallback
    implements ICallback {
        public void invoke(ILifecycle life) {
            List<StatusChangedListener> listeners = null;
            if (life instanceof IApplication) {
                listeners = BoundAnnotationBeanPostProcessor.getLegoSystem().getAppStatusListeners();
            } else if (life instanceof IService) {
                listeners = BoundAnnotationBeanPostProcessor.getLegoSystem().getSrvStatusListeners();
            }
            if (null != listeners && !listeners.isEmpty()) {
                for (StatusChangedListener listener : listeners) {
                    life.addStatusChangeListener((EventListener)listener);
                }
            }
        }
    }
}

