/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.framework.rpc.rmi;

import com.huawei.lego.core.base.framework.rpc.Protocol;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.IServiceExporter;
import com.huawei.lego.core.sdk.base.Registry;
import com.huawei.lego.core.sdk.base.structure.IService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RemoteServiceExporter
implements IServiceExporter<IService> {
    private static final Log LOGGER = LogFactory.getInstance(RemoteServiceExporter.class);
    private Map<String, Protocol> protocols = new HashMap<String, Protocol>();

    public boolean export(IService service) {
        boolean reValue = false;
        try {
            List registries = ((BaseService)service).getRegistries();
            for (Registry registry : registries) {
                URI regUrl = registry.getRegistryURL();
                this.protocols.get(regUrl.getScheme()).apply(service, regUrl);
            }
            reValue = true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("export service failed: " + service.getClass().getName() + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return reValue;
    }

    public boolean unExport(IService service) {
        boolean reValue = false;
        try {
            List registries = ((BaseService)service).getRegistries();
            for (Registry registry : registries) {
                URI regUrl = registry.getRegistryURL();
                this.protocols.get(regUrl.getScheme()).destory(service);
            }
            reValue = true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("unExport service failed: " + service.getClass().getName() + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return reValue;
    }

    public void bindProtocol(Protocol protocol, Map properties) {
        this.protocols.put(protocol.getProtocolType(), protocol);
    }

    public void unbindProtocol(Protocol protocol, Map properties) {
        this.protocols.remove(protocol.getProtocolType());
    }
}

