/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.framework.rpc.support;

import com.huawei.lego.core.base.framework.rpc.Publisher;
import com.huawei.lego.core.base.framework.rpc.support.LocalPublisher;
import com.huawei.lego.core.base.framework.rpc.support.RemotePublisher;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.Registry;
import com.huawei.lego.core.sdk.base.structure.IService;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class PublisherFactory {
    private static List<String> localIPs = new ArrayList<String>();

    public List<Publisher> createPublisher(IService service) {
        ArrayList<Publisher> publisher = new ArrayList<Publisher>();
        if (service instanceof BaseService) {
            BaseService bService = (BaseService)service;
            List registries = bService.getRegistries();
            for (Registry registry : registries) {
                URI uri = registry.getRegistryURL();
                if (localIPs.contains(uri.getHost())) {
                    publisher.add(new LocalPublisher());
                    continue;
                }
                publisher.add(new RemotePublisher());
            }
        }
        return publisher;
    }

    static {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            if (en != null) {
                while (en.hasMoreElements()) {
                    NetworkInterface networkinterface = en.nextElement();
                    Enumeration<InetAddress> addresses = networkinterface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        localIPs.add(addresses.nextElement().getHostAddress());
                    }
                }
            }
        }
        catch (SocketException e) {
            throw new LegoUncheckedException((Throwable)e);
        }
    }
}

