/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.domain.context;

import com.huawei.lego.core.domain.context.BaseContext;
import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class ModelContext
extends BaseContext {
    private static final Log LOGGER = LogFactory.getInstance(ModelContext.class);
    private static final long serialVersionUID = 1L;
    private String id = "";
    private String type = "";
    private Class moClass = null;
    private String name = "";
    private Class manager = null;
    private String version = "";
    private String description = "";
    private String definition = "";
    private String index = "";
    private String subType = "";
    private List<ModelContext> subModel = new ArrayList<ModelContext>();
    private String referredOid = "";
    private String referingOid = "";
    private String isPolling = "";

    public ModelContext(Element ele) {
        this.initContextField(this, ele);
        try {
            ClassLoader classLoader;
            String moClassStr = ele.attributeValue("moClass");
            if (this.checkClassNotNull(moClassStr) && null != (classLoader = AdapterUtils.getClassLoader(this.getClass()))) {
                this.moClass = classLoader.loadClass(moClassStr);
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        String mgr = ele.attributeValue("manager");
        this.processMgr(mgr);
        Node tmpNode = ele.selectSingleNode("subModel");
        if (tmpNode != null) {
            List subs = ((Element)tmpNode).elements();
            for (Element tmpEle : subs) {
                String xpath = "//models/model[@id='" + tmpEle.attributeValue("ref") + "']";
                this.referredOid = tmpEle.attributeValue("referredOid");
                this.getLog().info((Object)("referredOid is : " + this.referredOid));
                Node refNode = ele.getParent().selectSingleNode(xpath);
                if (refNode == null) continue;
                this.subModel.add(new ModelContext((Element)refNode));
            }
        }
    }

    private boolean checkClassNotNull(String moClassStr) {
        if (null == this.getClass() || null == this.getClass().getClassLoader()) {
            return false;
        }
        return moClassStr != null && !"".equals(moClassStr);
    }

    private void processMgr(String mgr) {
        if (mgr == null || "".equals(mgr)) {
            this.getLog().info((Object)"mgr == null or is space str");
        } else {
            try {
                ClassLoader classLoader = AdapterUtils.getClassLoader(this.getClass());
                if (null != classLoader) {
                    this.manager = classLoader.loadClass(mgr);
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
            }
        }
    }

    public String getReferredOid() {
        return this.referredOid;
    }

    public void setReferredOid(String referredOid) {
        this.referredOid = referredOid;
    }

    public String getReferingOid() {
        return this.referingOid;
    }

    public void setReferingOid(String referingOid) {
        this.referingOid = referingOid;
    }

    public String getMoType() {
        return this.type;
    }

    public void setMoType(String moType) {
        this.type = moType;
    }

    public Class getMoClass() {
        return this.moClass;
    }

    public void setMoClass(Class moClass) {
        this.moClass = moClass;
    }

    public String getMoName() {
        return this.name;
    }

    public void setMoName(String moName) {
        this.name = moName;
    }

    public Class getMoManager() {
        return this.manager;
    }

    public void setMoManager(Class moManager) {
        this.manager = moManager;
    }

    public List<ModelContext> getSubModel() {
        return this.subModel;
    }

    public void setSubModel(List<ModelContext> subModel) {
        this.subModel = subModel;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getIsPolling() {
        return this.isPolling;
    }

    public void setIsPolling(String isPolling) {
        this.isPolling = isPolling;
    }
}

