/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.syslog.service;

import com.huawei.lego.cbb.i18n.sdk.I18nMgr;
import com.huawei.lego.core.sdk.file.util.FileFactory;
import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.system.syslog.sdk.model.OptLogMo;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.huawei.lego.core.system.syslog.service.ISysOptStorage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SysOptStorage
implements ISysOptStorage {
    private static final Log LOGGER = LogFactory.getInstance(SysOptStorage.class);
    private static final int RESNUM = 2;
    private I18nMgr i18nMrg;
    private Locale locale = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logExport(List<OptLogMo> logList, String fileType, String lang, File tempFile, String fileNameTmp, int serialNum) {
        this.locale = "en".equals(lang) ? new Locale(lang) : new Locale("zh", "CN");
        String type = fileType;
        List<String> column = this.getColumn();
        FileUtil fileUtil = null;
        try {
            String downloadPath = tempFile.getCanonicalPath() + File.separator + fileNameTmp;
            fileUtil = FileFactory.getFileUtil((String)type);
            if (null != fileUtil) {
                fileUtil.fileSet("", column, downloadPath + serialNum);
                if ("en".equals(lang)) {
                    fileUtil.setStrChar("UTF-8");
                } else {
                    fileUtil.setStrChar("GBK");
                }
                List<List<String>> sysLog = this.logToStrWithId(logList);
                fileUtil.writeFile(sysLog, "detail" + File.separator);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("write file error" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            try {
                if (null != fileUtil) {
                    fileUtil.closeFile();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)("write file error" + e), 1L);
            }
        }
    }

    private List<List<String>> logToStrWithId(List<OptLogMo> lstLog) {
        ArrayList<List<String>> lstStr = new ArrayList<List<String>>();
        for (OptLogMo optLogMo : lstLog) {
            List<String> tempLst = this.getOptLogString(optLogMo);
            this.setTempLists(optLogMo, tempLst);
            String detail = this.getText(optLogMo.getOpDetail());
            String optDetailPama = optLogMo.getOpDetailPama();
            if (this.checkDeParaNotNull(optDetailPama)) {
                String split = "\n";
                String[] detailParam = null;
                detailParam = optDetailPama.split(split);
                int detailParamLen = detailParam.length;
                for (int i = 0; i < detailParamLen; ++i) {
                    detailParam[i] = this.getText(detailParam[i]);
                }
                try {
                    detail = MessageFormatUtil.format((String)detail, (Object[])this.appendEmptyPlaceHolder(detailParam, 3));
                }
                catch (Exception ex) {
                    LOGGER.error((Object)("MessageFormat.format(targt, targetParam)" + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
                }
            }
            if (this.checkContainBR(detail)) {
                detail = detail.replaceAll("<br>", " ");
            }
            tempLst.add(detail);
            if (optLogMo.getHasDetail() == 1) {
                tempLst.add(String.valueOf(optLogMo.getId()));
            } else {
                tempLst.add(null);
            }
            lstStr.add(tempLst);
        }
        return lstStr;
    }

    private boolean checkDeParaNotNull(String optDetailPama) {
        return null != optDetailPama && !optDetailPama.trim().equals("");
    }

    private boolean checkContainBR(String detail) {
        return detail != null && detail.contains("<br>");
    }

    private void setTempLists(OptLogMo sOptLog, List<String> tempLst) {
        if (0 != sOptLog.getTargetLocal()) {
            String split = "\n";
            String param = sOptLog.getOpTargetPama();
            String[] targetParam = null;
            if (null != param && !"".equals(param.trim())) {
                targetParam = param.split(split);
                int targetParamLen = targetParam.length;
                for (int i = 0; i < targetParamLen; ++i) {
                    targetParam[i] = this.getText(targetParam[i]);
                }
                String targt = this.getText(sOptLog.getOpTarget());
                String targetLocal = "";
                try {
                    targetLocal = MessageFormatUtil.format((String)targt, (Object[])this.appendEmptyPlaceHolder(targetParam, 3));
                }
                catch (Exception ex) {
                    LOGGER.error((Object)("MessageFormat.format(targt, targetParam)" + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
                }
                tempLst.add(targetLocal);
            } else if (sOptLog.getOpTarget() != null) {
                String targt = this.getText(sOptLog.getOpTarget());
                tempLst.add(targt);
            }
        } else {
            tempLst.add(sOptLog.getOpTarget());
        }
    }

    private String[] appendEmptyPlaceHolder(String[] params, int count) {
        int originalCount = params.length;
        int resultCount = originalCount + count;
        String[] result = new String[resultCount];
        System.arraycopy(params, 0, result, 0, originalCount);
        for (int i = originalCount; i < resultCount; ++i) {
            result[i] = "--";
        }
        return result;
    }

    private List<String> getOptLogString(OptLogMo sOptLog) {
        ArrayList<String> tempLst = new ArrayList<String>();
        tempLst.add(this.getText(sOptLog.getOpName()));
        if (sOptLog.getRiskLevel() == SysoplogLevel.RISK.getValue()) {
            tempLst.add(this.getText("lego.dic.syslog.dangerlevel.risk"));
        } else if (sOptLog.getRiskLevel() == SysoplogLevel.NORMAL.getValue()) {
            tempLst.add(this.getText("lego.dic.syslog.dangerlevel.normal"));
        } else if (sOptLog.getRiskLevel() == SysoplogLevel.WARNING.getValue()) {
            tempLst.add(this.getText("lego.dic.syslog.dangerlevel.warn"));
        } else {
            tempLst.add(this.getText("lego.dic.syslog.dangerlevel.info"));
        }
        tempLst.add(sOptLog.getOpUser());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        tempLst.add(dateFormat.format(sOptLog.getOpTime()) + " " + TimeUtil.getDefaultTimeZone());
        tempLst.add(this.getText(sOptLog.getOptModuleName()));
        if (0 == sOptLog.getOpResult()) {
            tempLst.add(this.getText("lego.dic.resulttype.failure"));
        } else if (sOptLog.getOpResult() == 2) {
            tempLst.add(this.getText("lego.dic.resulttype.halfsuccess"));
        } else {
            tempLst.add(this.getText("lego.dic.resulttype.success"));
        }
        tempLst.add(sOptLog.getOpIpAddress());
        return tempLst;
    }

    private List<String> getColumn() {
        ArrayList<String> column = new ArrayList<String>();
        column.add(this.getText("syslog_term_operation_label"));
        column.add(this.getText("syslog_term_level_label"));
        column.add(this.getText("setting_sysoperlog_list_user_column"));
        column.add(this.getText("syslog_term_date_label"));
        column.add(this.getText("lego.lab.log.oprationtype"));
        column.add(this.getText("syslog_term_result_label"));
        column.add(this.getText("syslog_term_terminalIp_label"));
        column.add(this.getText("syslog_term_target_label"));
        column.add(this.getText("syslog_term_detail_label"));
        column.add(this.getText("lego.lab.log.detailfile"));
        return column;
    }

    public I18nMgr getI18nMrg() {
        return this.i18nMrg;
    }

    public void setI18nMrg(I18nMgr i18nMrg) {
        this.i18nMrg = i18nMrg;
    }

    private String getText(String key) {
        return this.i18nMrg.getString(key, this.locale);
    }
}

