/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.discover.dao;

import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.base.persistance.dao.CommonDaoImpl;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.dao.IDiscoveryDao;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DiscoveryDaoImpl
extends CommonDaoImpl
implements IDiscoveryDao {
    private static final List<Long> FILTER_ERROR_CODE = new ArrayList<Long>();
    private static final Log LOGGER = LogFactory.getInstance(DiscoveryDaoImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Paging getDiscoveryResult(Long discoveryPolicyId, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        StringBuilder pageHql = this.getPageHql(discoveryPolicyId, orderByField);
        StringBuilder totalCountHql = new StringBuilder("select count(*) from DiscoveryResult discoveryResult where discoveryResult.discoveryPolicy.discoveryPolicyId = ").append(discoveryPolicyId).append(" and discoveryResult.errorCode not in(").append(1051L).append(",").append(1052L).append(",").append(1053L).append(",").append(1061L).append(")");
        if (orderByAscend) {
            pageHql.append(" asc");
        } else {
            pageHql.append(" desc");
        }
        Session session = null;
        Paging paging = new Paging();
        try {
            session = super.getSessionFactory().getCurrentSession();
            Query pageQuery = session.createQuery(pageHql.toString());
            Query totalCountQuery = session.createQuery(totalCountHql.toString());
            int totalCountWithoutPaging = ((Long)totalCountQuery.uniqueResult()).intValue();
            pageQuery.setFirstResult(firstRowIndex);
            pageQuery.setMaxResults(totalRow);
            List resultList = pageQuery.list();
            paging.setiCount(totalCountWithoutPaging);
            paging.setData(resultList);
        }
        catch (RuntimeException re) {
            LOGGER.error((Object)"runtime exception when getDiscoveryResult", (Throwable)re, 1L);
            throw re;
        }
        catch (Exception e) {
            LOGGER.error((Object)("exception when getDiscoveryResult " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
        return paging;
    }

    private StringBuilder getPageHql(Long discoveryPolicyId, String orderByField) {
        StringBuilder pageHql = new StringBuilder("from DiscoveryResult discoveryResult where discoveryResult.discoveryPolicy.discoveryPolicyId = ").append(discoveryPolicyId).append(" and discoveryResult.errorCode not in(").append(1051L).append(",").append(1052L).append(",").append(1053L).append(",").append(1061L).append(")").append(" order by discoveryResult.").append(orderByField);
        return pageHql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Paging getImportedDiscoveryItem(Long discoveryPolicyId, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        StringBuilder pageHql = new StringBuilder("from ImportedDiscoveryItem item where item.discoveryPolicy.discoveryPolicyId = ?").append(" order by item.").append(orderByField);
        StringBuilder totalCountHql = new StringBuilder("select count(*) from ImportedDiscoveryItem item where item.discoveryPolicy.discoveryPolicyId = ?");
        if (orderByAscend) {
            pageHql.append(" asc");
        } else {
            pageHql.append(" desc");
        }
        Session session = null;
        Paging paging = new Paging();
        try {
            session = super.getSessionFactory().getCurrentSession();
            Query pageQuery = session.createQuery(pageHql.toString());
            pageQuery.setParameter(0, (Object)discoveryPolicyId);
            Query totalCountQuery = session.createQuery(totalCountHql.toString());
            totalCountQuery.setParameter(0, (Object)discoveryPolicyId);
            int totalCountWithoutPaging = ((Long)totalCountQuery.uniqueResult()).intValue();
            pageQuery.setFirstResult(firstRowIndex);
            pageQuery.setMaxResults(totalRow);
            List resultList = pageQuery.list();
            paging.setiCount(totalCountWithoutPaging);
            paging.setData(resultList);
        }
        catch (RuntimeException re) {
            LOGGER.error((Object)"runtime exception when getImportedDiscoveryItem", (Throwable)re, 1L);
            throw re;
        }
        catch (Exception e) {
            LOGGER.error((Object)("exception when getImportedDiscoveryItem: " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
        return paging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUniqueDiscoveryLocation() {
        List tempList = null;
        StringBuffer sb = new StringBuffer("select distinct discoveryPolicy.location from DiscoveryPolicy discoveryPolicy");
        String sqlString = sb.toString();
        Session session = null;
        try {
            session = super.getSessionFactory().getCurrentSession();
            Query pageQuery = session.createQuery(sqlString);
            tempList = pageQuery.list();
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"RuntimeException occered when getUniqueDiscoveryLocation error. ", (Throwable)e, 1L);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception occered when getUniqueDiscoveryLocation, " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
        return tempList;
    }

    static {
        FILTER_ERROR_CODE.add(1051L);
    }
}

