/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.discover.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.util.StringUtils;

public class PropertyUtil {
    private static final Properties PROPS = new Properties();
    private static final Log LOGGER = LogFactory.getInstance(PropertyUtil.class);

    public static String getMaxImportedRow() {
        String value = PROPS.getProperty("maxImportedRow");
        if (!StringUtils.hasText((String)value)) {
            LOGGER.error((Object)"can not get the value of maxImportedRow!!!", 1L);
            value = "5000";
        }
        return value;
    }

    static {
        InputStream ins = null;
        try {
            ClassLoader cl = PropertyUtil.class.getClassLoader();
            if (null != cl) {
                ins = cl.getResourceAsStream("discover.properties");
                PROPS.load(ins);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"read discover.properties failed.", (Throwable)e, 1L);
        }
        finally {
            if (null != ins) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Close the input stream failed.", 1L);
                }
            }
        }
    }
}

