/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.discover.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class WatchUtil {
    private static final int VALUE_2 = 2;
    private static final int VALUE_3 = 3;
    private static final int VALUE_4 = 4;
    private static final int VALUE_8 = 8;
    private static final int VALUE_FF = 255;
    private static final int VALUE_255 = 255;
    private static final int VALUE_16 = 16;
    private static final Log LOGGER = LogFactory.getInstance(WatchUtil.class);

    public static String[] getRange(String net, String netmask, String startIp, String endIp) {
        long startLong = WatchUtil.getAddrLong(startIp);
        long endLong = WatchUtil.getAddrLong(endIp);
        ArrayList<String> result = new ArrayList<String>();
        for (long i = startLong; i <= endLong && WatchUtil.inNet(i, net, netmask); ++i) {
            result.add(WatchUtil.convertAddr(i));
        }
        String[] array = new String[result.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (String)result.get(i);
        }
        return array;
    }

    public static String convertAddr(long address) {
        int[] addr = new int[4];
        for (int i = 0; i < 4; ++i) {
            addr[i] = (int)(address >> 8 * (3 - i) & 0xFFL);
        }
        return addr[0] + "." + addr[1] + "." + addr[2] + "." + addr[3];
    }

    public static long getAddrLong(String address) {
        int[] addr = WatchUtil.getAddrArray(address);
        if (addr == null || 0 == addr.length) {
            return 0L;
        }
        long laddr = 0L;
        for (int i = 0; i < 4; ++i) {
            laddr |= (long)(addr[i] << 8 * (3 - i));
        }
        return laddr;
    }

    public static int[] getAddrArray(String address) {
        int i;
        if (address == null) {
            return new int[0];
        }
        if (address.indexOf(":") != -1) {
            return WatchUtil.getIPV6AddrArray(address);
        }
        StringTokenizer st = new StringTokenizer(address, ".");
        if (st.countTokens() != 4) {
            return new int[0];
        }
        int[] addr = new int[4];
        try {
            for (i = 0; i < 4; ++i) {
                addr[i] = NumberUtil.convertToInteger((Object)st.nextToken());
            }
        }
        catch (NumberFormatException ne) {
            return new int[0];
        }
        for (i = 0; i < 4; ++i) {
            if (addr[i] >= 0 && addr[i] <= 255) continue;
            return new int[0];
        }
        return addr;
    }

    private static boolean inNet(long laddr, String net, String netmask) {
        long allmask = WatchUtil.getAddrLong("255.255.255.255");
        long lNetmask = WatchUtil.getAddrLong(netmask);
        long lNet = WatchUtil.getAddrLong(net);
        lNet &= lNetmask;
        long nsize = allmask ^ lNetmask;
        if (laddr == 0L) {
            return false;
        }
        return laddr < lNet + nsize && laddr >= lNet;
    }

    private static int[] getIPV6AddrArray(String address) {
        int i;
        try {
            InetAddress inet = InetAddress.getByName(address);
            address = inet.getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
        StringTokenizer st = new StringTokenizer(address, ":");
        if (st.countTokens() != 8) {
            return new int[0];
        }
        String[] str = new String[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            str[i2] = st.nextToken();
        }
        int[] addr = new int[16];
        int tempIdx = 0;
        for (i = 0; i < str.length; ++i) {
            for (int j = str[i].length(); j < 4; ++j) {
                str[i] = "0" + str[i];
            }
            String s1 = str[i].substring(0, 2);
            String s2 = str[i].substring(2);
            try {
                addr[tempIdx++] = NumberUtil.convertToInteger((Object)s1, (int)16);
                addr[tempIdx++] = NumberUtil.convertToInteger((Object)s2, (int)16);
                continue;
            }
            catch (NumberFormatException ne) {
                return new int[0];
            }
        }
        for (i = 0; i < 16; ++i) {
            if (!WatchUtil.checkAddrRangeInvalid(addr[i])) continue;
            return new int[0];
        }
        return addr;
    }

    private static boolean checkAddrRangeInvalid(int addr) {
        return addr < 0 || addr > 255;
    }

    public static boolean regexpMatchIp(String ip) {
        if (VerifyUtil.isEmpty((String)ip)) {
            return false;
        }
        return WatchUtil.isIPv4Address(ip) || WatchUtil.isIPv6Address(ip);
    }

    public static boolean isIPv6Address(String ip) {
        return Ipv6AddressUtil.isIPv6Address((String)ip);
    }

    public static boolean isIPv4Address(String ip) {
        return Ipv4AddressUtil.isIPv4Address((String)ip);
    }
}

