/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.jms.handler;

import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.jms.IFaultMsgHandler;
import com.huawei.lego.nem.fault.launcher.impl.MsgSubscribeLauncher;
import com.huawei.lego.nem.fault.msg.listener.AlarmStatisticListener;
import com.huawei.lego.nem.fault.sdk.model.AlarmStatistic;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class AlarmStatisticMsgHandler
implements IFaultMsgHandler {
    private static final Log LOGGER = LogFactory.getInstance(AlarmStatisticMsgHandler.class);

    @Override
    public long getMsgType() {
        return 5003L;
    }

    @Override
    public void handleMsg(MessageUnit mu) {
        HashMap<Long, AlarmStatistic> statistics = new HashMap<Long, AlarmStatistic>();
        List moIdList = (List)mu.getObj();
        Iterator iterator = moIdList.iterator();
        while (iterator.hasNext()) {
            long moId = (Long)iterator.next();
            AlarmStatistic statistic = AlarmStatisticListener.getStatistic(moId);
            if (null == statistic) continue;
            statistics.put(moId, statistic);
        }
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "Send COMMAND_RESPONSE_ALARM_STATISTIC message in AlarmStatisticSubscriber: %s.", statistics), 1L);
        MessageUnit tmu = new MessageUnit();
        tmu.setCmdcode(5004L);
        tmu.setObj(statistics);
        mu.setMt(MessageTopic.DATA);
        mu.setSourceAppName(this.getClass().getName());
        MsgSubscribeLauncher.getMc().sendMessage(tmu);
    }
}

