/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.service;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgrBaseService;
import com.huawei.lego.core.base.util.KeyLocker;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.nem.fault.FaultApplication;
import com.huawei.lego.nem.fault.dao.IRemoteNotifyRuleDAO;
import com.huawei.lego.nem.fault.sdk.model.NotifyAlarmItem;
import com.huawei.lego.nem.fault.sdk.model.NotifyResItem;
import com.huawei.lego.nem.fault.sdk.model.RemoteNotifyRule;
import com.huawei.lego.nem.fault.sdk.service.IFaultDefineService;
import com.huawei.lego.nem.fault.sdk.service.IRemoteNotifyRuleService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Service(name="remoteNotifyRuleService", desc="", interfaceClass=IRemoteNotifyRuleService.class)
public class RemoteNotifyRuleServiceImpl
extends BaseService
implements IRemoteNotifyRuleService {
    private static final Log LOGGER = LogFactory.getInstance(RemoteNotifyRuleServiceImpl.class);
    private static final KeyLocker UPDATE_NOTIFY_RULE_LOCK = new KeyLocker(RemoteNotifyRuleServiceImpl.class, "UPDATE_NOTIFY_RULE_LOCK");
    private static final long UPDATE_NOTIFY_RULE_TIME_OUT = 2000L;
    private static final long VALUE_250L = 250L;
    private static final int VALUE_5 = 5;
    private static final int VALUE_3 = 3;
    private IRemoteNotifyRuleDAO remoteNotifyRuleDAO;
    private Map<Long, RemoteNotifyRule> notifyRuleMap = new HashMap<Long, RemoteNotifyRule>();
    private boolean initTag = false;

    public BatchOperationResult setSwitchStatus(boolean useStatus, List<BatchOperation> ruleIds) {
        BatchOperationResult results = new BatchOperationResult();
        ArrayList<BatchOperation> resultLists = new ArrayList<BatchOperation>();
        int failss = 0;
        int operCount = 0;
        if (ruleIds != null) {
            operCount = ruleIds.size();
            for (BatchOperation batchOperation : ruleIds) {
                failss = this.setSingleStatus(useStatus, failss, batchOperation);
                resultLists.add(batchOperation);
            }
        }
        results.setResult(resultLists);
        results.setFailCount(failss);
        results.setTotalCount(operCount);
        results.setSucceedCount(operCount - failss);
        return results;
    }

    private synchronized int setSingleStatus(boolean useStatus, int fail, BatchOperation batchOperation) {
        if (null == batchOperation) {
            return fail + 1;
        }
        try {
            RemoteNotifyRule remoteNotifyRule = this.remoteNotifyRuleDAO.getRuleByID(String.valueOf(batchOperation.getTargetId()));
            this.setRuleStatus(useStatus, remoteNotifyRule);
            this.remoteNotifyRuleDAO.modifyBaseRule(remoteNotifyRule);
            this.notifyRuleMap.put(remoteNotifyRule.getId(), remoteNotifyRule);
        }
        catch (LegoCheckedException e) {
            ++fail;
            batchOperation.setErrorCode(e.getErrorCode());
        }
        catch (LegoUncheckedException e) {
            ++fail;
            batchOperation.setErrorCode(e.getErrorCode());
        }
        return fail;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setRuleStatus(boolean useStatus, RemoteNotifyRule remoteNotifyRule) {
        long currentTime = System.currentTimeMillis();
        if (useStatus) {
            if (currentTime >= remoteNotifyRule.getEndTime()) {
                throw new LegoCheckedException(1553L);
            }
            if (remoteNotifyRule.isUseEnable()) throw new LegoCheckedException(1537L);
            remoteNotifyRule.setUseEnable(useStatus);
            return;
        } else {
            if (!remoteNotifyRule.isUseEnable()) throw new LegoCheckedException(1546L);
            remoteNotifyRule.setUseEnable(useStatus);
        }
    }

    public synchronized String addRule(RemoteNotifyRule remoteNotifyRule, String[] emailToList, String[] smsPhoneList, String[] fields, String[] resources, String[] alarmInfos) {
        this.setEmailAddress(emailToList, remoteNotifyRule);
        this.setPhone(smsPhoneList, remoteNotifyRule);
        this.setContent(fields, remoteNotifyRule);
        this.setTime(remoteNotifyRule, false);
        this.setRuleItem(remoteNotifyRule, resources, alarmInfos);
        String ruleId = this.remoteNotifyRuleDAO.addRule(remoteNotifyRule);
        remoteNotifyRule.setId(NumberUtil.convertToLong((Object)ruleId).longValue());
        this.notifyRuleMap.put(remoteNotifyRule.getId(), remoteNotifyRule);
        return ruleId;
    }

    public boolean checkRuleEndTime(RemoteNotifyRule remoteNotifyRule) {
        this.setTime(remoteNotifyRule, true);
        return true;
    }

    public BatchOperationResult deleteRules(List<BatchOperation> ruleIds) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (ruleIds != null) {
            operCount = ruleIds.size();
            for (BatchOperation batchOperation : ruleIds) {
                fail = this.deleteSingleRule(fail, batchOperation);
                resultList.add(batchOperation);
            }
        }
        result.setResult(resultList);
        result.setFailCount(fail);
        result.setTotalCount(operCount);
        result.setSucceedCount(operCount - fail);
        return result;
    }

    private synchronized int deleteSingleRule(int fail, BatchOperation batchOperation) {
        if (null == batchOperation) {
            return fail + 1;
        }
        try {
            RemoteNotifyRule remoteNotifyRule = this.remoteNotifyRuleDAO.getRuleByID(String.valueOf(batchOperation.getTargetId()));
            this.remoteNotifyRuleDAO.deleteRule(remoteNotifyRule);
            this.notifyRuleMap.remove(remoteNotifyRule.getId());
        }
        catch (LegoCheckedException e) {
            ++fail;
            batchOperation.setErrorCode(e.getErrorCode());
        }
        catch (LegoUncheckedException e) {
            ++fail;
            batchOperation.setErrorCode(e.getErrorCode());
        }
        return fail;
    }

    public RemoteNotifyRule getRuleByID(String ruleId) {
        return this.remoteNotifyRuleDAO.getRuleByID(ruleId);
    }

    public Paging getRuleAndCountByName(String ruleName, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("ruleName", ruleName);
        return this.getRulesAndAllCountByCondition(condition, firstRowIndex, totalRow, orderByField, orderByAscend);
    }

    public Paging getRuleAndCountByResName(String resName, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("moName", resName);
        return this.getRulesAndAllCountByCondition(condition, firstRowIndex, totalRow, orderByField, orderByAscend);
    }

    public Paging getRulesAndAllCount(int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        return this.getRulesAndAllCountByCondition(null, firstRowIndex, totalRow, orderByField, orderByAscend);
    }

    public List<RemoteNotifyRule> getAllRules() {
        if (!this.initTag) {
            this.init();
            this.initTag = true;
        }
        ArrayList<RemoteNotifyRule> ruleList = new ArrayList<RemoteNotifyRule>();
        Set<Map.Entry<Long, RemoteNotifyRule>> entrys = this.notifyRuleMap.entrySet();
        for (Map.Entry<Long, RemoteNotifyRule> entry : entrys) {
            ruleList.add(entry.getValue());
        }
        return ruleList;
    }

    private void init() {
        this.notifyRuleMap.clear();
        Paging paging = this.getRulesAndAllCountByCondition(null, -1, -1, "ruleName", true);
        List ruleList = paging.getData();
        for (RemoteNotifyRule remoteNotifyRule : ruleList) {
            this.notifyRuleMap.put(remoteNotifyRule.getId(), remoteNotifyRule);
        }
    }

    public Paging getRulesAndAllCountByCondition(Map<String, Object> condition, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        return this.remoteNotifyRuleDAO.getRuleAndCountByCondition(condition, firstRowIndex, totalRow, orderByField, orderByAscend);
    }

    public boolean modifyNotifyBaseInfo(String ruleId, boolean useStatus, String[] startEndTime, String description, int language, String sendContent) {
        boolean result;
        if (!UPDATE_NOTIFY_RULE_LOCK.tryLock(ruleId, 2000L)) {
            LOGGER.error((Object)"Get UPDATE_NOTIFY_RULE_LOCK failed. ruleId: %s.", new Object[]{ruleId});
            return false;
        }
        try {
            if (startEndTime.length < 2) {
                LOGGER.error((Object)("invalid startEndTime length: " + startEndTime.length + ", expected 2."), 1L);
                boolean bl = false;
                return bl;
            }
            String startTime = startEndTime[0];
            String endTime = startEndTime[1];
            if (ruleId == null) {
                LOGGER.error((Object)"modifyNotifyBaseInfo error,ruleId is null.", 1L);
                boolean bl = false;
                return bl;
            }
            SimpleDateFormat sdfs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long starts = 0L;
            long ends = 0L;
            try {
                starts = sdfs.parse(startTime).getTime();
                ends = sdfs.parse(endTime).getTime();
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, null, (long)1538L, null, (Log)LOGGER);
            }
            long currentTimes = System.currentTimeMillis();
            if (currentTimes >= ends) {
                throw new LegoCheckedException(1565L);
            }
            RemoteNotifyRule remoteNotifyRule = this.remoteNotifyRuleDAO.getRuleByID(ruleId);
            remoteNotifyRule.setUseEnable(useStatus);
            remoteNotifyRule.setDescription(description);
            remoteNotifyRule.setStartTime(starts);
            remoteNotifyRule.setEndTime(ends);
            remoteNotifyRule.setLanguage(language);
            remoteNotifyRule.setSendContent(sendContent);
            result = this.remoteNotifyRuleDAO.modifyBaseRule(remoteNotifyRule);
            this.notifyRuleMap.put(remoteNotifyRule.getId(), remoteNotifyRule);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Fail to modify remoteNotifyRule, ruleId: %s.", new Object[]{ruleId});
            throw e;
        }
        finally {
            UPDATE_NOTIFY_RULE_LOCK.unlock(ruleId);
        }
        return result;
    }

    public boolean modifyNotifyObj(String ruleId, int sendMode, String[] phones, String[] emails) {
        boolean result;
        if (!UPDATE_NOTIFY_RULE_LOCK.tryLock(ruleId, 2000L)) {
            LOGGER.error((Object)"Get UPDATE_NOTIFY_RULE_LOCK failed. ruleId: %s.", new Object[]{ruleId});
            return false;
        }
        try {
            RemoteNotifyRule remoteNotifyRule = this.remoteNotifyRuleDAO.getRuleByID(ruleId);
            remoteNotifyRule.setSmsMode(sendMode);
            StringBuilder phoneBuffer = new StringBuilder();
            for (String phone : phones) {
                phoneBuffer.append(phone);
                phoneBuffer.append("===");
            }
            String smsPhone = phoneBuffer.toString();
            if ("===".equals(smsPhone)) {
                smsPhone = "";
            } else if (!"".equals(smsPhone) && smsPhone.charAt(smsPhone.length() - 1) == ',') {
                smsPhone = smsPhone.substring(0, smsPhone.length() - 1);
            }
            remoteNotifyRule.setSmsPhone(smsPhone);
            StringBuilder emailBuffer = new StringBuilder();
            for (String email : emails) {
                emailBuffer.append(email);
                emailBuffer.append("===");
            }
            String emailTo = emailBuffer.toString();
            if ("===".equals(emailTo)) {
                emailTo = "";
            } else if (emailTo.charAt(emailTo.length() - 1) == ',') {
                emailTo = emailTo.substring(0, emailTo.length() - 1);
            }
            remoteNotifyRule.setEmailTo(emailTo);
            result = this.remoteNotifyRuleDAO.modifyBaseRule(remoteNotifyRule);
            this.notifyRuleMap.put(remoteNotifyRule.getId(), remoteNotifyRule);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Fail to modify remoteNotifyRule, ruleId: %s.", new Object[]{ruleId});
            throw e;
        }
        finally {
            UPDATE_NOTIFY_RULE_LOCK.unlock(ruleId);
        }
        return result;
    }

    public synchronized boolean addAlarm(String ruleId, String[] alarmInfos) {
        if (null == alarmInfos) {
            LOGGER.error((Object)"addAlarm error,alarmInfos is null.", 1L);
            return false;
        }
        RemoteNotifyRule remoteNotifyRule = this.remoteNotifyRuleDAO.getRuleByID(ruleId);
        HashSet<NotifyAlarmItem> alarmSet = new HashSet<NotifyAlarmItem>();
        ArrayList<String> alarmList = new ArrayList<String>();
        for (String alarm : alarmInfos) {
            String[] alarmInfo = alarm.split("\t");
            NotifyAlarmItem notifyAlarmItem = new NotifyAlarmItem();
            try {
                notifyAlarmItem.setAlarmLevel(Integer.parseInt(alarmInfo[0]));
                notifyAlarmItem.setAlarmType(Integer.parseInt(alarmInfo[3]));
            }
            catch (NumberFormatException e) {
                throw new LegoCheckedException(250L, (Throwable)e);
            }
            notifyAlarmItem.setAlarmId(alarmInfo[1]);
            notifyAlarmItem.setAlarmName(alarmInfo[2]);
            notifyAlarmItem.setRemoteNotifyRule(remoteNotifyRule);
            alarmSet.add(notifyAlarmItem);
            alarmList.add(notifyAlarmItem.getAlarmId());
        }
        if (this.notifyRuleMap.isEmpty()) {
            this.init();
        }
        Set<Map.Entry<Long, RemoteNotifyRule>> ruleSet = this.notifyRuleMap.entrySet();
        for (Map.Entry<Long, RemoteNotifyRule> entry : ruleSet) {
            boolean isExist;
            RemoteNotifyRule rule = entry.getValue();
            if (remoteNotifyRule.getId() != rule.getId() || !(isExist = this.checkAlarm(rule, alarmList))) continue;
            throw new LegoCheckedException(1560L);
        }
        boolean result = this.remoteNotifyRuleDAO.addAlarm(alarmSet);
        remoteNotifyRule.getNotifyAlarmItems().addAll(alarmSet);
        this.notifyRuleMap.put(remoteNotifyRule.getId(), remoteNotifyRule);
        return result;
    }

    public synchronized boolean addResource(String ruleId, String[] resources) {
        if (null == resources) {
            LOGGER.error((Object)"addResource error,resources is null.", 1L);
            return false;
        }
        RemoteNotifyRule remoteNotifyRule = this.remoteNotifyRuleDAO.getRuleByID(ruleId);
        HashSet<NotifyResItem> resSet = new HashSet<NotifyResItem>();
        ArrayList<String> resList = new ArrayList<String>();
        for (String res : resources) {
            String[] source = res.split("\t");
            if (source.length < 4) continue;
            NotifyResItem notifyResItem = this.initNotifyResItem(source);
            TopoObject moInfo = this.remoteNotifyRuleDAO.getTopoObjectById(NumberUtil.convertToLong((Object)notifyResItem.getAlarmSource()));
            if (moInfo == null) {
                LOGGER.error((Object)"AddResource error, TopoObject get by moid %s is null.", new Object[]{notifyResItem.getAlarmSource()});
                throw new LegoCheckedException(250L);
            }
            this.extractCheck(notifyResItem, moInfo);
            if (source.length >= 5) {
                notifyResItem.setMoIP(source[4]);
                if (!moInfo.getIpAddress().equals(notifyResItem.getMoIP())) {
                    LOGGER.error((Object)("addResource error, MoIP not equal." + moInfo.getIpAddress() + ":" + notifyResItem.getMoIP()), 1L);
                    throw new LegoCheckedException(250L);
                }
            } else {
                notifyResItem.setMoIP("");
            }
            notifyResItem.setRemoteNotifyRule(remoteNotifyRule);
            resSet.add(notifyResItem);
            resList.add(notifyResItem.getAlarmSource());
        }
        this.checkNotifyRule(remoteNotifyRule, resList);
        boolean result = this.remoteNotifyRuleDAO.addResource(resSet);
        remoteNotifyRule.getNotifyResItems().addAll(resSet);
        this.notifyRuleMap.put(remoteNotifyRule.getId(), remoteNotifyRule);
        return result;
    }

    private void checkNotifyRule(RemoteNotifyRule remoteNotifyRule, List<String> resList) {
        if (this.notifyRuleMap.isEmpty()) {
            this.init();
        }
        Set<Map.Entry<Long, RemoteNotifyRule>> ruleSet = this.notifyRuleMap.entrySet();
        for (Map.Entry<Long, RemoteNotifyRule> entry : ruleSet) {
            boolean isExist;
            RemoteNotifyRule rule = entry.getValue();
            if (remoteNotifyRule.getId() != rule.getId() || !(isExist = this.checkResource(rule, resList))) continue;
            throw new LegoCheckedException(1561L);
        }
    }

    private void extractCheck(NotifyResItem notifyResItem, TopoObject moInfo) {
        if (!moInfo.getName().equals(notifyResItem.getMoName())) {
            LOGGER.error((Object)("addResource error, MoName not equal." + moInfo.getName() + ":" + notifyResItem.getMoName()), 1L);
            throw new LegoCheckedException(250L);
        }
        if (!moInfo.getMainType().equals(notifyResItem.getMoMainType())) {
            LOGGER.error((Object)("addResource error, MainType not equal." + moInfo.getMainType() + ":" + notifyResItem.getMoMainType()), 1L);
            throw new LegoCheckedException(250L);
        }
        if (!moInfo.getSubType().equals(notifyResItem.getMoSubType())) {
            LOGGER.error((Object)("addResource error, MoSubType not equal." + moInfo.getSubType() + ":" + notifyResItem.getMoSubType()), 1L);
            throw new LegoCheckedException(250L);
        }
    }

    private boolean checkResource(RemoteNotifyRule remoteNotifyRule, List<String> resList) {
        for (NotifyResItem notifyResItem : remoteNotifyRule.getNotifyResItems()) {
            if (!resList.contains(notifyResItem.getAlarmSource())) continue;
            this.writeNotifyAlarmLog(resList, notifyResItem.getAlarmSource());
            return true;
        }
        return false;
    }

    private boolean checkAlarm(RemoteNotifyRule remoteNotifyRule, List<String> alarmList) {
        for (NotifyAlarmItem notifyAlarmItem : remoteNotifyRule.getNotifyAlarmItems()) {
            if (!alarmList.contains(notifyAlarmItem.getAlarmId())) continue;
            this.writeNotifyAlarmLog(alarmList, notifyAlarmItem.getAlarmId());
            return true;
        }
        return false;
    }

    private void writeNotifyAlarmLog(List<String> list, String repeatMoOrAlarm) {
        StringBuilder builder = new StringBuilder();
        builder.append("add shield rule fail,repeatMoOrAlarm:");
        builder.append(repeatMoOrAlarm);
        builder.append(",list:");
        for (String moIdOrAlarmId : list) {
            builder.append(moIdOrAlarmId);
            builder.append(",");
        }
        LOGGER.info((Object)builder.toString(), 1L);
    }

    public BatchOperationResult deleteAlarmItem(List<BatchOperation> ids) {
        BatchOperationResult resultx = new BatchOperationResult();
        ArrayList<BatchOperation> resultListx = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (ids != null) {
            operCount = ids.size();
            for (BatchOperation batchOperation : ids) {
                fail = this.deleteSingleAlarm(fail, batchOperation);
                resultListx.add(batchOperation);
            }
            this.init();
        }
        resultx.setResult(resultListx);
        resultx.setFailCount(fail);
        resultx.setTotalCount(operCount);
        resultx.setSucceedCount(operCount - fail);
        return resultx;
    }

    private synchronized int deleteSingleAlarm(int fail, BatchOperation batchOperation) {
        try {
            NotifyAlarmItem notifyAlarmItem = this.remoteNotifyRuleDAO.getAlarmItem(batchOperation.getTargetId());
            if (notifyAlarmItem == null) {
                throw new LegoCheckedException(1554L);
            }
            this.remoteNotifyRuleDAO.deleteAlarmItem(notifyAlarmItem);
        }
        catch (LegoCheckedException e) {
            ++fail;
            batchOperation.setErrorCode(e.getErrorCode());
        }
        catch (LegoUncheckedException e) {
            ++fail;
            batchOperation.setErrorCode(e.getErrorCode());
        }
        return fail;
    }

    public BatchOperationResult deleteResourceItem(List<BatchOperation> ids) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (ids != null) {
            operCount = ids.size();
            for (BatchOperation batchOperation : ids) {
                fail = this.deleteSingleRes(fail, batchOperation);
                resultList.add(batchOperation);
            }
            this.init();
        }
        result.setResult(resultList);
        result.setFailCount(fail);
        result.setTotalCount(operCount);
        result.setSucceedCount(operCount - fail);
        return result;
    }

    private synchronized int deleteSingleRes(int fail, BatchOperation batchOperation) {
        try {
            NotifyResItem notifyResItem = this.remoteNotifyRuleDAO.getResourceItem(batchOperation.getTargetId());
            if (notifyResItem == null) {
                throw new LegoCheckedException(1555L);
            }
            this.remoteNotifyRuleDAO.deleteResourceItem(notifyResItem);
        }
        catch (LegoCheckedException e) {
            ++fail;
            batchOperation.setErrorCode(e.getErrorCode());
        }
        catch (LegoUncheckedException e) {
            ++fail;
            batchOperation.setErrorCode(e.getErrorCode());
        }
        return fail;
    }

    public boolean deleteResourceItem(String alarmSource) {
        List<NotifyResItem> resList = this.remoteNotifyRuleDAO.getResourceItem(alarmSource);
        boolean result = this.remoteNotifyRuleDAO.deleteResourceItems(resList);
        this.init();
        return result;
    }

    public Paging queryAlarmItem(String ruleId, String alarmLevel, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        return this.remoteNotifyRuleDAO.queryAlarmItem(ruleId, alarmLevel, firstRowIndex, totalRow, orderByField, orderByAscend);
    }

    public boolean updateResourceItem(String alarmSource, String moName, String moIp, String moMainType, String moSubType) {
        List<NotifyResItem> resList = this.remoteNotifyRuleDAO.getResourceItem(alarmSource);
        if (resList == null) {
            LOGGER.error((Object)"UpdateResourceItem failed!");
            return false;
        }
        HashSet<NotifyResItem> resSet = new HashSet<NotifyResItem>();
        for (NotifyResItem notifyResItem : resList) {
            notifyResItem.setMoIP(moIp);
            notifyResItem.setMoMainType(moMainType);
            notifyResItem.setMoName(moName);
            notifyResItem.setMoSubType(moSubType);
            resSet.add(notifyResItem);
        }
        return this.remoteNotifyRuleDAO.addResource(resSet);
    }

    public boolean updateNotifyRuleSystemIp(String ip) {
        try {
            FaultApplication faultApp = (FaultApplication)super.getContainer();
            ManagedObject systemMo = faultApp.getLegoSystem();
            this.remoteNotifyRuleDAO.updateResourceIp(ip, systemMo.getMoId());
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("updateNotifyRuleSystemIp fail." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            return false;
        }
    }

    public boolean isExistRuleName(String ruleName) {
        return this.remoteNotifyRuleDAO.isExistRuleName(ruleName);
    }

    private void setEmailAddress(String[] emailToList, RemoteNotifyRule remoteNotifyRule) {
        if (emailToList != null && emailToList.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String email : emailToList) {
                sb.append(email);
                sb.append("===");
            }
            String emailTo = sb.toString();
            if (emailTo.endsWith("===")) {
                emailTo = emailTo.substring(0, emailTo.length() - 3);
            }
            remoteNotifyRule.setEmailTo(emailTo);
        }
    }

    private void setPhone(String[] smsPhoneList, RemoteNotifyRule remoteNotifyRule) {
        if (smsPhoneList != null && smsPhoneList.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String phone : smsPhoneList) {
                sb.append(phone);
                sb.append("===");
            }
            String smsPhone = sb.toString();
            if (smsPhone.endsWith("===")) {
                smsPhone = smsPhone.substring(0, smsPhone.length() - 3);
            }
            remoteNotifyRule.setSmsPhone(smsPhone);
        }
    }

    private void setContent(String[] fields, RemoteNotifyRule remoteNotifyRule) {
        if (fields != null && fields.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String field : fields) {
                sb.append(field);
                sb.append(",");
            }
            String content = sb.toString();
            remoteNotifyRule.setSendContent(content.substring(0, content.length() - 1));
        }
    }

    private void setTime(RemoteNotifyRule remoteNotifyRule, boolean checkEndTime) {
        long currentTime;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            remoteNotifyRule.setStartTime(sdf.parse(remoteNotifyRule.getStartTimeStr()).getTime());
            remoteNotifyRule.setEndTime(sdf.parse(remoteNotifyRule.getEndTimeStr()).getTime());
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, null, (long)1538L, null, (Log)LOGGER);
        }
        if (checkEndTime && (currentTime = System.currentTimeMillis()) >= remoteNotifyRule.getEndTime()) {
            throw new LegoCheckedException(1565L);
        }
    }

    private void setRuleItem(RemoteNotifyRule remoteNotifyRule, String[] resources, String[] alarmInfos) {
        if (this.isNull(resources, alarmInfos)) {
            LOGGER.error((Object)"setRuleItem error,resources is null,or alarmInfos is null.", 1L);
            return;
        }
        for (String res : resources) {
            String[] source = res.split("\t");
            if (source.length < 4) continue;
            NotifyResItem notifyResItem = this.initNotifyResItem(source);
            TopoObject moInfo = this.remoteNotifyRuleDAO.getTopoObjectById(NumberUtil.convertToLong((Object)notifyResItem.getAlarmSource()));
            if (moInfo == null) {
                LOGGER.error((Object)"SetRuleItem error, TopoObject get by moid %s is null.", new Object[]{notifyResItem.getAlarmSource()});
                throw new LegoCheckedException(250L);
            }
            this.handleErrors(notifyResItem, moInfo);
            if (source.length >= 5) {
                notifyResItem.setMoIP(source[4]);
                if (!moInfo.getIpAddress().equals(notifyResItem.getMoIP())) {
                    LOGGER.error((Object)("setRuleItem error, MoIP not equal." + moInfo.getIpAddress() + ":" + notifyResItem.getMoIP()), 1L);
                    throw new LegoCheckedException(250L);
                }
            } else {
                notifyResItem.setMoIP("");
            }
            remoteNotifyRule.getNotifyResItems().add(notifyResItem);
            remoteNotifyRule.setMoMainType(source[3]);
            remoteNotifyRule.setMoSubType(source[2]);
        }
        IFaultDefineService service = (IFaultDefineService)ServiceContext.getInstance().lookup("fault/faultDefineService");
        for (String alarm : alarmInfos) {
            String[] alarmInfo = alarm.split("\t");
            if (!service.checkFaultIsExist(alarmInfo)) {
                throw new LegoCheckedException(250L);
            }
            NotifyAlarmItem notifyAlarmItem = new NotifyAlarmItem();
            try {
                notifyAlarmItem.setAlarmLevel(Integer.parseInt(alarmInfo[0]));
                notifyAlarmItem.setAlarmType(Integer.parseInt(alarmInfo[3]));
            }
            catch (NumberFormatException e) {
                throw new LegoCheckedException(250L, (Throwable)e);
            }
            notifyAlarmItem.setAlarmId(alarmInfo[1]);
            notifyAlarmItem.setAlarmName(alarmInfo[2]);
            remoteNotifyRule.getNotifyAlarmItems().add(notifyAlarmItem);
        }
    }

    private NotifyResItem initNotifyResItem(String[] source) {
        NotifyResItem notifyResItem = new NotifyResItem();
        notifyResItem.setAlarmSource(source[0]);
        notifyResItem.setMoName(source[1]);
        notifyResItem.setMoSubType(source[2]);
        notifyResItem.setMoMainType(source[3]);
        return notifyResItem;
    }

    private void handleErrors(NotifyResItem notifyResItem, TopoObject moInfo) {
        if (!moInfo.getName().equals(notifyResItem.getMoName())) {
            LOGGER.error((Object)String.format(Locale.ROOT, "setRuleItem error, MoName not equal. %s:%s", moInfo.getName(), notifyResItem.getMoName()), 1L);
            throw new LegoCheckedException(250L);
        }
        if (!moInfo.getMainType().equals(notifyResItem.getMoMainType())) {
            LOGGER.error((Object)String.format(Locale.ROOT, "setRuleItem error, MainType not equal. %s:%s", moInfo.getMainType(), notifyResItem.getMoMainType()), 1L);
            throw new LegoCheckedException(250L);
        }
        if (!moInfo.getSubType().equals(notifyResItem.getMoSubType())) {
            LOGGER.error((Object)String.format(Locale.ROOT, "setRuleItem error, MoSubType not equal. %s:%s", moInfo.getSubType(), notifyResItem.getMoSubType()), 1L);
            throw new LegoCheckedException(250L);
        }
    }

    private boolean isNull(String[] resources, String[] alarmInfos) {
        return resources == null || alarmInfos == null;
    }

    public IRemoteNotifyRuleDAO getRemoteNotifyRuleDAO() {
        return this.remoteNotifyRuleDAO;
    }

    public void setRemoteNotifyRuleDAO(IRemoteNotifyRuleDAO remoteNotifyRuleDAO) {
        this.remoteNotifyRuleDAO = remoteNotifyRuleDAO;
    }

    public Paging getRuleAndCountByResName(RemoteNotifyRule ruleParam, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("moName", ruleParam.getRuleName());
        this.updateCreateUserId(ruleParam, condition);
        return this.getRulesAndAllCountByCondition(condition, firstRowIndex, totalRow, orderByField, orderByAscend);
    }

    public Paging getRuleAndCountByName(RemoteNotifyRule ruleParam, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        this.updateCreateUserId(ruleParam, condition);
        condition.put("ruleName", ruleParam.getRuleName());
        return this.getRulesAndAllCountByCondition(condition, firstRowIndex, totalRow, orderByField, orderByAscend);
    }

    private void updateCreateUserId(RemoteNotifyRule ruleParam, Map<String, Object> condition) {
        IUserMgrBaseService mgr = this.getUserMgr();
        User userBaseInfo = mgr.getUserBaseInfo(ruleParam.getCreateUserId());
        if (userBaseInfo == null) {
            LOGGER.error((Object)"User dont exist: %s", new Object[]{String.valueOf(ruleParam.getCreateUserId())});
            throw new LegoCheckedException(1073947393L);
        }
        if (!"true".equals(userBaseInfo.getIsAdmin())) {
            condition.put("createUserId", ruleParam.getCreateUserId());
        }
    }

    private IUserMgrBaseService getUserMgr() {
        Object object = ServiceContext.getInstance().lookup("user/usermgr");
        if (object instanceof IUserMgrBaseService) {
            return (IUserMgrBaseService)object;
        }
        LOGGER.error((Object)"Cant get IUserMgr service.");
        throw new LegoCheckedException(1073947395L);
    }
}

