/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.resource.service;

import com.google.common.collect.ImmutableMap;
import com.huawei.lego.cbb.cloudservice.sdk.model.MultiCloudProjectIdMapping;
import com.huawei.lego.cbb.resource.sdk.service.IResourceExtendService;
import com.huawei.lego.cbb.resource.service.ResourceServiceImpl;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Service(name="com.huawei.lego.cbb.resource.sdk.service.IResourceExtendService", desc="", interfaceClass=IResourceExtendService.class)
public class ResourceExtendServiceImpl
extends ResourceServiceImpl
implements IResourceExtendService {
    private static final Log LOGGER = LogFactory.getInstance(ResourceServiceImpl.class);

    public void saveMultiCloudProjectIdMapping(MultiCloudProjectIdMapping mapping) {
        if (VerifyUtil.isEmpty((Object)mapping)) {
            LOGGER.error((Object)"Mapping is null!");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)mapping.getCenterCloudProjectId()) || VerifyUtil.isEmpty((String)mapping.getRegionCloudProjectId()) || VerifyUtil.isEmpty((String)mapping.getRegionId())) {
            LOGGER.error((Object)"Mapping data is invalid!");
            throw new LegoCheckedException(1073947393L);
        }
        MultiCloudProjectIdMapping mappingInDb = this.getMultiCloudProjectIdMapping(mapping.getCenterCloudProjectId(), mapping.getRegionCloudProjectId(), mapping.getRegionId());
        if (!VerifyUtil.isEmpty((Object)mappingInDb)) {
            LOGGER.debug((Object)"Mapping data is already exist.");
            return;
        }
        this.resourceDao.save((Object)mapping);
    }

    public List<MultiCloudProjectIdMapping> getMultiCloudProjectIdMapping(String projectId) {
        String hql = "FROM MultiCloudProjectIdMapping where centerCloudProjectId = ? or regionCloudProjectId = ?";
        ImmutableMap param = ImmutableMap.of((Object)0, (Object)projectId, (Object)1, (Object)projectId);
        List result = this.resourceDao.findByHql(hql, (Map)param);
        ArrayList<MultiCloudProjectIdMapping> dataList = new ArrayList<MultiCloudProjectIdMapping>();
        if (VerifyUtil.isEmpty((Collection)result)) {
            LOGGER.debug((Object)"No data is found.");
            return dataList;
        }
        result.forEach(item -> {
            if (!(item instanceof MultiCloudProjectIdMapping)) {
                LOGGER.debug((Object)"Invalid data is found.");
                return;
            }
            dataList.add((MultiCloudProjectIdMapping)item);
        });
        return dataList;
    }

    public MultiCloudProjectIdMapping getMultiCloudProjectIdMapping(String centerCloudProjectId, String regionCloudProjectId, String regionId) {
        String hql = "FROM MultiCloudProjectIdMapping where centerCloudProjectId = ? and regionCloudProjectId = ? and regionId = ?";
        ImmutableMap param = ImmutableMap.of((Object)0, (Object)centerCloudProjectId, (Object)1, (Object)regionCloudProjectId, (Object)2, (Object)regionId);
        List result = this.resourceDao.findByHql(hql, (Map)param);
        if (VerifyUtil.isEmpty((Collection)result)) {
            LOGGER.debug((Object)"No data is found.");
            return null;
        }
        Object dataInDb = CommonUtil.getFirstElement((Collection)result);
        if (VerifyUtil.isEmpty((Object)dataInDb) || !(dataInDb instanceof MultiCloudProjectIdMapping)) {
            LOGGER.debug((Object)"No data is found.");
            return null;
        }
        return (MultiCloudProjectIdMapping)dataInDb;
    }
}

