/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service;

import com.huawei.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.cbb.user.service.IUserService;
import com.huawei.lego.cbb.user.service.UserMgrBaseServiceImpl;
import com.huawei.lego.comm.unitepassword.IUnitePasswordSyncAdminMgr;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.base.structure.ILifecycle;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import java.io.Serializable;

@Service(name="usermgr", desc="", interfaceClass=IUserMgr.class)
public class UserMgrImpl
extends UserMgrBaseServiceImpl
implements IUserMgr,
ILifecycle,
Serializable {
    private static final Log LOGGER = LogFactory.getInstance(UserMgrImpl.class);
    private static final long serialVersionUID = 4885017051868053189L;
    private static final String SYNC_ADMIN = "SyncAdmin";
    private static final String SYS_DEFAULT_SYNC_USER_PWD_ISCHANGED = "sys.default.syncUserPwd.ischanged";
    private transient IUserService userService;

    public void updateUserPwdPModel(long userId, String newPwd, int pwdModel, boolean mustModifyPwd) {
        UserInfo userInfo = ((UserMgrBaseServiceImpl)this).userService.getUserInfoById(userId, false);
        super.updateUserInfo(userId, newPwd, pwdModel, mustModifyPwd, userInfo);
        this.modifySyncAdminPwd(newPwd, userInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyPassword(String oldPwd, String newPwd, long userId) {
        UserInfo userInfo = ((UserMgrBaseServiceImpl)this).userService.getUserInfoById(userId, false);
        try {
            super.modifyPassword(oldPwd, newPwd, userId);
            this.modifySyncAdminPwd(newPwd, userInfo);
        }
        finally {
            SecurityUtil.sensitiveClean((String)oldPwd);
            SecurityUtil.sensitiveClean((String)newPwd);
        }
    }

    private void modifySyncAdminPwd(String newPwd, UserInfo userInfo) {
        if (SYNC_ADMIN.equals(userInfo.getUserName())) {
            LOGGER.info((Object)"Modify sync password.");
            this.updateSyncAdminConfig(newPwd);
            IUnitePasswordSyncAdminMgr unitePasswordMgr = (IUnitePasswordSyncAdminMgr)ServiceLocator.getInstance().getService(IUnitePasswordSyncAdminMgr.class);
            unitePasswordMgr.modifySyncAdminPwd(newPwd);
        }
    }
}

