/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service.common;

import com.huawei.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.huawei.lego.cbb.user.service.common.AbstractSystemInitializeUser;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.KmcCompatible;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;

public class SystemInitializeUser
extends AbstractSystemInitializeUser
implements SystemStatusChangedListener,
InitializingBean {
    private static final Log LOGGER = LogFactory.getInstance(SystemInitializeUser.class);
    private static final String SYS_DEFAULT_SYNC_USER_PWD_ISCHANGED = "sys.default.syncUserPwd.ischanged";

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            this.afterPropertiesSet();
        }
    }

    public void afterPropertiesSet() {
        this.initProperty();
        this.initSysUser();
        this.initSysSyncUser();
        this.initSysLoginPolicy();
        this.initAccountProperty();
    }

    private void initAccountProperty() {
        String file = "conf" + File.separator + "account.properties";
        HashMap<String, String> data = new HashMap<String, String>();
        try {
            this.diffSysUser(data);
            LegoConfig.diffDataBaseConfig(data);
            FileUtil.modifyPropFileUsingStr((String)file, data, (String)file);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Update accountPropFile error:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    private void diffSysUser(Map<String, String> data) {
        UserInfo syncUserInfo;
        try {
            syncUserInfo = this.userService.getUserInfoByName("SyncAdmin", false);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"System not exist syncSyncUser.");
            return;
        }
        String enSynUserPwd = LegoBaseConfig.getInstance().getKeyValue("sys.default.syncUserPwd", "");
        if (!KmcCompatible.isDataSame((String)WccEncryptor.decrypt((String)enSynUserPwd), (String)syncUserInfo.getUserPwdSalt(), (String)syncUserInfo.getUserPwd())) {
            data.put(SYS_DEFAULT_SYNC_USER_PWD_ISCHANGED, "true");
        } else {
            data.put(SYS_DEFAULT_SYNC_USER_PWD_ISCHANGED, "false");
        }
    }

    protected String getJarFileName() {
        return AdapterUtils.getClassJarPath(SystemInitializeUser.class);
    }

    protected ClassLoader getClassLoader() {
        return AdapterUtils.getClassLoader(SystemInitializeUser.class);
    }
}

