/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service;

import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.lego.cbb.user.sdk.constant.AccountTypeEnum;
import com.huawei.lego.cbb.user.sdk.hibernate.model.OperationInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.RoleInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserAclInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserCustomSetting;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserLoginPolicyInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserRelMoInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserSecPolicyInfo;
import com.huawei.lego.cbb.user.sdk.model.Role;
import com.huawei.lego.cbb.user.sdk.model.SystemSecPolicy;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.model.UserAcl;
import com.huawei.lego.cbb.user.sdk.model.UserLoginPolicy;
import com.huawei.lego.cbb.user.sdk.model.UserSecPolicy;
import com.huawei.lego.cbb.user.sdk.service.IUserMgrBaseService;
import com.huawei.lego.cbb.user.service.IUserService;
import com.huawei.lego.cbb.user.service.common.ObjectConvertor;
import com.huawei.lego.cbb.user.service.notes.IBroadcastServices;
import com.huawei.lego.cbb.user.service.operation.IOperationService;
import com.huawei.lego.cbb.user.service.roleservice.IRoleService;
import com.huawei.lego.cbb.user.service.security.IAuthorityService;
import com.huawei.lego.cbb.user.service.security.ISecurity;
import com.huawei.lego.cbb.user.service.security.ThirdAuthorityFactory;
import com.huawei.lego.cbb.user.service.usercache.IUserLoginLocalCache;
import com.huawei.lego.cbb.user.service.userrelmo.IUserRelMoService;
import com.huawei.lego.cbb.user.thirdauth.SSOAuthority;
import com.huawei.lego.cbb.user.thirdauth.sdk.UserAuthorityType;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.comm.SortUnit;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.KmcCompatible;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.tree.RootDataElement;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class UserMgrBaseServiceImpl
extends BaseService
implements IUserMgrBaseService {
    protected static final String SYNC_ADMIN = "SyncAdmin";
    private static final Log LOGGER = LogFactory.getInstance(UserMgrBaseServiceImpl.class);
    private static final String DEFAULT_USERNAME = "system";
    private static final String SYS_DEFAULT_SYNC_USER_PWD_ISCHANGED = "sys.default.syncUserPwd.ischanged";
    private static final Integer ERR_PASSWORD_SAMEERROR = 266;
    protected transient IUserService userService;
    protected transient IAuthorityService authorityService;
    private Integer maxUserPasswordHistory;
    private transient SSOAuthority ssoAuthority;
    private transient IRoleService roleService;
    private transient IOperationService operationService;
    private transient IUserLoginLocalCache cacheService;
    private transient IBroadcastServices broadcastServices;
    private transient ISecurity security;
    private transient IUserRelMoService userRelMoService;

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public int addRoleInfo(Role role, List<Long> mapOpts) {
        return this.roleService.addRoleInfo(role, mapOpts);
    }

    public void deleteRole(long roleId) {
        this.roleService.deleteRole(roleId);
    }

    public BatchOperationResult batchDelRoles(List<BatchOperation> list) {
        return this.roleService.batchDelRoles(list);
    }

    public Role getRoleInf(long iroleId) {
        return this.roleService.getRoleInf(iroleId);
    }

    public Role getRoleInf(String roleName) {
        return this.roleService.getRoleInf(roleName);
    }

    public Role getRoleInfRelUser(long iroleId, boolean isFetchUser) {
        return this.roleService.getRoleInfRelUser(iroleId, true);
    }

    public int updataRole(Role orole, List<Long> mapOpts) {
        return this.roleService.updataRole(orole, mapOpts);
    }

    public List<Role> getAllRole() {
        return this.roleService.getAllRoles(false);
    }

    public Paging getAllRole(int start, int length, SortUnit su, AccountTypeEnum accountTypeEnum) {
        return this.getRoleService().getAllRoles(start, length, su, accountTypeEnum);
    }

    public RootDataElement getOptTree(Long roleId) {
        RootDataElement rootDataElement = this.operationService.getOptTree(roleId);
        return rootDataElement;
    }

    public List<OperationInfo> getAllOperation() {
        return this.operationService.getAllOpt();
    }

    public int addUserInfo(User ouserInfo) {
        String userName = ouserInfo.getUserName();
        if (userName.equalsIgnoreCase(DEFAULT_USERNAME)) {
            throw new LegoCheckedException(291L);
        }
        UserInfo userInfo = ObjectConvertor.getUserInfo(ouserInfo);
        if (userInfo.getPasswordModel().intValue() == UserAuthorityType.LOCAL.getValue()) {
            userInfo.setUserPwdSalt("");
            userInfo.setUserPwd(KmcInstance.protectPwdEx((String)userInfo.getUserPwd()));
        }
        Set<UserAclInfo> userAclInfoSet = ObjectConvertor.getUserAclInfo(ouserInfo.getUserAclSet());
        userInfo.setUserAcls(userAclInfoSet);
        userInfo.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        long newUserId = this.userService.addUserInfo(userInfo, ouserInfo.getRolesIdsSet(), ouserInfo.getMoAuthIdsSet(), ouserInfo.getMoGroupIdsSet());
        ouserInfo.setUserId(Long.valueOf(newUserId));
        String userLockKey = "USER_LOCK" + ouserInfo.getUserName();
        String loginFailKey = "USER_LOGIN_FAIL" + userName;
        if (this.cacheService != null) {
            if (this.cacheService.containsKey(userLockKey)) {
                this.cacheService.remove(userLockKey);
            }
            if (this.cacheService.containsKey(loginFailKey)) {
                this.cacheService.remove(loginFailKey);
            }
        }
        try {
            this.broadcastServices.noteAddUser(ouserInfo);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Send message error,msg is %s. ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        return (int)newUserId;
    }

    public synchronized void deleteUser(long userId, long operatorUserId) {
        List<User> onlineUserList = this.getAllOnlineUser(null);
        if (onlineUserList != null && !onlineUserList.isEmpty()) {
            for (User onlineUser : onlineUserList) {
                if (onlineUser.getUserId() != userId) continue;
                throw new LegoCheckedException(285L);
            }
        }
        this.security.unLockUserInCache(userId);
        if (userId != operatorUserId) {
            this.userService.deleteUser(userId);
        }
        try {
            this.broadcastServices.noteDelUser(userId);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Send message error,error msg is %s. ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
    }

    public void deleteUser(Long[] userIds, long operatorUserId) {
        Long[] longArray = userIds;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long userId = longArray[i];
            this.deleteUser(userId, operatorUserId);
        }
        LOGGER.debug((Object)"deleteUser:completed");
    }

    public synchronized BatchOperationResult batchDeleteUser(List<BatchOperation> list, long operatorUserId) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        if (list != null) {
            int operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.deleteUserAndLog(batchOperation, operatorUserId);
                }
                catch (LegoCheckedException ce) {
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                    batchOperation.setDetailParam(ce.getParameters());
                }
                catch (LegoUncheckedException ue) {
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (Exception e) {
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        } else {
            LOGGER.debug((Object)"batchDeleteUser:list is null");
        }
        return result;
    }

    private void deleteUserAndLog(BatchOperation batchOperation, long operatorUserId) {
        long userId = batchOperation.getTargetId();
        List<User> onlineUserList = this.getAllOnlineUser(null);
        if (onlineUserList != null && !onlineUserList.isEmpty()) {
            for (User onlineUser : onlineUserList) {
                if (onlineUser.getUserId() != userId) continue;
                throw new LegoCheckedException(285L);
            }
        }
        this.security.unLockUserInCache(userId);
        if (userId != operatorUserId) {
            this.userService.deleteUser(userId);
            this.userService.setOldUserLog(batchOperation.getTargetName());
        }
        try {
            this.broadcastServices.noteDelUser(userId);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"send message error,msg is %s. ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
    }

    public List<User> getAllUser() {
        List<UserInfo> allUserInfoList = this.userService.getAllUser();
        ArrayList<User> allUserList = new ArrayList<User>();
        if (null != allUserInfoList) {
            LOGGER.debug((Object)"getAllUser:allUserInfoList is not null");
            for (UserInfo userInfo : allUserInfoList) {
                User temp = this.getUser(userInfo, false, true);
                this.updateUserStatus(temp, allUserList);
            }
        }
        return allUserList;
    }

    public long countUser(AccountTypeEnum userType) {
        return this.getUserService().countUser(userType);
    }

    public Paging getAllUser(Map<String, String> map, int istart, int ilength) {
        Paging pag = this.userService.getAllUser(map, istart, ilength);
        List allUserInfoList = pag.getData();
        ArrayList<User> allUserList = new ArrayList<User>();
        for (UserInfo userInfo : allUserInfoList) {
            User temp = this.getUser(userInfo, false, true);
            if (temp == null) continue;
            LOGGER.debug((Object)"getAllUser:temp is not null");
            String userLockKey = "USER_LOCK" + temp.getUserName();
            if (this.cacheService != null && this.cacheService.containsKey(userLockKey, true)) {
                temp.setIsLock("true");
            }
            allUserList.add(temp);
        }
        pag.setData(allUserList);
        return pag;
    }

    private void updateUserStatus(User temp, List<User> allUserList) {
        if (temp != null) {
            String userLockKey = "USER_LOCK" + temp.getUserName();
            if (this.cacheService != null) {
                LOGGER.debug((Object)"updateUserStatus:cacheService is not null");
                if (this.cacheService.containsKey(userLockKey, true)) {
                    temp.setIsLock("true");
                }
            }
            allUserList.add(temp);
        }
    }

    public List<User> getAllUserExt() {
        ArrayList<User> allUserList = new ArrayList<User>();
        User user = new User();
        user.setUserName(DEFAULT_USERNAME);
        user.setDescription(DEFAULT_USERNAME);
        allUserList.add(user);
        List<UserInfo> allUserInfoList = this.userService.getAllUser();
        for (UserInfo userInfo : allUserInfoList) {
            User temp = this.getUser(userInfo, false, true);
            allUserList.add(temp);
        }
        return allUserList;
    }

    private User getUser(UserInfo info, boolean isFetchRole, boolean isBaseUser) {
        User userTemp = ObjectConvertor.getUser(info, isFetchRole, isBaseUser);
        if (userTemp != null && !isBaseUser) {
            LOGGER.debug((Object)"getUser:userTemp is not null");
            List<UserRelMoInfo> relMoList = this.userRelMoService.getUserAllRelMO(info.getId());
            HashSet<Long> moAuthIdsSet = new HashSet<Long>();
            HashSet<Long> moGroupIdsSet = new HashSet<Long>();
            for (UserRelMoInfo userRelMoInfo : relMoList) {
                if (userRelMoInfo.isGroup()) {
                    moGroupIdsSet.add(userRelMoInfo.getId().getMoId());
                    continue;
                }
                moAuthIdsSet.add(userRelMoInfo.getId().getMoId());
            }
            Set userAclInfoSet = info.getUserAcls();
            Set<UserAcl> userAclSet = ObjectConvertor.getUserAcl(userAclInfoSet);
            userTemp.setUserAclSet(userAclSet);
            userTemp.setMoAuthIdsSet(moAuthIdsSet);
            userTemp.setMoGroupIdsSet(moGroupIdsSet);
        }
        return userTemp;
    }

    public User getUserInfo(long id) {
        LOGGER.debug((Object)"getUserInfo");
        UserInfo userInfo = id > 0L ? this.userService.getUserInfoById(id, true) : this.ssoAuthority.create(id, null);
        User temp = this.getUser(userInfo, true, false);
        return temp;
    }

    public User getUserByName(String userName) {
        UserInfo userInfo = this.userService.getUserInfoByName(userName, false);
        User temp = this.getUser(userInfo, false, false);
        if (temp != null) {
            String userPassword = temp.getUserPassword();
            try {
                temp.setUserPassword(KmcInstance.protectPwdEx((String)userPassword));
            }
            catch (Exception ex) {
                LOGGER.error((Object)"encrypt is error,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            }
        }
        return temp;
    }

    public void updateUser(User user) {
        LOGGER.debug((Object)"updateUser");
        this.userService.updateUser(user);
        this.broadcastServices.noteUserChange(user);
    }

    public Set<Integer> getThirdUserAuthType() {
        LOGGER.debug((Object)"getThirdUserAuthType");
        return ThirdAuthorityFactory.getInstance().getAuthorityType();
    }

    public Boolean userLockState(String userName) {
        LOGGER.debug((Object)"userLockState");
        boolean lockState = false;
        String userLockKey = "USER_LOCK" + userName;
        if (this.cacheService != null && this.cacheService.containsKey(userLockKey, true)) {
            lockState = true;
        }
        return lockState;
    }

    public Boolean userLockState(long userId) {
        Boolean lockState = Boolean.FALSE;
        UserInfo userInfotemp = null;
        try {
            userInfotemp = this.userService.getUserInfoById(userId, false);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Method userLockState fail ,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        if (userInfotemp != null) {
            lockState = this.userLockState(userInfotemp.getUserName());
        }
        return lockState;
    }

    public User login(String hostIp, String userName, String pwd, boolean existInDb) {
        User user = null;
        LOGGER.debug((Object)"login authorityService before");
        UserInfo userInfo = this.authorityService.login(hostIp, userName, pwd, existInDb, true);
        LOGGER.debug((Object)"login authorityService end");
        if (userInfo != null) {
            boolean checkLoginIp = this.checkAclIpAddress(userInfo, hostIp);
            if (!checkLoginIp) {
                throw new LegoCheckedException(265L);
            }
            if (!userInfo.isAdmin()) {
                User userFullInfo = this.getUserInfo(userInfo.getId());
                this.checkNbiRole(userFullInfo);
            }
            this.authorityService.checkUserSessionControl(userInfo);
            user = this.setSession(hostIp, existInDb, userInfo);
            if (user != null) {
                user.setMoAuthIdsSet(null);
                user.setMoAutSeth(null);
                user.setMoGroupIdsSet(null);
                user.setMoGroupIdsSet(null);
                user.setRolesIdsSet(null);
                user.setRolesSet(null);
            }
        }
        return user;
    }

    public User login(User user, boolean existInDb) {
        return this.login(user.getIpAdr(), user.getUserName(), user.getUserPassword(), existInDb);
    }

    public User login(String hostIp, String userName, String pwd) {
        return this.login(hostIp, userName, pwd, true);
    }

    public User login(User userInfo) {
        return this.login(userInfo, true);
    }

    protected void checkNbiRole(User userFullInfo) {
        Role role;
        if ("TRUE".equals(userFullInfo.getIsAdmin().toUpperCase(Locale.ROOT))) {
            return;
        }
        Set rolesSet = userFullInfo.getRolesSet();
        if (rolesSet == null) {
            return;
        }
        if (rolesSet.size() == 1 && "NBIROLE".equals((role = (Role)rolesSet.iterator().next()).getRoleName().toUpperCase(Locale.ROOT))) {
            throw new LegoCheckedException(1073947435L);
        }
    }

    private User setSession(String hostIp, boolean existInDb, UserInfo userInfo) {
        User user;
        LOGGER.debug((Object)"login authorityService generateSessionId");
        String sessionId = this.authorityService.generateSessionId(userInfo, hostIp);
        LOGGER.debug((Object)"login authorityService generateSessionId");
        if (existInDb) {
            user = ObjectConvertor.getUser(userInfo, sessionId);
        } else {
            LOGGER.debug((Object)"login create new user");
            user = new User();
            user.setSession(sessionId);
            user.setUserId(userInfo.getId());
            user.setDescription(userInfo.getUserDes());
            user.setUserName(userInfo.getUserName());
            user.setSelectType(userInfo.getSelectResView().intValue());
            user.setPasswordModel(userInfo.getPasswordModel().intValue());
            user.setUserType(AccountTypeEnum.fromValue((int)userInfo.getUserType()));
            this.setUserIsAdmin(userInfo, user);
            user.setMustModifyPwd(userInfo.isMustModiPassword());
            user.setSetTime(userInfo.getSetTime());
            LOGGER.debug((Object)"login create new user end");
        }
        return user;
    }

    private void setUserIsAdmin(UserInfo userInfo, User user) {
        if (userInfo.isAdmin()) {
            user.setIsAdmin("true");
        } else {
            user.setIsAdmin("false");
        }
        if (userInfo.isLock()) {
            user.setIsLock("true");
        } else {
            user.setIsLock("false");
        }
        LOGGER.debug((Object)"setUserIsAdmin:completed");
    }

    public User loginForWos(String userName, String hostIp) {
        Set<UserAclInfo> userAclInfoSet;
        User user = this.getUserByName(userName);
        if (user == null) {
            LOGGER.info((Object)"Get user by name in DB is null");
            return user;
        }
        if ("true".equalsIgnoreCase(user.getIsLock())) {
            throw new LegoCheckedException(293L);
        }
        UserInfo userInfo = ObjectConvertor.getUserInfo(user);
        boolean checkLoginIp = this.checkAclIpAddress(userInfo, hostIp, userAclInfoSet = ObjectConvertor.getUserAclInfo(user.getUserAclSet()));
        if (!checkLoginIp) {
            throw new LegoCheckedException(265L);
        }
        LOGGER.debug((Object)"login authorityService generateSessionId");
        String sessionId = this.authorityService.generateSessionId(userInfo, hostIp);
        LOGGER.debug((Object)"login authorityService generateSessionId");
        user = ObjectConvertor.getUser(userInfo, sessionId);
        user.setMoAuthIdsSet(null);
        user.setMoGroupIdsSet(null);
        user.setMoAutSeth(null);
        user.setMoGroupIdsSet(null);
        user.setRolesIdsSet(null);
        user.setRolesSet(null);
        return user;
    }

    public Set<String> getSSOUserAllOpNames(long roleid) {
        return this.authorityService.getSSOUserAllOpNames(roleid);
    }

    public Boolean checkUserPsw(String userName, String pwd, boolean existInDb) {
        return this.authorityService.checkUserPsw(userName, pwd, existInDb);
    }

    public Boolean checkUserPsw(String userName, String pwd) {
        return this.checkUserPsw(userName, pwd, true);
    }

    public void logout(String sessionId) {
        this.authorityService.logout(sessionId);
    }

    public Boolean checkTimeOut(String sessionId) {
        return this.authorityService.checkTimeout(sessionId, false);
    }

    public Boolean checkTimeOut(String sessionId, boolean prolongTime) {
        return this.authorityService.checkTimeout(sessionId, prolongTime);
    }

    public List<User> getAllOnlineUser(User user) {
        return this.authorityService.getAllOnlineUser(user);
    }

    public List<User> getAllOnlineUser(User user, String sortFile, String sortType) {
        return this.authorityService.getAllOnlineUser(user, sortFile, sortType);
    }

    public Paging getAllOnlineUser(User user, String sortFile, String sortType, int pageStart, int pageSize) {
        Boolean hasRightViewAllOnlineUser;
        Paging paging = new Paging();
        if (user != null && (hasRightViewAllOnlineUser = this.checkUserIsAdmin(user.getUserId())).booleanValue()) {
            user = null;
        }
        List<User> list = this.authorityService.getAllOnlineUser(user, sortFile, sortType);
        ArrayList<User> pagUser = new ArrayList<User>();
        if (list != null && !list.isEmpty()) {
            int listSize = list.size();
            if (listSize >= pageStart + pageSize) {
                for (int index = pageStart; index < pageStart + pageSize; ++index) {
                    pagUser.add(list.get(index));
                }
            } else {
                for (int index = pageStart; index < list.size(); ++index) {
                    pagUser.add(list.get(index));
                }
            }
            paging.setiCount(listSize);
            paging.setData(pagUser);
        }
        LOGGER.debug((Object)"getAllOnlineUser:completed");
        return paging;
    }

    public List<Long> getUserGrandObjects(User userInfo) {
        return this.getUserGrandObjects(userInfo.getUserId());
    }

    public List<Long> getUserGrandObjects(long userId) {
        return this.authorityService.getUserGrandObjects(userId);
    }

    public Boolean checkUserGrandObject(long userId, long moId) {
        return this.authorityService.checkUserGrandObject(userId, moId);
    }

    public void grandObjectToUser(long userId, Set<Long> moIds) {
        this.userRelMoService.addUserRelMo(userId, moIds, null);
        try {
            if (!this.checkUserIsAdmin(userId).booleanValue()) {
                this.broadcastServices.grandObjectToUser(userId, moIds);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("send message erro " + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
        }
    }

    public void unchainObjectToUser(long userId, Set<Long> moIds) {
        this.userRelMoService.deleteUserRelMO(userId, moIds, null);
        try {
            if (!this.checkUserIsAdmin(userId).booleanValue()) {
                this.broadcastServices.unchainObjectToUser(userId, moIds);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Send message error,msg: %s. ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
    }

    public void delManageObject(Set<Long> moIds) {
        this.userRelMoService.deleteManageObject(moIds, null);
    }

    public Boolean checkUserRight(long userId, String opName) {
        return this.authorityService.checkUserRight(userId, opName);
    }

    public Map checkUserRight(long userId, List<String> opNames) {
        return this.authorityService.checkUserRight(userId, opNames);
    }

    public Boolean checkUserIsAdmin(long userId) {
        return this.authorityService.checkUserIsAdmin(userId);
    }

    public Boolean checkUserIsViewAllOperLog(long userId) {
        return this.authorityService.checkUserIsAdmin(userId) != false || this.authorityService.checkUserIsAuditor(userId) || this.authorityService.checkUserIsAdministrator(userId);
    }

    public Boolean checkUserIsAuditor(long userId) {
        return this.authorityService.checkUserIsAuditor(userId);
    }

    public Set<String> getUserAllOpids(User userInfo) {
        return this.getUserAllOpNames(userInfo.getUserId());
    }

    public Set<String> getUserAllOpids(long userId) {
        return this.getUserAllOpNames(userId);
    }

    public Set<String> getUserAllOpNames(long userId) {
        return this.authorityService.getUserAllOpNames(userId);
    }

    public void modifyPassword(User userInfo) {
        UserInfo userInfoTemp = this.userService.getUserInfoById(userInfo.getUserId(), false);
        if (userInfoTemp == null) {
            LOGGER.debug((Object)"modifyPassword:userInfoTemp is null");
            String[] param = new String[]{"lego.lab.usr"};
            throw new LegoCheckedException(204L, param);
        }
        userInfoTemp.setUserPwd(KmcInstance.protectPwdEx((String)userInfo.getUserPassword()));
        userInfoTemp.setUserPwdSalt("");
        userInfoTemp.setMustModiPassword(false);
        this.userService.updateUser(userInfoTemp, true);
    }

    public void modifyPassword(String oldPwd, String newPwd, long userId) {
        LOGGER.debug((Object)"modifyPassword");
        UserInfo userInfo = this.userService.getUserInfoById(userId, true);
        this.authorityService.checkLock(userInfo.getUserName(), userInfo.getUserPwd(), oldPwd, userInfo.getUserPwdSalt());
        if (KmcCompatible.isDataSame((String)newPwd, (String)userInfo.getUserPwdSalt(), (String)userInfo.getUserPwd())) {
            throw new LegoCheckedException((long)ERR_PASSWORD_SAMEERROR.intValue());
        }
        if (this.matchPwdHistory(newPwd, userInfo)) {
            LOGGER.error((Object)"User password match history, userId: %s", new Object[]{String.valueOf(userId)});
            throw new LegoCheckedException(1077949113L, "User password match history.");
        }
        userInfo.setUserPwd(KmcInstance.protectPwdEx((String)newPwd));
        userInfo.setUserPwdSalt("");
        userInfo.setMustModiPassword(false);
        this.saveOrUpdatePwdHistory(userInfo);
        this.userService.updateUser(userInfo, true);
    }

    public void updateUserPwdPModel(long userId, String newPwd, int pwdModel) {
        this.updateUserPwdPModel(userId, newPwd, pwdModel, false);
        LOGGER.debug((Object)"updateUserPwdPModel:completed");
    }

    public void updateUserPwdPModel(long userId, String newPwd, int pwdModel, boolean mustModifyPwd) {
        UserInfo userInfo = this.userService.getUserInfoById(userId, false);
        this.updateUserInfo(userId, newPwd, pwdModel, mustModifyPwd, userInfo);
    }

    protected void updateUserInfo(long userId, String newPwd, int pwdModel, boolean mustModifyPwd, UserInfo userInfo) {
        boolean isUpdateSetTime = false;
        if (StringUtils.isNotEmpty((CharSequence)newPwd)) {
            userInfo.setUserPwd(KmcInstance.protectPwdEx((String)newPwd));
            userInfo.setUserPwdSalt("");
            isUpdateSetTime = true;
        }
        if (this.matchPwdHistory(newPwd, userInfo)) {
            LOGGER.error((Object)"User password match history, userId: %s", new Object[]{String.valueOf(userId)});
            throw new LegoCheckedException(1077949113L, "User password match history.");
        }
        userInfo.setMustModiPassword(mustModifyPwd);
        userInfo.setPasswordModel(Integer.valueOf(pwdModel));
        this.saveOrUpdatePwdHistory(userInfo);
        this.userService.updateUser(userInfo, isUpdateSetTime);
        if (SYNC_ADMIN.equals(userInfo.getUserName())) {
            this.updateSyncAdminConfig(newPwd);
        }
    }

    protected void updateSyncAdminConfig(String newPwd) {
        String enPwd = LegoBaseConfig.getInstance().getKeyValue("sys.default.syncUserPwd", "");
        String file = "conf" + File.separator + "account.properties";
        HashMap<String, String> data = new HashMap<String, String>();
        if (newPwd.equals(WccEncryptor.decrypt((String)enPwd))) {
            data.put(SYS_DEFAULT_SYNC_USER_PWD_ISCHANGED, "false");
        } else {
            data.put(SYS_DEFAULT_SYNC_USER_PWD_ISCHANGED, "true");
        }
        try {
            FileUtil.modifyPropFileUsingStr((String)file, data, (String)file);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Update accountPropFile error:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, "Update accountPropFile error");
        }
    }

    protected void saveOrUpdatePwdHistory(UserInfo userInfo) {
        String pwdHistory = userInfo.getUserPwdHistory();
        if (VerifyUtil.isEmpty((String)pwdHistory)) {
            userInfo.setUserPwdHistory(userInfo.getUserPwd());
            return;
        }
        String[] histories = pwdHistory.split(" ");
        if (histories.length < this.getMaxUserPasswordHistory()) {
            userInfo.setUserPwdHistory(pwdHistory + " " + userInfo.getUserPwd());
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (int index = 1; index < histories.length; ++index) {
            builder.append(histories[index]).append(" ");
        }
        builder.append(userInfo.getUserPwd());
        userInfo.setUserPwdHistory(builder.toString());
    }

    private boolean matchPwdHistory(String newPwd, UserInfo userInfo) {
        String[] histories;
        String pwdHistory = userInfo.getUserPwdHistory();
        if (VerifyUtil.isEmpty((String)pwdHistory)) {
            return false;
        }
        for (String history : histories = pwdHistory.split(" ")) {
            if (!KmcCompatible.isDataSame((String)newPwd, (String)userInfo.getUserPwdSalt(), (String)history)) continue;
            return true;
        }
        return false;
    }

    public void updateUserPwdPModelSuper(long userId, String newPwd, long currentUserid, String currentPwd, int pwdModel, boolean mustModifyPwd) {
        LOGGER.debug((Object)"updateUserPwdPModelSuper");
        UserInfo currentuser = this.userService.getUserInfoById(currentUserid, false);
        this.authorityService.checkLockSuper(currentuser.getUserName(), currentuser.getUserPwd(), currentPwd, currentuser.getUserPwdSalt());
        UserInfo userInfo = this.userService.getUserInfoById(userId, false);
        boolean isUpdateSetTime = false;
        if (StringUtils.isNotEmpty((CharSequence)newPwd)) {
            userInfo.setUserPwd(KmcInstance.protectPwdEx((String)newPwd));
            userInfo.setUserPwdSalt("");
            isUpdateSetTime = true;
        }
        userInfo.setMustModiPassword(mustModifyPwd);
        userInfo.setPasswordModel(Integer.valueOf(pwdModel));
        this.userService.updateUser(userInfo, isUpdateSetTime);
    }

    public void resetPassword(User userInfo) {
        LOGGER.debug((Object)"resetPassword(User)");
        UserInfo userInfoTemp = this.userService.getUserInfoById(userInfo.getUserId(), false);
        userInfoTemp.setUserPwd(KmcInstance.protectPwdEx((String)userInfo.getUserPassword()));
        userInfoTemp.setUserPwdSalt("");
        userInfoTemp.setMustModiPassword(false);
        this.userService.updateUser(userInfoTemp, true);
    }

    public void resetPassword(String newPwd, long userId) {
        LOGGER.debug((Object)"resetPassword");
        UserInfo userInfoTemp = this.userService.getUserInfoById(userId, false);
        userInfoTemp.setUserPwd(KmcInstance.protectPwdEx((String)newPwd));
        userInfoTemp.setUserPwdSalt("");
        userInfoTemp.setMustModiPassword(false);
        this.userService.updateUser(userInfoTemp, true);
    }

    public void lockUser(User userInfo) {
        this.security.lockUser(userInfo.getUserId());
    }

    public void lockUser(long userId) {
        this.security.lockUser(userId);
    }

    public void lockUser(Long[] userIds) {
        if (userIds != null) {
            LOGGER.debug((Object)"lockUser:userIds is not null");
            Long[] longArray = userIds;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long userId = longArray[i];
                this.security.lockUser(userId);
            }
        }
    }

    public BatchOperationResult lockUser(List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (list != null) {
            operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.lockAndOnlineUser(batchOperation);
                }
                catch (LegoCheckedException ce) {
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (Exception e) {
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        } else {
            LOGGER.debug((Object)"lockUser:list is null");
        }
        return result;
    }

    public void unLockUser(User userInfo) {
        this.security.unLockUser(userInfo.getUserId());
    }

    public void unLockUser(long userId) {
        this.security.unLockUser(userId);
    }

    public void unLockUser(Long[] userIds) {
        if (userIds != null) {
            LOGGER.debug((Object)"unLockUser:userIds is not null");
            Long[] longArray = userIds;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long userId = longArray[i];
                this.security.unLockUser(userId);
            }
        }
    }

    public BatchOperationResult unLockUser(List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        if (list != null) {
            int operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.unLockUser(batchOperation.getTargetId());
                }
                catch (LegoCheckedException ce) {
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (Exception e) {
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        } else {
            LOGGER.debug((Object)"unLockUser:list is null");
        }
        return result;
    }

    private void lockAndOnlineUser(BatchOperation batchOperation) {
        this.lockUser(batchOperation.getTargetId());
        List<String> onLineUserSessionList = this.authorityService.getOnlineUserSession(batchOperation.getTargetId());
        if (onLineUserSessionList != null && !onLineUserSessionList.isEmpty()) {
            for (String onLineUserSession : onLineUserSessionList) {
                this.logout(onLineUserSession);
            }
        }
    }

    public void forceLogout(String sessionId) {
        this.logout(sessionId);
    }

    public SystemSecPolicy getSystemSecPolicy() {
        SystemSecPolicy secPolicy = new SystemSecPolicy();
        UserSecPolicy userPolicy = this.getUserSecPolicy();
        UserLoginPolicy loginPolicy = this.getLoginPolicy();
        secPolicy.setUserSecPolicy(userPolicy);
        secPolicy.setUserLoginPolicy(loginPolicy);
        return secPolicy;
    }

    public void updateSystemSecPolicy(SystemSecPolicy policy) {
        UserSecPolicy userPolicy = policy.getUserSecPolicy();
        UserLoginPolicy loginPolicy = policy.getUserLoginPolicy();
        this.updateUserSecPolicy(userPolicy);
        this.updateLoginPolicy(loginPolicy);
    }

    public UserLoginPolicy getLoginPolicy() {
        UserLoginPolicyInfo info = this.security.getLoginPolicy();
        return ObjectConvertor.getUserLoginPolicy(info);
    }

    public void updateLoginPolicy(UserLoginPolicy policy) {
        UserLoginPolicyInfo info = ObjectConvertor.getUserLoginPolicy(policy);
        this.security.updateLoginPolicy(info);
        LOGGER.debug((Object)"updateLoginPolicy:completed");
    }

    public UserSecPolicy getUserSecPolicy() {
        UserSecPolicyInfo info = this.security.getUserSecPolicy();
        return ObjectConvertor.getUserSecPolicy(info);
    }

    public void updateUserSecPolicy(UserSecPolicy policy) {
        UserSecPolicyInfo info = ObjectConvertor.getUserSecPolicy(policy);
        this.security.updateUserSecPolicy(info);
        LOGGER.debug((Object)"updateUserSecPolicy:completed");
    }

    public boolean lowerLogin(String upperIp, String upperUsername, String upperPwd) {
        UserInfo userinfo = this.authorityService.loginForUpNms(upperIp, upperUsername, upperPwd, true);
        if (userinfo == null) {
            LOGGER.debug((Object)"lowerLogin:userinfo is null");
            return false;
        }
        return true;
    }

    public List<String> getAllUserAuthority() {
        return this.userService.getAllUserAuthority();
    }

    public User loginForUpNms(User user, boolean existInDb) {
        return this.loginForUpNms(user.getIpAdr(), user.getUserName(), user.getUserPassword(), existInDb);
    }

    public User loginForUpNms(String hostIp, String userName, String pwd, boolean existInDb) {
        User user = null;
        UserInfo userInfo = this.authorityService.loginForUpNms(hostIp, userName, pwd, existInDb);
        if (userInfo != null) {
            boolean checkLoginIp = this.checkAclIpAddress(userInfo, hostIp);
            if (!checkLoginIp) {
                throw new LegoCheckedException(265L);
            }
            user = this.setSession(hostIp, existInDb, userInfo);
            if (user != null) {
                user.setMoAuthIdsSet(null);
                user.setMoAutSeth(null);
                user.setMoGroupIdsSet(null);
                user.setMoGroupIdsSet(null);
                user.setRolesIdsSet(null);
                user.setRolesSet(null);
            }
        }
        return user;
    }

    public void checkRDUser(String username) {
        Set curroleset;
        UserInfo userInfo;
        if ("true".equals(LegoProperties.getProperty((String)"isCreateRDUser", (String)""))) {
            return;
        }
        try {
            userInfo = this.userService.getUserInfoByName(username, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)"The user is not exist");
            return;
        }
        if (userInfo != null && (curroleset = userInfo.getRolesSet()) != null) {
            this.checkRdRole(curroleset);
        }
    }

    private void checkRdRole(Set<RoleInfo> curroleset) {
        for (RoleInfo temprole : curroleset) {
            if (!LegoProperties.getProperty((String)"RD.custom.role", (String)"").equals(temprole.getRoleName())) continue;
            LOGGER.warn((Object)"checkRdRole error.");
            throw new LegoCheckedException(2603L);
        }
    }

    public void updateUserCustomSettings(long userId, Set<UserCustomSetting> updatedSettings) {
        UserInfo userInfoTemp = this.userService.getUserInfoById(userId, false);
        HashSet<UserCustomSetting> settings = userInfoTemp.getUserCustomSettings();
        if (settings == null) {
            LOGGER.debug((Object)"updateUserCustomSettings:settings is null");
            settings = new HashSet<UserCustomSetting>();
        }
        VerifyUtil.generalCheckLength(updatedSettings);
        HashMap<String, UserCustomSetting> existedSettings = new HashMap<String, UserCustomSetting>();
        for (UserCustomSetting setting : settings) {
            existedSettings.put(setting.getItemName(), setting);
        }
        for (UserCustomSetting setting : updatedSettings) {
            String itemName = setting.getItemName();
            String itemValue = setting.getItemValue();
            UserCustomSetting existedSetting = (UserCustomSetting)existedSettings.get(itemName);
            if (existedSetting == null) {
                existedSetting = new UserCustomSetting();
                settings.add(existedSetting);
                existedSetting.setItemName(itemName);
                existedSetting.setUser(userInfoTemp);
            }
            existedSetting.setItemValue(itemValue);
        }
        this.userService.updateUser(userInfoTemp, false);
    }

    public Set<UserCustomSetting> getUserCustomSettings(long userId) {
        UserInfo userInfotemp = this.userService.getUserInfoById(userId, false);
        return userInfotemp.getUserCustomSettings();
    }

    public boolean checkAclIpAddress(String userName, String ipAddress) {
        UserInfo userInfo = this.userService.getUserInfoByName(userName, false);
        return this.checkAclIpAddress(userInfo, ipAddress);
    }

    private boolean checkAclIpAddress(UserInfo userInfo, String ipAddress) {
        return this.checkAclIpAddress(userInfo, ipAddress, userInfo.getUserAcls());
    }

    private boolean checkAclIpAddress(UserInfo userInfo, String ipAddress, Set<UserAclInfo> userAcls) {
        boolean allowedAddress = userInfo.isAdmin() && AddressUtil.checkLocalIP((String)ipAddress) ? true : this.security.checkIP(ipAddress, userAcls);
        return allowedAddress;
    }

    public boolean adminAuth(String userName, String pwd) {
        return !VerifyUtil.isEmpty((Object)this.authorityService.login("", pwd, userName));
    }

    public User getUserBaseInfoByName(String userName) {
        UserInfo userInfo = this.userService.getUserInfoByName(userName, false);
        return this.getUser(userInfo, false, true);
    }

    public User getUserBaseInfo(long id) {
        UserInfo userInfo = this.userService.getUserInfoById(id, true);
        User user = this.getUser(userInfo, true, false);
        user.setUserPassword(null);
        user.setUserPasswordSalt(null);
        return user;
    }

    public void setRoleService(IRoleService roleService) {
        this.roleService = roleService;
    }

    public IRoleService getRoleService() {
        return this.roleService;
    }

    public Integer getMaxUserPasswordHistory() {
        return this.maxUserPasswordHistory;
    }

    public void setMaxUserPasswordHistory(Integer maxUserPasswordHistory) {
        this.maxUserPasswordHistory = maxUserPasswordHistory;
    }

    public SSOAuthority getSsoAuthority() {
        return this.ssoAuthority;
    }

    public void setSsoAuthority(SSOAuthority ssoAuthority) {
        this.ssoAuthority = ssoAuthority;
    }

    public IOperationService getOperationService() {
        return this.operationService;
    }

    public void setOperationService(IOperationService operationService) {
        this.operationService = operationService;
    }

    public void setUserService(IUserService userService) {
        this.userService = userService;
    }

    public IUserService getUserService() {
        return this.userService;
    }

    public void setCacheService(IUserLoginLocalCache cacheService) {
        this.cacheService = cacheService;
    }

    public IUserLoginLocalCache getCacheService() {
        return this.cacheService;
    }

    public void setBroadcastServices(IBroadcastServices broadcastServices) {
        this.broadcastServices = broadcastServices;
    }

    public IBroadcastServices getBroadcastServices() {
        return this.broadcastServices;
    }

    public ISecurity getSecurity() {
        return this.security;
    }

    public void setSecurity(ISecurity security) {
        this.security = security;
    }

    public IUserRelMoService getUserRelMoService() {
        return this.userRelMoService;
    }

    public void setUserRelMoService(IUserRelMoService userRelMoService) {
        this.userRelMoService = userRelMoService;
    }

    public IAuthorityService getAuthorityService() {
        return this.authorityService;
    }

    public void setAuthorityService(IAuthorityService authorityService) {
        this.authorityService = authorityService;
    }
}

