/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service.common;

import com.huawei.lego.cbb.user.sdk.constant.AccountTypeEnum;
import com.huawei.lego.cbb.user.sdk.hibernate.model.OperationInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.RoleInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserAclInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserCustomSetting;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserLoginPolicyInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserSecPolicyInfo;
import com.huawei.lego.cbb.user.sdk.model.OptAuth;
import com.huawei.lego.cbb.user.sdk.model.Role;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.model.UserAcl;
import com.huawei.lego.cbb.user.sdk.model.UserLoginPolicy;
import com.huawei.lego.cbb.user.sdk.model.UserSecPolicy;
import com.huawei.lego.cbb.user.thirdauth.sdk.UserAuthorityType;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class ObjectConvertor {
    private static final Log LOGGER = LogFactory.getInstance(ObjectConvertor.class);

    private ObjectConvertor() {
    }

    public static UserInfo getUserInfo(User user) {
        UserInfo userInfo = new UserInfo();
        if (user != null) {
            userInfo.setId(user.getUserId());
            userInfo.setUserDes(user.getDescription());
            userInfo.setUserName(user.getUserName());
            userInfo.setSelectResView(Integer.valueOf(user.getSelectType()));
            userInfo.setSessionControl(user.getSessionControl());
            userInfo.setSessionLimit(user.getSessionLimit());
            userInfo.setUserType(Integer.valueOf(user.getUserType().getType()));
            int passwordModle = user.getPasswordModel();
            if (passwordModle == UserAuthorityType.LOCAL.getValue()) {
                userInfo.setUserPwd(user.getUserPassword());
                userInfo.setUserPwdSalt(user.getUserPasswordSalt());
            }
            userInfo.setPasswordModel(Integer.valueOf(passwordModle));
            if (user.getIsAdmin() == null || "".equals(user.getIsAdmin())) {
                userInfo.setAdmin(false);
            } else if ("true".equals(user.getIsAdmin())) {
                userInfo.setAdmin(true);
            } else {
                userInfo.setAdmin(false);
            }
            if ("1".equals(user.getDefaultUser())) {
                userInfo.setDefaultUser("1");
            }
            userInfo.setMustModiPassword(user.isMustModifyPwd());
            userInfo.setSetTime(user.getSetTime());
        }
        return userInfo;
    }

    public static User getUser(UserInfo userInfo, String sessionId) {
        User user = ObjectConvertor.getUser(userInfo, false, false);
        if (user != null) {
            user.setSession(sessionId);
        }
        return user;
    }

    public static User getUser(UserInfo userInfo, boolean isFetchRole, boolean isBaseUserInfo) {
        User user = null;
        if (userInfo != null) {
            user = new User();
            user.setUserId(userInfo.getId());
            user.setDescription(userInfo.getUserDes());
            user.setUserName(userInfo.getUserName());
            user.setSelectType(userInfo.getSelectResView().intValue());
            user.setSessionControl(userInfo.isSessionControl());
            user.setSessionLimit(userInfo.getSessionLimit());
            int passwordModle = userInfo.getPasswordModel();
            if (!isBaseUserInfo && passwordModle == UserAuthorityType.LOCAL.getValue()) {
                user.setUserPassword(userInfo.getUserPwd());
                user.setUserPasswordSalt(userInfo.getUserPwdSalt());
            }
            user.setPasswordModel(passwordModle);
            if ("1".equals(userInfo.getDefaultUser())) {
                user.setDefaultUser("1");
            }
            if (userInfo.isAdmin()) {
                user.setIsAdmin("true");
            } else {
                user.setIsAdmin("false");
            }
            if (userInfo.isLock()) {
                user.setIsLock("true");
            } else {
                user.setIsLock("false");
            }
            user.setMustModifyPwd(userInfo.isMustModiPassword());
            ObjectConvertor.processRoleInfo(isFetchRole, user, userInfo);
            user.setSetTime(userInfo.getSetTime());
            user.setUserType(AccountTypeEnum.fromValue((int)userInfo.getUserType()));
        }
        return user;
    }

    private static void processRoleInfo(boolean isFetchRole, User user, UserInfo userInfo) {
        if (isFetchRole) {
            user.getRolesSet().clear();
            Set uerinfoRoleSet = userInfo.getRolesSet();
            if (uerinfoRoleSet != null) {
                for (RoleInfo roleInfo : uerinfoRoleSet) {
                    Role roleTemp = ObjectConvertor.translateBoRoleInfo(roleInfo, false);
                    user.getRolesSet().add(roleTemp);
                }
            }
        }
    }

    public static Role translateBoRoleInfo(RoleInfo roleInfo, boolean isFetchOperat) {
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "TranslateBoRoleInfo:isFetchOperat is %s.", isFetchOperat));
        Role role = new Role();
        role.setCreaterID(roleInfo.getCreatorId());
        role.setRoleId(roleInfo.getRoleIdx());
        role.setCreateTime(roleInfo.getCreatTime());
        role.setRoleDes(roleInfo.getRoleDescription());
        role.setRoleName(roleInfo.getRoleName());
        role.setRoleType(AccountTypeEnum.fromValue((int)roleInfo.getRoleType()));
        if (roleInfo.isDefault()) {
            role.setDefaultStr("true");
        } else {
            role.setDefaultStr("false");
        }
        if (role.getOptsSet() == null) {
            HashSet theSet = new HashSet();
            role.setOptsSet(theSet);
        } else {
            role.getOptsSet().clear();
        }
        return role;
    }

    public static OptAuth translateBoOperation(OperationInfo optInfo) {
        OptAuth tmpOpt = new OptAuth();
        tmpOpt.setiOptID(optInfo.getOpId().longValue());
        tmpOpt.setSerialNumber(optInfo.getSerialNumber());
        tmpOpt.setOptName(optInfo.getOpName());
        tmpOpt.setUrl(optInfo.getOpURL());
        tmpOpt.setMaster(optInfo.isMaster());
        return tmpOpt;
    }

    public static RoleInfo translatePoRole(Role role) {
        RoleInfo tmpRoleInfo = new RoleInfo();
        tmpRoleInfo.setCreatorId(role.getCreaterID());
        tmpRoleInfo.setRoleIdx(role.getRoleId());
        tmpRoleInfo.setCreatTime(role.getCreateTime());
        tmpRoleInfo.setRoleDescription(role.getRoleDes());
        tmpRoleInfo.setRoleName(role.getRoleName());
        tmpRoleInfo.setRoleType(Integer.valueOf(role.getRoleType().getType()));
        if (role.getDefaultStr() == null || "".equals(role.getDefaultStr())) {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "TranslatePoRole:defaultStr is %s.", role.getDefaultStr()));
            tmpRoleInfo.setDefault(false);
        } else if ("true".equals(role.getDefaultStr())) {
            tmpRoleInfo.setDefault(true);
        } else {
            tmpRoleInfo.setDefault(false);
        }
        ObjectConvertor.setOperationSet(role, tmpRoleInfo);
        return tmpRoleInfo;
    }

    private static void setOperationSet(Role role, RoleInfo tmpRoleInfo) {
        OperationInfo tmpOptInfo = new OperationInfo();
        if (role.getOptsSet() != null) {
            if (tmpRoleInfo.getOperationSet() == null) {
                LOGGER.debug((Object)"setOperationSet:operationSet is null");
                HashSet theSet = new HashSet();
                tmpRoleInfo.setOperationSet(theSet);
            } else {
                tmpRoleInfo.getOperationSet().clear();
            }
            for (OptAuth tmpOpt : role.getOptsSet()) {
                tmpOptInfo.setOpId(Long.valueOf(tmpOpt.getiOptID()));
                tmpOptInfo.setSerialNumber(tmpOpt.getSerialNumber());
                tmpOptInfo.setOpName(tmpOpt.getOptName());
                tmpOptInfo.setOpURL(tmpOpt.getUrl());
                tmpOptInfo.setMaster(tmpOpt.isMaster());
                tmpRoleInfo.getOperationSet().add(tmpOptInfo);
            }
        }
    }

    public static Set<UserAclInfo> getUserAclInfo(Set<UserAcl> infoSet) {
        HashSet<UserAclInfo> set = new HashSet<UserAclInfo>();
        if (infoSet == null) {
            LOGGER.debug((Object)"getUserAclInfo:infoSet is null");
            return set;
        }
        for (UserAcl info : infoSet) {
            UserAclInfo userAclInfo = new UserAclInfo();
            long aclId = info.getUserAclId();
            if (aclId != 0L) {
                userAclInfo.setId(Long.valueOf(aclId));
            }
            String startIp = info.getStartIpStr();
            String endIp = info.getEndIpStr();
            userAclInfo.setStartIp(startIp);
            userAclInfo.setEndIp(endIp);
            userAclInfo.setDes(info.getDes());
            set.add(userAclInfo);
        }
        return set;
    }

    public static Set<UserAcl> getUserAcl(Set<UserAclInfo> userAclInfoSet) {
        HashSet<UserAcl> userAclSet = new HashSet<UserAcl>();
        if (userAclInfoSet == null) {
            LOGGER.debug((Object)"getUserAcl:userAclInfoSet is null");
            return userAclSet;
        }
        for (UserAclInfo info : userAclInfoSet) {
            UserAcl userAcl = new UserAcl();
            if (info == null) continue;
            long aclId = info.getId();
            userAcl.setUserAclId(aclId);
            String startIp = info.getStartIp();
            String endIp = info.getEndIp();
            userAcl.setEndIpStr(endIp);
            userAcl.setStartIpStr(startIp);
            userAcl.setDes(info.getDes());
            userAclSet.add(userAcl);
        }
        return userAclSet;
    }

    public static UserLoginPolicy getUserLoginPolicy(UserLoginPolicyInfo info) {
        UserLoginPolicy policy = null;
        if (info != null) {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "GetUserLoginPolicy:UserLoginPolicyInfo is %s.", info.getId()));
            policy = new UserLoginPolicy();
            long policyId = info.getId();
            if (policyId > 0L) {
                policy.setId(policyId);
            }
            policy.setLgoinCount(info.getLgoinCount().intValue());
            policy.setDes(info.getDes());
            policy.setLockTime(info.getLockTime().intValue());
            policy.setUnseal(info.getUnseal().intValue());
            policy.setSessionTimeOut(info.getSessionTimeOut().intValue());
            policy.setLgoinInterval(info.getLgoinInterval().intValue());
        }
        return policy;
    }

    public static UserLoginPolicyInfo getUserLoginPolicy(UserLoginPolicy info) {
        UserLoginPolicyInfo policy = null;
        if (info != null) {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "GetUserLoginPolicyInfo:UserLoginPolicy is %s.", info.getId()));
            policy = new UserLoginPolicyInfo();
            long policyId = info.getId();
            if (policyId > 0L) {
                policy.setId(Long.valueOf(policyId));
            }
            policy.setDes(info.getDes());
            policy.setLgoinCount(Integer.valueOf(info.getLgoinCount()));
            policy.setUnseal(Integer.valueOf(info.getUnseal()));
            policy.setLockTime(Integer.valueOf(info.getLockTime()));
            policy.setSessionTimeOut(Integer.valueOf(info.getSessionTimeOut()));
            policy.setLgoinInterval(Integer.valueOf(info.getLgoinInterval()));
        }
        return policy;
    }

    public static UserSecPolicy getUserSecPolicy(UserSecPolicyInfo info) {
        UserSecPolicy policy = null;
        if (info != null) {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "GetUserSecPolicy:UserSecPolicyInfo is %s.", info.getId()));
            policy = new UserSecPolicy();
            long policyId = info.getId();
            if (policyId > 0L) {
                policy.setId(info.getId());
            }
            policy.setPswLenth(info.getPswLenth());
            policy.setComplex(info.getComplex());
            policy.setUnseal(info.getUnseal());
            policy.setUsefulLife(info.getUsefulLife());
            policy.setMinlifetime(info.getMinlifetime());
        }
        return policy;
    }

    public static UserSecPolicyInfo getUserSecPolicy(UserSecPolicy info) {
        UserSecPolicyInfo policy = null;
        if (info != null) {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "GetUserSecPolicyInfo:UserSecPolicy is %s.", info.getId()));
            policy = new UserSecPolicyInfo();
            long policyId = info.getId();
            if (policyId > 0L) {
                policy.setId(info.getId());
            }
            policy.setComplex(info.getComplex());
            policy.setPswLenth(info.getPswLenth());
            policy.setUnseal(info.getUnseal());
            policy.setUsefulLife(info.getUsefulLife());
            policy.setMinlifetime(info.getMinlifetime());
        }
        return policy;
    }

    public static String getRoleBoProByRoleVoPro(String roleVoProName) {
        if ("sRoleName".equals(roleVoProName)) {
            return "roleName";
        }
        if ("sRoleDes".equals(roleVoProName)) {
            return "roleDescription";
        }
        if ("iRoleID".equals(roleVoProName)) {
            return "roleIdx";
        }
        return "roleName";
    }

    public static UserCustomSetting getUserCustomSetting(UserInfo userInfotemp, String itemName) {
        Set settings;
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "ItemName is %s.", itemName));
        UserCustomSetting existedSetting = null;
        if (userInfotemp != null && (settings = userInfotemp.getUserCustomSettings()) != null) {
            for (UserCustomSetting setting : settings) {
                if (!itemName.equals(setting.getItemName())) continue;
                existedSetting = setting;
                break;
            }
        }
        return existedSetting;
    }
}

